program make_initial
! ͥǡ.

  use gtool_history
  use Algebra
  use Phys_Const

  implicit none

  integer :: nr, ntheta
  integer :: i, j
  real, allocatable, dimension(:) :: ri, thetai
  real, allocatable, dimension(:,:) :: vb, hb, ub, fv
  real, parameter :: rmin=-1000000.0, dr=100000.0, r0=100000.0, coril=1.0e-5, hmin=1.0e3
  real, parameter :: vmax=10.0, dtheta=100000.0
  character(80) :: finame, fname
  character(1) :: data_flag, radial_flag

!-- ͥե̾

  write(*,*) "input the initial file name."
  read(*,*) finame

!-- ®ʬۥեɤ߹ depth ׻뤫,
!-- ؿѤ®,  depth ׻뤫䤤

  write(*,*) "You have velocity data [Y/N]."
  read(*,*) data_flag

  if(data_flag=='Y')then
     write(*,*) "input file name and radial grid number."
     read(*,*) fname, nr
     write(*,*) "radial flow is forced to zero ? [Y/N]."
     read(*,*) radial_flag
  else
     nr=1000
     ntheta=100
  end if

  allocate(ri(nr))
  allocate(thetai(ntheta))
  allocate(vb(ntheta,nr))
  allocate(ub(ntheta,nr))
  allocate(hb(ntheta,nr))

!-- ɸѿ

  if(data_flag=='Y')then
     call HistoryGet( trim(fname), 'r', ri )
     call HistoryGet( trim(fname), 'vb', vb )
     call HistoryGet( trim(fname), 'ub', ub )
  else
     ri=(/((rmin+dr*(i-1)),i=1,nr)/)
     thetai=(/((dtheta*(i-1)),i=1,ntheta)/)
  end if

  do i=1,nr
     do j=1,ntheta
        vb(j,i)=0.0
        ub(j,i)=-vmax+2.0*vmax*real(i-1)/(nr-1)
        hb(j,i)=hmin
     end do
  end do

!-- ϥեν

  call HistoryCreate( file=trim(finame), title='shallow initial data', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ntheta, nr/),  & 
  & longnames=(/'x-coordinate', 'y-coordinate'/),  &
  & units=(/'m', 'm'/), origin=0.0, interval=0.0 )
  
  call HistoryPut( 'x', thetai )
  call HistoryPut( 'y', ri )
  
  call HistoryAddVariable( varname='vp', dims=(/'x', 'y'/), &
    & longname='meridional wind', units='m s-1', xtype='float')

  call HistoryPut( 'vp', vb )

  call HistoryAddVariable( varname='hp', dims=(/'x', 'y'/), &
    & longname='geopotential', units='m', xtype='float')

  call HistoryPut( 'hp', hb )

  call HistoryAddVariable( varname='up', dims=(/'x', 'y'/), &
    & longname='zonal wind', units='m s-1', xtype='float')

  call HistoryPut( 'up', ub )

end program
