!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module file_operate  ! CReSS η׻̽ϥեǡѥ⥸塼

interface read_file_gtool3_header

  module procedure read_file_gtool3_header_c, read_file_gtool3_header_i, read_file_gtool3_header_r

end interface read_file_gtool3_header

contains


subroutine read_file( file_name, nx, ny, rec_num, var )  ! Ϸɤ߼롼
  ! ܥ롼Ǥ, 쥯ȥɤ߽Ф, 1 ѿΥХȿ 4 Х
  ! Ȳꤷɤ߽ФΤ, 4 ХȰʳΥեɤ߽ФȤ,
  ! Ϥ꥽եν񤭴ɬפȤʤ׽
  implicit none
  integer, intent(in) :: nx  ! ǡ x θĿ
  integer, intent(in) :: ny  ! ǡ y θĿ
  integer, intent(in) :: rec_num  ! ɤ߽ФǡΥ쥳ֹ
  character(*), intent(in) :: file_name  ! ɤ߽Фǡե̾
  real, intent(inout) :: var(nx,ny)  ! ɤ߽Фǡ
  integer :: i, j  ! 

  open(unit=11, file=file_name, access='direct', recl=4*nx*ny, status='old')
     read(11,rec=rec_num) ((var(i,j),i=1,nx),j=1,ny)
  close(unit=11, status='keep')

end subroutine read_file

!-----------------------------------------------
!-----------------------------------------------

subroutine read_file_3d( file_name, nx, ny, nz, rec_num, var )
  ! read_file 3 .
  ! ܥ롼Ǥ, 쥯ȥɤ߽Ф, 1 ѿΥХȿ 4 Х
  ! Ȳꤷɤ߽ФΤ, 4 ХȰʳΥեɤ߽ФȤ,
  ! Ϥ꥽եν񤭴ɬפȤʤ׽
  implicit none
  integer, intent(in) :: nx  ! ǡ x θĿ
  integer, intent(in) :: ny  ! ǡ y θĿ
  integer, intent(in) :: nz  ! ǡ z θĿ
  integer, intent(in) :: rec_num  ! ɤ߽Ф򳫻ϤǡΥ쥳ֹ
  character(*), intent(in) :: file_name  ! ɤ߽Фǡե̾
  real, intent(inout) :: var(nx,ny,nz)  ! ɤ߽Фǡ
  integer :: i, j, k  ! 

  open(unit=11, file=file_name, access='direct', recl=4*nx*ny, status='old')
     do k=1,nz
        read(11,rec=rec_num+k-1) ((var(i,j,k),i=1,nx),j=1,ny)
     end do
  close(unit=11, status='keep')

end subroutine read_file_3d

!-----------------------------------------------
!-----------------------------------------------

subroutine write_file( file_name, nx, ny, rec_num, var, mode )  ! Ͻϥ롼
  ! ܥ롼Ǥ, 쥯ȥɤ߽Ф, 1 ѿΥХȿ 4 Х
  ! Ȳꤷɤ߽ФΤ, 4 ХȰʳΥեɤ߽ФȤ,
  ! Ϥ꥽եν񤭴ɬפȤʤ׽
  implicit none
  integer, intent(in) :: nx  ! ǡ x θĿ
  integer, intent(in) :: ny  ! ǡ y θĿ
  integer, intent(in) :: rec_num  ! ɤ߽ФǡΥ쥳ֹ
  character(*), intent(in) :: file_name  ! ɤ߽Фǡե̾
  real, intent(inout) :: var(nx,ny)  ! ɤ߽Фǡ
  character(*), optional, intent(in) :: mode  ! եν񤭽Фץ
  integer :: i, j  ! 
  character(10) :: cmode

  cmode=''

  if(present(mode))then
     cmode=mode
  else
     cmode='unknown'
  end if

  open(unit=11, file=file_name, access='direct', recl=4*nx*ny, status=cmode)
     write(11,rec=rec_num) ((var(i,j),i=1,nx),j=1,ny)
  close(unit=11, status='keep')

end subroutine write_file

!-----------------------------------------------
!-----------------------------------------------

subroutine write_file_3d( file_name, nx, ny, nz, rec_num, var, mode )
  ! write_file 3 .
  ! ܥ롼Ǥ, 쥯ȥɤ߽Ф, 1 ѿΥХȿ 4 Х
  ! Ȳꤷɤ߽ФΤ, 4 ХȰʳΥեɤ߽ФȤ,
  ! Ϥ꥽եν񤭴ɬפȤʤ׽
  implicit none
  integer, intent(in) :: nx  ! ǡ x θĿ
  integer, intent(in) :: ny  ! ǡ y θĿ
  integer, intent(in) :: nz  ! ǡ z θĿ
  integer, intent(in) :: rec_num  ! ɤ߽Ф򳫻ϤǡΥ쥳ֹ
  character(*), intent(in) :: file_name  ! ɤ߽Фǡե̾
  real, intent(inout) :: var(nx,ny,nz)  ! ɤ߽Фǡ
  character(*), optional, intent(in) :: mode  ! եν񤭽Фץ
  integer :: i, j, k  ! 
  character(10) :: cmode

  cmode=''

  if(present(mode))then
     cmode=mode
  else
     cmode='unknown'
  end if

  open(unit=11, file=file_name, access='direct', recl=4*nx*ny, status=cmode)
     do k=1,nz
        write(11,rec=rec_num+k-1) ((var(i,j,k),i=1,nx),j=1,ny)
     end do
  close(unit=11, status='keep')

end subroutine write_file_3d

!-----------------------------------------------
!-----------------------------------------------

!subroutine read_file_valbyte( file_name, nx, ny, rec_num, byte, var )
!  ! ǤեХȿΥǡɤ߽Ф롼
!  implicit none
!  integer, intent(in) :: nx  ! ǡ x θĿ
!  integer, intent(in) :: ny  ! ǡ y θĿ
!  integer, intent(in) :: rec_num  ! ɤ߽ФǡΥ쥳ֹ
!  integer, intent(in) :: byte  ! ɤ߽ФХȿ
!  character(*), intent(in) :: file_name  ! ɤ߽Фǡե̾
!  real(kind=byte), intent(inout) :: var(nx,ny)  ! ɤ߽Фǡ
!  integer :: i, j  ! 
!
!  open(unit=11, file=file_name, access='direct', recl=byte*nx*ny, status='old')
!     read(11,rec=rec_num) ((var(i,j),i=1,nx),j=1,ny)
!  close(unit=11, status='keep')
!
!end subroutine read_file_valbyte

!-----------------------------------------------
!-----------------------------------------------

subroutine request_dim_grads( fname, dim_len )
! GrADS Υȥե뤫鼡ǿ.
  implicit none
  character(*), intent(in) :: fname  ! GrADS Υȥե
  integer, intent(inout), dimension(4) :: dim_len  ! x,y,z,t ǿ
  character(1000), allocatable, dimension(:) :: ctl_cval
  character(100), allocatable, dimension(:,:) :: ctl_hval
  integer, dimension(5) :: cont_flag
  integer :: nl, i
  character(1000) :: tmpc
  logical :: pdeflag

  nl=line_number_counter( trim(fname) )

  allocate(ctl_cval(nl))
  allocate(ctl_hval(10,nl))

  pdeflag=.false.
  ctl_cval=''
  ctl_hval=''
  tmpc=''

  call read_file_text( trim(fname), 1, nl, ctl_cval, forma='(a1000)' )
  call read_file_text( trim(fname), 2, nl-1, ctl_hval(1:2,1:nl-1) )

  do i=1,nl
     tmpc=trim(adjustl(ctl_cval(i)))
     if(tmpc(1:4)=='xdef')then
        cont_flag(1)=i
     end if
     if(tmpc(1:4)=='ydef')then
        cont_flag(2)=i
     end if
     if(tmpc(1:4)=='zdef')then
        cont_flag(3)=i
     end if
     if(tmpc(1:4)=='tdef')then
        cont_flag(4)=i
     end if
     if(tmpc(1:4)=='pdef')then
        cont_flag(5)=i
        pdeflag=.true.
     end if
  end do

  if(pdeflag.eqv..true.)then
     read(ctl_hval(2,cont_flag(1)),*) dim_len(1)
     read(ctl_hval(2,cont_flag(2)),*) dim_len(2)
     read(ctl_hval(2,cont_flag(3)),*) dim_len(3)
     read(ctl_hval(2,cont_flag(4)),*) dim_len(4)
  else
     read(ctl_hval(2,cont_flag(5)),*) dim_len(1)
     read(ctl_hval(3,cont_flag(5)),*) dim_len(2)
     read(ctl_hval(2,cont_flag(3)),*) dim_len(3)
     read(ctl_hval(2,cont_flag(4)),*) dim_len(4)
  end if

end subroutine

!-----------------------------------------------
!-----------------------------------------------

subroutine request_axis_grads( fname, axis_name, x, y )
! GrADS Υȥե뤫 1 μǡ.
! , linear, levels פΤб.
  implicit none
  character(*), intent(in) :: fname  ! GrADS Υȥե
  character(*), intent(in) :: axis_name  ! ɤ߽Ф̾.
                              ! xdef, ydef, zdef  3 ѥ
  real, intent(inout) :: x(:)  ! κɸ
  real, optional, intent(inout) :: y(:)  ! pdef ξ y κɸ
  character(1000), allocatable, dimension(:) :: ctl_cval
  character(100), allocatable, dimension(:) :: ctl_vval
  character(100), allocatable, dimension(:,:) :: ctl_hval
  integer :: nl, i, j, nx, ny
  real :: vmin, dv
  character(1000) :: tmpc
  character(100), allocatable, dimension(:) :: dummy

  nl=line_number_counter( trim(fname) )
  nx=size(x)
  if(present(y))then
     if(trim(axis_name)=='pdef')then
        ny=size(y)
     else
        write(*,*) "ERROR : request_axis_grads."
        write(*,*) "If axis_name is pdef, argument y must need."
        write(*,*) "STOP."
        stop
     end if
  end if

  allocate(ctl_cval(nl))
  allocate(ctl_hval(2,nl))
  allocate(ctl_vval(13))
  allocate(dummy(nx+3))

  ctl_cval=''
  ctl_vval=''
  ctl_hval=''
  tmpc=''
  dummy=''

  call read_file_text( trim(fname), 1, nl, ctl_cval, forma='(a1000)' )
  call read_file_text( trim(fname), 2, nl-1, ctl_hval(1:2,1:nl-1) )

  do i=1,nl
     tmpc=trim(adjustl(ctl_cval(i)))
     if(tmpc(1:4)==trim(axis_name))then
        if(tmpc(1:4)/='pdef')then
           call read_file_text( trim(fname), 5, 1, ctl_vval(1:5), skip=i-1 )
           if(trim(ctl_vval(3))=='linear')then
              read(ctl_vval(4),*) vmin
              read(ctl_vval(5),*) dv
              x=(/((vmin+dv*(i-1)),i=1,nx)/)
           else
              if(trim(ctl_vval(3))=='levels')then
                 call read_file_text( trim(fname), nx+3, 1, dummy, skip=i-1 )
                 do j=4,nx+3
                    read(dummy(j),*) x(j-3)
                 end do
              else
                 write(*,*) "ERROR (request_axis_grads) : ", trim(ctl_vval(3))
                 write(*,*) "Mode is neither 'levels' nor 'linear'."
                 write(*,*) "STOP."
                 stop
              end if
           end if
        else
           call read_file_text( trim(fname), 13, 1, ctl_vval(1:13), skip=i-1 )
           read(ctl_vval(7),*) vmin
           read(ctl_vval(12),*) dv
           x=(/((vmin+dv*(i-1)),i=1,nx)/)
           read(ctl_vval(8),*) vmin
           read(ctl_vval(13),*) dv
           y=(/((vmin+dv*(i-1)),i=1,ny)/)
        end if
     end if
  end do

end subroutine

!-----------------------------------------------
!-----------------------------------------------

subroutine request_vardim_grads( fname, var_name, nz )
! GrADS Υȥե뤫 var_name ǻꤵ줿ѿιǿ
! .
  implicit none
  character(*), intent(in) :: fname  ! GrADS Υȥե
  character(*), intent(in) :: var_name  ! ǿѿ̾.
  integer, intent(inout) :: nz  ! ǿ
  character(1000), allocatable, dimension(:) :: ctl_cval, ctl_vval
  character(100), allocatable, dimension(:,:) :: ctl_hval
  integer :: nl, i, counter
  character(1000) :: tmpc

  nl=line_number_counter( trim(fname) )

  allocate(ctl_cval(nl))
  allocate(ctl_hval(2,nl))
  allocate(ctl_vval(5))

  ctl_vval=''
  ctl_hval=''
  ctl_cval=''
  tmpc=''

  call read_file_text( trim(fname), 1, nl, ctl_cval, forma='(a1000)' )
  call read_file_text( trim(fname), 2, nl-1, ctl_hval(1:2,1:nl-1) )

  counter=0

  do i=1,nl
     tmpc=trim(adjustl(ctl_hval(1,i)))
     if(trim(tmpc)=='vars')then
        counter=1
     end if
     if(trim(tmpc)==trim(var_name).and.counter==1)then
        read(ctl_hval(2,i),*) nz
        exit
     end if
  end do

end subroutine

!-----------------------------------------------
!-----------------------------------------------

subroutine read_file_grads( fname, val_name, dim_len, intvz, intvt, val )
! GrADS Υȥեɤ߹, val_name ǻꤷѿΥǡ
! Ф.
  implicit none
  character(*), intent(in) :: fname  ! GrADS Υȥե
  character(*), intent(in) :: val_name  ! ɤ߽Фѿ̾
  integer, intent(in), dimension(4) :: dim_len  ! ƼǤο (x,y,z,t) ν
  integer, intent(in), dimension(2) :: intvz  ! ɤ߽ФǶ
  integer, intent(in), dimension(2) :: intvt  ! ɤ߽ФǶ
  real, intent(inout),  &
  & dimension(dim_len(1),dim_len(2),intvz(1):intvz(2),intvt(1):intvt(2))  &
  &  :: val  ! ɤ߽ФͤǼѿ.
  character(1000), allocatable, dimension(:) :: ctl_cval
  character(100), allocatable, dimension(:,:) :: ctl_hval
  integer :: nl, nx, ny, nz, nt, mon_num
  integer :: i, j
  character(1000) :: tmpc, ctmp, header, footer, iname
  integer, dimension(10) :: cont_flag
  integer :: t_fact, year, month, day, hour, counter_start, read_flag, counter
  integer :: year_r, month_r, day_r, hour_r
  logical, dimension(4) :: t_fact_flag, date_flag

  nl=line_number_counter( trim(fname) )
  nx=dim_len(1)
  ny=dim_len(2)
  nz=dim_len(3)
  nt=dim_len(4)

  allocate(ctl_cval(nl))
  allocate(ctl_hval(10,nl))

  ctl_cval=''
  ctl_hval=''
  tmpc=''
  ctmp=''
  header=''
  footer=''
  iname=''

!-- ctl file reading

  call read_file_text( trim(fname), 1, nl, ctl_cval, forma='(a1000)' )
  call read_file_text( trim(fname), 2, nl-1, ctl_hval(1:2,1:nl-1) )

!-- essential factor estimating

  do i=1,nl
     tmpc=trim(adjustl(ctl_cval(i)))
     if(tmpc(1:4)=='vars')then
        cont_flag(1)=i
     end if
     if(tmpc(1:7)=='endvars')then
        cont_flag(2)=i
     end if
     if(tmpc(1:4)=='dset')then
        cont_flag(4)=i
     end if
     if(tmpc(1:4)=='tdef')then
        cont_flag(5)=i
     end if
  end do

  call read_file_text( trim(fname), 4, 1,  &
  &                    ctl_hval(1:4,cont_flag(5):cont_flag(5)), skip=cont_flag(5)-1 )

  do i=cont_flag(1),cont_flag(2)
     tmpc=trim(adjustl(ctl_hval(1,i)))
     if(trim(tmpc)==trim(val_name))then
        cont_flag(3)=i
     end if
  end do

!-- reading array estimate

  read_flag=0
  do i=cont_flag(1)+1,cont_flag(3)-1
     read(ctl_hval(2,i),*) counter
     if(counter==0)then
        read_flag=read_flag+1
     else
        read_flag=read_flag+counter
     end if
  end do

!-- t_fact caluculate

  t_fact_flag(1:4)=.false.
  call read_file_text( trim(fname), 5, 1, ctl_hval(1:5,cont_flag(5)),  &
  &                    skip=cont_flag(5)-1 )
  tmpc=trim(ctl_hval(5,cont_flag(5)))
  select case (tmpc(len_trim(adjustl(tmpc))-1:len_trim(adjustl(tmpc))))
  case ('yr')
     t_fact_flag(1)=.true.
     read(tmpc(1:len_trim(adjustl(tmpc))-2),*) t_fact
  case ('mn')
     t_fact_flag(2)=.true.
     read(tmpc(1:len_trim(adjustl(tmpc))-2),*) t_fact
  case ('dy')
     t_fact_flag(3)=.true.
     read(tmpc(1:len_trim(adjustl(tmpc))-2),*) t_fact
  case ('hr')
     t_fact_flag(4)=.true.
     read(tmpc(1:len_trim(adjustl(tmpc))-2),*) t_fact
  end select

!-- file header estimate

  counter=0
  date_flag(1:4)=.false.
  tmpc=ctl_hval(2,cont_flag(4))
  do i=2,len_trim(adjustl(ctl_hval(2,cont_flag(4))))
     if(tmpc(i:i)=='%')then
        counter=counter+1
        if(counter==1)then
           counter_start=i
           header(1:i-2)=tmpc(2:i-1)
        end if
        select case (tmpc(i+1:i+2))
        case ('y4')
           date_flag(1)=.true.
           if(t_fact_flag(1).eqv..true.)then
              footer=tmpc(i+3:len_trim(adjustl(ctl_hval(2,cont_flag(4)))))
           end if
        case ('m2')
           date_flag(2)=.true.
           if(t_fact_flag(1).eqv..true.)then
              footer=tmpc(i+3:len_trim(adjustl(ctl_hval(2,cont_flag(4)))))
           end if
        case ('d2')
           date_flag(3)=.true.
           if(t_fact_flag(1).eqv..true.)then
              footer=tmpc(i+3:len_trim(adjustl(ctl_hval(2,cont_flag(4)))))
           end if
        case ('h2')
           date_flag(4)=.true.
           if(t_fact_flag(1).eqv..true.)then
              footer=tmpc(i+3:len_trim(adjustl(ctl_hval(2,cont_flag(4)))))
           end if
        end select
     end if
  end do

  if(counter==0)then
     tmpc=trim(adjustl(ctl_hval(2,cont_flag(4))))
     header=trim(tmpc(2:len_trim(adjustl(ctl_hval(2,cont_flag(4))))))
     footer=''
  end if
!-- initial time reading

  tmpc=trim(ctl_hval(4,cont_flag(5)))
  read(tmpc(1:2),*) hour
  select case (tmpc(3:3))
  case (':')
     read(tmpc(7:8),*) day
     read(tmpc(12:15),*) year
     mon_num=9  ! ɽʸϤޤ
  case ('Z')
     read(tmpc(4:5),*) day
     read(tmpc(9:12),*) year
     mon_num=6  ! ɽʸϤޤ
  end select

  select case (tmpc(mon_num:mon_num+2))
  case('Jan')
     month=1
  case('Feb')
     month=2
  case('Mar')
     month=3
  case('Apr')
     month=4
  case('May')
     month=5
  case('Jun')
     month=6
  case('Jul')
     month=7
  case('Aug')
     month=8
  case('Sep')
     month=9
  case('Oct')
     month=10
  case('Nov')
     month=11
  case('Dec')
     month=12
  end select

  year_r=year
  month_r=month
  day_r=day
  hour_r=hour

!-- reading data

  do i=intvt(1),intvt(2)

!-- default value setting

     iname=trim(header)
     do j=4,1,-1  ! ֤­碌Թ礬褤롼׵ղ
        select case (j)
        case (1)
           if(t_fact_flag(1).eqv..true.)then
              year=year_r+t_fact*(i-1)
           end if
        case (2)
           if(t_fact_flag(2).eqv..true.)then
              month=month_r+t_fact*(i-1)
           end if
        case (3)
           if(t_fact_flag(3).eqv..true.)then
              day=day_r+t_fact*(i-1)
           end if
        case (4)
           if(t_fact_flag(4).eqv..true.)then
              hour=hour_r+t_fact*(i-1)
           end if
        end select

        do while (hour>24)
           hour=hour-24
           day=day+1
        end do

        do while (day>28)
           do while (month>12)
              year=year+1
              month=month-12
           end do
           select case (month)
           case (1)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (3)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (5)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (7)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (8)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (10)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (12)
              if(day>31)then
                 month=month+1
                 day=day-31
              else
                 exit
              end if
           case (4)
              if(day>30)then
                 month=month+1
                 day=day-30
              else
                 exit
              end if
           case (6)
              if(day>30)then
                 month=month+1
                 day=day-30
              else
                 exit
              end if
           case (9)
              if(day>30)then
                 month=month+1
                 day=day-30
              else
                 exit
              end if
           case (11)
              if(day>30)then
                 month=month+1
                 day=day-30
              else
                 exit
              end if
           case (2)
              if(day>29.and.mod(year,4)==0)then
                 month=month+1
                 day=day-29
              else
                 if(day>28.and.mod(year,4)/=0)then
                    month=month+1
                    day=day-28
                 else
                    exit
                 end if
              end if
          end select
        end do
     end do

     do j=1,4
        if(date_flag(j).eqv..true.)then
           select case (j)
           case (1)
              write(ctmp,'(i4.4)') year
              iname=trim(iname)//trim(adjustl(ctmp))
           case (2)
              write(ctmp,'(i2.2)') month
              iname=trim(iname)//trim(adjustl(ctmp))
           case (3)
              write(ctmp,'(i2.2)') day
              iname=trim(iname)//trim(adjustl(ctmp))
           case (4)
              write(ctmp,'(i2.2)') hour
              iname=trim(iname)//trim(adjustl(ctmp))
           end select
        end if
     end do

     iname=trim(iname)//trim(footer)

     do j=intvz(1),intvz(2)
        call read_file( trim(iname), nx, ny, read_flag+j,  &
  &                     val(:,:,j,i) )
     end do
     write(*,*) "finishing to read file", trim(iname), nx, ny, read_flag+intvz(1), read_flag+intvz(2), i
  end do

end subroutine

!-----------------------------------------------
!-----------------------------------------------

subroutine auto_read_file( file_name, d2n, d3n, d2val, d3val, ad2val, ad3val, nx, ny, nz, d2var, d3var, specnz, intvnz )
! ɤ߹ѿθĿꤹ뤳Ȥ, פѿǡϥɤ߹ޤʤ
! 롼. (For CReSS)
! Υ롼ƤӽФɬ, val_counter ѰդѿƤ.
  implicit none
  character(*), intent(in) :: file_name  ! ɤ߽Фե̾
  integer, intent(in) :: d2n  ! d2 ѿѤѰդ٤ (ѿμ)
  integer, intent(in) :: d3n  ! d3 ѿѤѰդ٤ (ѿμ)
  character(*), intent(in) :: d2val  ! CReSS Υץեκǽ d2 ǡ
  character(*), intent(in) :: d3val  ! CReSS Υץեκǽ d3 ǡ
  character(*), intent(in) :: ad2val  ! CReSS Υץեθ d2 ǡ
  character(*), intent(in) :: ad3val  ! CReSS Υץեθ d3 ǡ
  integer, intent(in) :: nx  ! x ǿ
  integer, intent(in) :: ny  ! y ǿ
  integer, intent(in) :: nz  ! z ǿ
  integer, intent(in), optional :: specnz  ! nz ˤĤƻ٤Τ߼Ф
                      ! ξ, ɬ nz = 1 ǤʤФʤʤ.
  integer, intent(in), dimension(2), optional :: intvnz
                      ! nz ˤĤ intvnz(1)  intvnz(2) ޤǤι٤Ф.
                      ! ξ, nz ϤѿǿǤʤФʤʤ.
  real, dimension(nx,ny,d2n), intent(inout) :: d2var  ! d2 ѿ
  real, dimension(nx,ny,nz,d3n), intent(inout) :: d3var  ! d3 ѿ
  integer :: d2m, d3m, d2am, d3am, i, j, k, all_count, d2_count, d3_count

  d2m=len_trim(d2val)
  d3m=len_trim(d3val)
  d2am=len_trim(ad2val)
  d3am=len_trim(ad3val)
write(*,*) "len=", d2m, d3m, d2am, d3am
  all_count=0
!-- ե 1 쥳ܤɤफɤȽǤԤäɤ ---
!-- ޤ, ǽ d2 ǡˤĤ
  j=0
  if(d2m>=1)then
  do i=1,d2m
     if(d2val(i:i)=='1')then
        j=j+1
        if(d2n<j)then
           write(*,*) "*** ERROR ***"
           write(*,*) "read array exceeds d2n. STOP."
           stop
        else
           call read_file( file_name, nx, ny, i, d2var(:,:,j))
        end if
     end if
  end do
  end if
  d2_count=j  ! ǽ d2 ǡǤä (ɤФʤ)
  all_count=all_count+d2m  ! ɤФʬޤƲ쥳ʬɤΥ

!-- , ǽ d3 ǡˤĤ
  j=0
  if(d3m>=1)then
  do i=1,d3m
     if(d3val(i:i)=='1')then
        j=j+1
        if(d3n<j)then
           write(*,*) "*** ERROR ***"
           write(*,*) "read array exceeds d3n. STOP."
           stop
        else
           if(present(specnz))then
              call read_file( file_name, nx, ny, all_count+specnz, d3var(:,:,specnz,j) )
           else
              if(present(intvnz))then
                 do k=intvnz(1),intvnz(2)
                    call read_file( file_name, nx, ny, all_count+k, d3var(:,:,k,j) )
                 end do
              else
                 do k=1,nz
                    call read_file( file_name, nx, ny, all_count+k, d3var(:,:,k,j) )
                 end do
              end if
           end if
        end if
     end if
     all_count=all_count+nz  ! if ʸɤǤʤƤ nz ʬ
  end do
  end if
  d3_count=j  ! ǽ d3 ǡǤä (ɤФʤ)

!-- ³,  d2 ǡˤĤ
  j=d2_count
  if(d2am>=1)then
  do i=1,d2am
     if(ad2val(i:i)=='1')then
        j=j+1
        if(d2n<j)then
           write(*,*) "*** ERROR ***"
           write(*,*) "read array exceeds d2n. STOP."
           stop
        else
           call read_file( file_name, nx, ny, all_count+i, d2var(:,:,j))
        end if
     end if
  end do
  end if
  all_count=all_count+d2am  ! ɤФʬޤƲ쥳ʬɤΥ

!-- Ǹ,  d3 ǡˤĤ
  j=d3_count
  if(d3am>=1)then
  do i=1,d3am
     if(ad3val(i:i)=='1')then
        j=j+1
        if(d3n<j)then
           write(*,*) "*** ERROR ***"
           write(*,*) "read array exceeds d3n. STOP."
           stop
        else
           if(present(specnz))then
              call read_file( file_name, nx, ny, all_count+specnz, d3var(:,:,specnz,j) )
           else
              if(present(intvnz))then
                 do k=intvnz(1),intvnz(2)
                    call read_file( file_name, nx, ny, all_count+k, d3var(:,:,k,j) )
                 end do
              else
                 do k=1,nz
                    call read_file( file_name, nx, ny, all_count+k, d3var(:,:,k,j) )
                 end do
              end if
           end if
        end if
     end if
     all_count=all_count+nz  ! if ʸɤǤʤƤ nz ʬ
  end do
  end if

end subroutine

!-----------------------------------
!-----------------------------------

subroutine read_file_gtool3( fname, nx, ny, nz, tstr, tstep, tnum, val )
! gtool3 Υǡɤ߽Ф.
  implicit none
  character(*), intent(in) :: fname  ! ɤ߹ǡե
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  integer, intent(in) :: tstr  ! ɤ߹ (ͤ鲿ƥåܤǻ).
  integer, intent(in) :: tstep  ! ɤФֳִ (1 ɤ߹)
  integer, intent(in) :: tnum  ! ɤ߹֤ο
  real, intent(inout) :: val(nx,ny,nz,tnum)
  character(16) :: header(64)  ! إåɤФ
  integer :: i, j, k, l, tmax, counter
  real :: skip(nx,ny,nz)

  tmax=tstr+tstep*(tnum-1)

  open(unit=11,file=trim(fname),form='unformatted',access='sequential',status='old')
     if(tstr/=1)then
        do i=1,tstr-1
           read(11) header
           read(11) skip
        end do
     end if

     counter=0

     do i=tstr,tmax

        read(11) header
        read(11) skip

        if(mod((i-tstr),tstep)==0)then
           counter=counter+1
           do l=1,nz
              do k=1,ny
                 do j=1,nx
                    val(j,k,l,counter)=skip(j,k,l)
                 end do
              end do
           end do
        end if

     end do
  close(unit=11)

end subroutine

!-----------------------------------
!-----------------------------------

subroutine read_file_gtool3_header_c( fname, header, val )
! gtool3 ΥǡΥإå, ɬפѿ̾Ϥ, ֤ͤ.
! ѿ̾ http://www.riam.kyushu-u.ac.jp/taikai/lab/others/Gtool/node111.html .
! , Fortran ͽǤ unit, size ˤĤƤ, uni, siz .
  implicit none
  character(*), intent(in) :: fname
  character(*), intent(in) :: header(:)
  character(16), intent(inout) :: val(size(header))
  integer, parameter :: vnum=43
  character(16) :: raw_dat(64)
  character(6) :: signc(vnum)
  integer :: signi(vnum)
  integer :: i, j

  signc=(/'dset  ',  &
  &       'item  ',  &
  &       'edit1 ',  &
  &       'edit2 ',  &
  &       'edit3 ',  &
  &       'edit4 ',  &
  &       'edit5 ',  &
  &       'edit6 ',  &
  &       'edit7 ',  &
  &       'edit8 ',  &
  &       'titl1 ',  &
  &       'titl2 ',  &
  &       'uni   ',  &
  &       'ettl1 ',  &
  &       'ettl2 ',  &
  &       'ettl3 ',  &
  &       'ettl4 ',  &
  &       'ettl5 ',  &
  &       'ettl6 ',  &
  &       'ettl7 ',  &
  &       'ettl8 ',  &
  &       'date  ',  &
  &       'utim  ',  &
  &       'aitm1 ',  &
  &       'aitm2 ',  &
  &       'aitm3 ',  &
  &       'dfmt  ',  &
  &       'coptn ',  &
  &       'utim2 ',  &
  &       'memo01',  &
  &       'memo02',  &
  &       'memo03',  &
  &       'memo04',  &
  &       'memo05',  &
  &       'memo06',  &
  &       'memo07',  &
  &       'memo08',  &
  &       'memo09',  &
  &       'memo10',  &
  &       'cdate ',  &
  &       'csign ',  &
  &       'mdate ',  &
  &       'msign ' /)

  signi=(/2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 21,  &
  &       22, 23, 24, 26, 27, 29, 32, 35, 38, 45, 49, 50, 51, 52, 53, 54,  &
  &       55, 56, 57, 58, 59, 60, 61, 62, 63 /)

  open(unit=11,file=trim(fname),form='unformatted',access='sequential',status='old')
     read(11) raw_dat
  close(unit=11)

  do i=1,size(header)
     do j=1,vnum
        if(trim(header(i))==trim(signc(j)))then
           val(i)=raw_dat(signi(j))
           exit
        end if
     end do
  end do

end subroutine

!-----------------------------------
!-----------------------------------

subroutine read_file_gtool3_header_i( fname, header, val )
! gtool3 ΥǡΥإå, ɬפѿ̾Ϥ, ֤ͤ.
! ѿ̾ http://www.riam.kyushu-u.ac.jp/taikai/lab/others/Gtool/node111.html .
! , Fortran ͽǤ unit, size ˤĤƤ, uni, siz .
  implicit none
  character(*), intent(in) :: fname
  character(*), intent(in) :: header(:)
  integer, intent(inout) :: val(size(header))
  integer, parameter :: vnum=15
  character(16) :: raw_dat(64)
  character(6) :: signc(vnum)
  integer :: signi(vnum)
  integer :: i, j

  signc=(/'idfm  ',  &
  &       'fnum  ',  &
  &       'dnum  ',  &
  &       'time  ',  &
  &       'tdur  ',  &
  &       'astr1 ',  &
  &       'aend1 ',  &
  &       'astr2 ',  &
  &       'aend2 ',  &
  &       'astr3 ',  &
  &       'aend3 ',  &
  &       'styp  ',  &
  &       'ioptn ',  &
  &       'time2 ',  &
  &       'size  ' /)

  signi=(/1, 12, 13, 25, 28, 30, 31, 33, 34, 36, 37, 44, 46, 48, 64 /)

  open(unit=11,file=trim(fname),form='unformatted',access='sequential',status='old')
     read(11) raw_dat
  close(unit=11)

  do i=1,size(header)
     do j=1,vnum
        if(trim(header(i))==trim(signc(j)))then
           read(raw_dat(signi(j)),'(i16)') val(i)
           exit
        end if
     end do
  end do

end subroutine

!-----------------------------------
!-----------------------------------

subroutine read_file_gtool3_header_r( fname, header, val )
! gtool3 ΥǡΥإå, ɬפѿ̾Ϥ, ֤ͤ.
! ѿ̾ http://www.riam.kyushu-u.ac.jp/taikai/lab/others/Gtool/node111.html .
! , Fortran ͽǤ unit, size ˤĤƤ, uni, siz .
  implicit none
  character(*), intent(in) :: fname
  character(*), intent(in) :: header(:)
  real, intent(inout) :: val(size(header))
  integer, parameter :: vnum=6
  character(16) :: raw_dat(64)
  character(10) :: signc(vnum)
  integer :: signi(vnum)
  integer :: i, j

  signc=(/'miss  ',  &
  &       'dmin  ',  &
  &       'dmax  ',  &
  &       'divs  ',  &
  &       'divl  ',  &
  &       'roptn ' /)

  signi=(/39, 40, 41, 42, 43, 47 /)

  open(unit=11,file=trim(fname),form='unformatted',access='sequential',status='old')
     read(11) raw_dat
  close(unit=11)

  do i=1,size(header)
     do j=1,vnum
        if(trim(header(i))==trim(signc(j)))then
           if(trim(header(i))=='roptn')then
              read(raw_dat(signi(j)),'(e16.7)') val(i)
           else
              read(raw_dat(signi(j)),'(e15.7)') val(i)
           end if
           exit
        end if
     end do
  end do

end subroutine

!-----------------------------------
!-----------------------------------

integer function line_number_counter( fname )
  ! ƥȥǡιԿ׻ؿ
  implicit none
  character(*), intent(in) :: fname  ! ɤ߼ƥȥե
!  integer, intent(inout) :: res
  integer :: i, err
  character(1) :: dummy

  i=0
  open(unit=10,file=trim(fname),iostat=err,status='old')
  do while(err==0)
     read(10,*,iostat=err) dummy
     i=i+1
  end do
  close(unit=10,status='keep')

  line_number_counter=i-1
  return

end function

!-----------------------------------
!-----------------------------------

subroutine read_file_text( fname, nx, ny, val, skip, forma )
! ƥȷΥǡɤ߹롼
! forma  nx, ny δط 4x3  i3 () ιǡξ,
! forma = '(3a3)' Ȥ form ɤ߹ʤ, nx = 3, ny = 4
! forma = '(a)' Ȥ form ɤ߹ʤ, nx = 1, ny = 4 Ȥʤ.
  implicit none
  character(*), intent(in) :: fname  ! ɤ߹ƥȥե
  integer, intent(in) :: nx  ! ɤ߹ե
  integer, intent(in) :: ny  ! ɤ߹եιԿ
  character(*), intent(inout) :: val(nx,ny)  ! ʸǡˤб뤿, ʸǷ̤֤.
  integer, intent(in), optional :: skip  ! ƬԤɤФ. default  0.
  character(*), intent(in), optional :: forma  ! read Υեޥå '(f4.1)' ʤ. ǥեȤǤ read ΥǥեȥեޥåȻ.
  integer :: i, j
  character(1) :: dummy

  open(unit=10, file=trim(fname), status='old')
  if(present(skip))then
     do i=1,skip
        read(10,*) dummy
     end do
  end if

  if(present(forma))then
     do j=1,ny
        read(10,forma) (val(i,j),i=1,nx)
     end do
  else
     do j=1,ny
        read(10,*) (val(i,j),i=1,nx)
     end do
  end if
  close(unit=10,status='keep')

end subroutine

!-----------------------------------
!-----------------------------------

subroutine read_mgdsst( fname, sst )
! mgdsst ǡɤ߹िΥ롼
! ɤ߹ѥǡ 1440 x 720 Ǹ.
! , mgdsst ΥեޥåȤ餯ΤǤ.
  implicit none
  integer, parameter :: nx=1440  ! γʻ
  integer, parameter :: ny=720  ! γʻ
  character(*), intent(in) :: fname  ! ɤ߹ mgdsst 롼
  real, intent(inout), dimension(nx,ny) :: sst  ! ɤ߹ SST ǡ [K].
                              ! , 999.0 ̤, 888.0 ɹ.
  character(3), dimension(nx,ny) :: sstc
  character(10) :: formatt
  integer :: j, k

  formatt='(1440a3)'

  call read_file_text( trim(fname), nx, ny, sstc, skip=1, forma=trim(formatt))
!  open(unit=12,file=trim(dat_list(i)),status='old')
!     read(12,*) sstc(1,1)
  do k=1,ny
!     read(12,formatt) (sstc(j,k),j=1,nx)
     do j=1,nx
        if(sstc(j,k)=='888'.or.sstc(j,k)=='999')then
           sst(j,ny-k+1)=999.0
        else
           read(sstc(j,k),*) sst(j,ny-k+1)
           sst(j,ny-k+1)=sst(j,ny-k+1)/10.0+273.15
!           write(*,*) j,k,sstc(j,k),sst(j,k)
        end if
!        tmp(j,ny-k+1)=sst(j,k)
!        sst(j,k)=tmp(j,k)
     end do
  end do

end subroutine

end module
