module Thermo_Routine  ! ǮϳشطѿѤ

contains

subroutine CTTemp( nx, ny, nz, Q, hnum, thres, undeff )
! ׻ΰαĺ٤׻롼.
! ̩ˤϲ٤׻ΤǤϤʤ, ĺľʻֹ
! ʿ̤ϤäƷ׻롼 (ʤȰ 3 ٤ξ
! ɬפˤʤΤ, å̵̸).
! ׻ˤ, ľü鲼˲, ͤۤȤĺȽǤ.
! ͤϥץѹǽ. ǥեȤǤ 5.e-5 [kg/kg] .
! ȤƴꤹΤǤդǤ, ֥롼Ƥ­碌Ƥ.
! []
! ޤäʤä, nz  1 ­Τ֤Τ,
! ƥ롼,  undef ǧ򤷤Ƥɬפ.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  real, intent(in), dimension(nx,ny,nz) :: Q  ! ŷʪκ [kg/kg]
  integer, intent(inout), dimension(nx,ny) :: hnum  ! ĺľʻֹ
  real, intent(in), optional :: thres  ! ȽǤ뤿 [kg/kg]
  real, intent(in), optional :: undeff  ! ̤
  real :: defun
  integer :: i, j, k
  real :: threshold

  if(present(thres))then
     threshold=thres
  else
     threshold=5.e-6
  end if

  if(present(undeff))then
     defun=undeff
  else
     defun=999.0
  end if

  do i=1,nx
     do j=1,ny
        do k=nz,1,-1
           if(Q(i,j,k)>threshold.and.Q(i,j,k)/=undeff)then
              hnum(i,j)=k
              exit
           else
              if(k==1)then
                 hnum(i,j)=nz+1
              end if
           end if
        end do
     end do
  end do

end subroutine

!-----------------------------------------------------
!-----------------------------------------------------

subroutine hydro_pres( z, rho, z_ref, p_ref, pres )
!  ľ 1 Υǥ󥰥ǡϳʿվ׻.
  use Algebra
  use Phys_Const
  implicit none
  real, intent(in) :: z(:)  ! r ΰֺɸ [m]
  real, intent(in) :: rho(size(z))  ! ̩ [kg/m^3]
  real, intent(in) :: z_ref  ! ʬȤʤֺɸ [m]
  real, intent(in) :: p_ref  ! z_ref Ǥε (ʬ) [Pa]
  real, intent(inout) :: pres(size(z))  ! ϳʿվǤε [Pa]
  integer :: i, nz

  nz=size(z)

  do i=1,nz
     if(z(i)<z_ref)then
        call rectangle_int( z, rho, z(i), z_ref, pres(i) )
        pres(i)=p_ref+pres(i)*g
     else
        if(z(i)>z_ref)then
           call rectangle_int( z, rho, z_ref, z(i), pres(i) )
           pres(i)=p_ref-pres(i)*g
        else
           pres(i)=p_ref
        end if
     end if
  end do

end subroutine


end module


