program ttmp
! このプログラムは Vaisala RS92-SGP の EDT テキストデータ専用.
  use Dcl
  use Dcl_Automatic
  use Basis
  use file_operate
  use Max_Min

  implicit none

  integer :: i, j, k, nt, nf
  real :: tmp
  integer, allocatable, dimension(:) :: crnum, idx
  real, allocatable, dimension(:) :: arnum
  real, allocatable, dimension(:,:) :: temp, height, u, v
  character(1000) :: fname
  character(1000), allocatable, dimension(:) :: lname
  character(100), allocatable, dimension(:,:) :: cval
  integer, parameter :: skip=40, hn=7, un=6, tn=3, vn=5, cn=10
  real, parameter :: vx1(2)=(/0.1,0.325/), vx2(2)=(/0.375,0.6/)
  real, parameter :: vx3(2)=(/0.65,0.875/), vy(2)=(/0.15,0.85/)
  real, parameter :: hint(2)=(/0.0,0.2/), tint(2)=(/295.0,305.0/)
!  real, parameter :: hint(2)=(/16.0,25.0/), tint(2)=(/185.0,225.0/)
  real, parameter :: uint(2)=(/-25.0,25.0/), vint(2)=(/-20.0,20.0/)
  real, parameter :: undef=-999.0

  call UZFACT( 0.6 )
  call GLLSET( 'LMISS', .true. )
  call GLRSET( 'RMISS', undef )

  write(*,*) "Input list file name."
  read(*,*) fname

  nf=line_number_counter( trim(fname) )
  allocate(arnum(nf))
  allocate(crnum(nf))
  allocate(idx(nf+1))
  allocate(lname(nf))
  call read_file_text( trim(fname), 1, nf, lname )

  do i=1,nf
     arnum(i)=real(line_number_counter( trim(lname(i)) )-skip)
     crnum(i)=line_number_counter( trim(lname(i)) )-skip
  end do

  call max_val_1d( arnum, j, tmp )
  nt=int(tmp)

  allocate(temp(nt,nf+1))
  allocate(height(nt,nf+1))
  allocate(u(nt,nf+1))
  allocate(v(nt,nf+1))
  allocate(cval(cn,nt))

  temp=0.0
  height=0.0
  u=0.0
  v=0.0
  height(1:nt,1)=hint(1)
  height(nt,1)=hint(2)

  do j=1,nf
     call read_file_text( trim(lname(j)), cn, crnum(j), cval, skip=skip )

     do i=1,nt
        if(i<=crnum(j))then
           temp(i,j+1)=c2r_convert( trim(adjustl(cval(tn,i))) )
           height(i,j+1)=c2r_convert( trim(adjustl(cval(hn,i))) )*1.0e-3
           u(i,j+1)=c2r_convert( trim(adjustl(cval(un,i))) )
           v(i,j+1)=c2r_convert( trim(adjustl(cval(vn,i))) )
        else
           temp(i,j+1)=undef
           height(i,j+1)=undef
           u(i,j+1)=undef
           v(i,j+1)=undef
        end if
        if(v(i,j+1)<undef.or.u(i,j+1)<undef.or.temp(i,j+1)<undef)then
           temp(i,j+1)=undef
           height(i,j+1)=undef
           u(i,j+1)=undef
           v(i,j+1)=undef
        end if
     end do
  end do

  idx(1)=11
  do i=2,nf+1
     idx(i)=10*(((i-1)*80)/nf)+3
  end do

  call DclOpenGraphics()
  call DclSetParm( "GRAPH:LCLIP", .true. )

  call Dcl_PL( 'l', 'Temperature', temp, height, temp, height,  &
  &            (/'(K)','Height (km)'/),  &
  &            viewx_int=vx1, viewy_int=vy,  &
  &            x_int=tint, y_int=hint, l_idx=idx )

  call Dcl_PL( 'l', 'Zonal wind', u, height, u, height,  &
  &            (/'(m s|-1")',''/),  &
  &            viewx_int=vx2, viewy_int=vy,  &
  &            x_int=uint, y_int=hint, l_idx=idx, no_frame=.true. )

  call Dcl_PL( 'l', 'Meridional wind', v, height, v, height,  &
  &            (/'(m s|-1")',''/),  &
  &            viewx_int=vx3, viewy_int=vy,  &
  &            x_int=vint, y_int=hint, l_idx=idx, no_frame=.true. )

  call DclCloseGraphics

end program
