module force_nbm_solv
!-- 全ての項は d (psi) / d t で計算されている.

  use fftsub_mod

contains

subroutine ADV_term_NBM( psik, ADV, u_nbm_isp, v_nbm_isp, auukl, auvkl, avvkl )
!-- calculating advection terms
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik     ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: ADV   ! advection term
  double precision, dimension(jynt,jxnt), intent(out), optional :: u_nbm_isp
  double precision, dimension(jynt,jxnt), intent(out), optional :: v_nbm_isp
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout), optional :: auukl   ! Auukl
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout), optional :: auvkl   ! Auvkl
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout), optional :: avvkl   ! Avvkl

  integer :: i, j
  double precision :: lxi, lyi
  complex(kind(0d0)), dimension(kxnt,kynt) :: uk, vk, akl, bkl, ckl, dkl, tma
  double precision, dimension(jynt,jxnt) :: anm_isp, bnm_isp, cnm_isp, dnm_isp
  double precision, dimension(jynt,jxnt) :: u_isp, v_isp

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly

  uk=0.0d0
  vk=0.0d0
  u_isp=0.0d0
  v_isp=0.0d0
  anm_isp=0.0d0
  akl=0.0d0
  bnm_isp=0.0d0
  bkl=0.0d0
  cnm_isp=0.0d0
  dnm_isp=0.0d0
  u_isp=0.0d0
  v_isp=0.0d0
  if(present(u_nbm_isp))then
     u_nbm_isp=0.0d0
     v_nbm_isp=0.0d0
  end if
  if(present(auukl))then
     ckl=0.0d0
     dkl=0.0d0
     auukl=0.0d0
     avvkl=0.0d0
     auvkl=0.0d0
  end if
  tma=0.0d0
  ADV=0.0d0

  call psik2ukvk( psik, uk, vk )

  call spec2phys_isp( uk(1:kxnt,1:kynt), u_isp(1:jynt,1:jxnt) )
  call spec2phys_isp( vk(1:kxnt,1:kynt), v_isp(1:jynt,1:jxnt) )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do i=1,jxnt
     do j=1,jynt
        anm_isp(j,i)=u_isp(j,i)*v_isp(j,i)
        cnm_isp(j,i)=v_isp(j,i)*v_isp(j,i)
        dnm_isp(j,i)=u_isp(j,i)*u_isp(j,i)
        bnm_isp(j,i)=cnm_isp(j,i)-dnm_isp(j,i)
     end do
  end do

!$omp end do
!$omp end parallel

  call phys2spec_isp( anm_isp(1:jynt,1:jxnt), akl(1:kxnt,1:kynt) )

  if(present(auukl))then
     call phys2spec_isp( cnm_isp(1:jynt,1:jxnt), ckl(1:kxnt,1:kynt) )
     call phys2spec_isp( dnm_isp(1:jynt,1:jxnt), dkl(1:kxnt,1:kynt) )
  else
     call phys2spec_isp( bnm_isp(1:jynt,1:jxnt), bkl(1:kxnt,1:kynt) )
  end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=-akl(i,1)
!ORG     tma(jxnt-i+2,1)=dconjg(tma(i,1))
     tma(kxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=akl(1,j)
!ORG     tma(1,jynt-j+2)=akl(1,jynt-j+2)
     tma(1,kynt-j+2)=akl(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier

  if(present(auukl))then

!$omp do schedule(runtime) private(i,j)

     do j=2,hynt+1
        do i=2,hxnt+1
           tma(i,j)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,j)  &
  &                 -dble(i-1)*dble(j-1)*lxi*lyi*(ckl(i,j)-dkl(i,j))
                   ! 上式までは渦度の移流項の計算
           tma(i,j)=tma(i,j)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
                   ! 上式は渦度から流線関数への変換計算
!ORG           tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
           tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
!ORG           tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
!ORG  &                        +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
           tma(i,kynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,kynt-j+2)  &
  &                      +dble(i-1)*dble(j-1)*lxi*lyi*(ckl(i,kynt-j+2)-dkl(i,kynt-j+2))
!ORG           tma(i,jynt-j+2)=tma(i,jynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
           tma(i,kynt-j+2)=tma(i,kynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
!ORG           tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
           tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
        end do
     end do

!$omp end do

  else

!$omp do schedule(runtime) private(i,j)

     do j=2,hynt+1
        do i=2,hxnt+1
           tma(i,j)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,j)  &
  &                 -dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,j)
                   ! 上式までは渦度の移流項の計算
           tma(i,j)=tma(i,j)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
                   ! 上式は渦度から流線関数への変換計算
!ORG           tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
           tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
!ORG           tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
!ORG  &                        +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
           tma(i,kynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,kynt-j+2)  &
  &                      +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,kynt-j+2)
!ORG           tma(i,jynt-j+2)=tma(i,jynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
           tma(i,kynt-j+2)=tma(i,kynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
!ORG           tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
           tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
        end do
     end do

!$omp end do

  end if

!$omp end parallel

!ORG  call rearrange_3to2( tma, ADV )
  ADV=tma

  if(present(u_nbm_isp))then
     u_nbm_isp=u_isp
     v_nbm_isp=v_isp
  end if

  if(present(auukl))then
     auukl=dkl
     avvkl=ckl
     auvkl=akl
  end if

end subroutine ADV_term_NBM


subroutine diag_PRES( psik, auukl, auvkl, avvkl, pk )
!-- diagnose pressure in NBM (for calculation SBL)
  use Math_Const
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik    ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: auukl   ! Auukl
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: auvkl   ! Auvkl
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: avvkl   ! Avvkl
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: pk   ! pk

  integer :: i, j
  double precision :: lxi, lyi
  complex(kind(0d0)), dimension(kxnt,kynt) :: tma

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly

  tma=0.0d0
  pk=0.0d0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=f0*psik(i,1)-auukl(i,1)
     tma(kxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=f0*psik(1,j)-avvkl(1,j)
     tma(1,kynt-j+2)=f0*psik(1,kynt-j+2)-avvkl(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        tma(i,j)=f0*psik(i,j)  &
  &              -(((dble(i-1)*lxi)**2)*auukl(i,j)  &
  &                +((dble(j-1)*lyi)**2)*avvkl(i,j)  &
  &                +2.0d0*dble(i-1)*dble(j-1)*lxi*lyi*auvkl(i,j))  &
  &               /((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
        tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
        tma(i,kynt-j+2)=f0*psik(i,kynt-j+2)  &
  &                    -(((dble(i-1)*lxi)**2)*auukl(i,kynt-j+2)  &
  &                      +((dble(j-1)*lyi)**2)*avvkl(i,kynt-j+2)  &
  &                      -2.0d0*dble(i-1)*dble(j-1)*lxi*lyi*auvkl(i,kynt-j+2))  &
  &                     /((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
        tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

  pk=rho0*tma

end subroutine diag_PRES


subroutine DIFF_term_NBM( psik, DIFF )
!-- calculating diffusion term
! nu*lap(zeta)
  use Math_Const
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik      ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: DIFF   ! diffusion term

  integer :: i, j
  double precision :: lxi, lyi, pi4

  DIFF=0.0d0

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     DIFF(i,1)=-nu*pi4*((dble(i-1)*lxi)**2)*psik(i,1)
     DIFF(kxnt-i+2,1)=dconjg(DIFF(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     DIFF(1,j)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,j)
     DIFF(1,kynt-j+2)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        DIFF(i,j)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*psik(i,j)
        DIFF(kxnt-i+2,kynt-j+2)=dconjg(DIFF(i,j))
        DIFF(i,kynt-j+2)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)  &
  &                    *psik(i,kynt-j+2)
        DIFF(kxnt-i+2,j)=dconjg(DIFF(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine DIFF_term_NBM


subroutine STRETCH_term_NBM( psik, STRETCH )
!-- calculating stretching terms
  use Math_Const
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik     ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: STRETCH   ! advection term

  integer :: i, j
  double precision :: lxi, lyi, pi4, f0z_inv
  complex(kind(0d0)), dimension(kxnt,kynt) :: zk, akl, tma
  double precision, dimension(jynt,jxnt) :: z_isp, anm_isp

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp
  f0z_inv=1.0d0/(f0+zetam)

  zk=0.0d0
  z_isp=0.0d0
  anm_isp=0.0d0
  akl=0.0d0
  tma=0.0d0
  STRETCH=0.0d0

  call psik2zetak( psik, zk )

  call spec2phys_isp( zk(1:kxnt,1:kynt), z_isp(1:jynt,1:jxnt) )

!$omp parallel default(shared)

  select case (force_type)
  case (1)  ! default by Rozoff et al. (2009)

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           ! cav = cr_isp/(f0+zetam)
           anm_isp(j,i)=(f0+z_isp(j,i))*(zetam-z_isp(j,i))*cr_isp(j,i)*f0z_inv
        end do
     end do

!$omp end do

  case (2)  ! modification for low vorticity area

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           if(z_isp(j,i)<zetam.and.z_isp(j,i)>sth_thres_zeta)then
              ! cav = cr_isp/(f0+zetam)
              anm_isp(j,i)=(f0+z_isp(j,i))*(zetam-z_isp(j,i))*cr_isp(j,i)*f0z_inv
           end if
        end do
     end do

!$omp end do

  case (3)  ! forcing to the initial profile of vorticity

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           ! cav = cr_isp/(f0+zetam)
           anm_isp(j,i)=(f0+z_isp(j,i))*(zinit_isp(j,i)-z_isp(j,i))*cr_isp(j,i)/(f0+zinit_isp(j,i))
        end do
     end do

!$omp end do

  case default

     write(*,*) "*** ERROR (calc_STRETCH_term_NBM) ***: flag_stretch = .true. but, invalid for force_type."
     stop

  end select

!$omp end parallel

  call phys2spec_isp( anm_isp(1:jynt,1:jxnt), akl(1:kxnt,1:kynt) )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=-akl(i,1)/(((dble(i-1)*lxi)**2)*pi4)
!ORG     tma(jxnt-i+2,1)=dconjg(tma(i,1))
     tma(kxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=-akl(1,j)/(((dble(j-1)*lyi)**2)*pi4)
!ORG     tma(1,jynt-j+2)=akl(1,jynt-j+2)
     tma(1,kynt-j+2)=-akl(1,kynt-j+2)/(((dble(j-1)*lyi)**2)*pi4)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        tma(i,j)=-akl(i,j)/(((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*pi4)
                ! 上式は渦度から流線関数への変換計算
!ORG        tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
        tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
!ORG        tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
!ORG  &                     +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
        tma(i,kynt-j+2)=-akl(i,kynt-j+2)/(((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*pi4)
!ORG        tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
        tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

!ORG  call rearrange_3to2( tma, ADV )
  STRETCH=tma

end subroutine STRETCH_term_NBM


subroutine LIDAMP_term_NBM( psik, LIDAMP )
!-- calculating diffusion term
! -mu*zeta
  use Math_Const
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik      ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: LIDAMP ! linear damping term

  integer :: i, j
  double precision :: lxi, lyi, pi4

  LIDAMP=0.0d0

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     LIDAMP(i,1)=-mu*psik(i,1)
     LIDAMP(kxnt-i+2,1)=dconjg(LIDAMP(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     LIDAMP(1,j)=-mu*psik(1,j)
     LIDAMP(1,kynt-j+2)=-mu*psik(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        LIDAMP(i,j)=-mu*psik(i,j)
        LIDAMP(kxnt-i+2,kynt-j+2)=dconjg(LIDAMP(i,j))
        LIDAMP(i,kynt-j+2)=-mu*psik(i,kynt-j+2)
        LIDAMP(kxnt-i+2,j)=dconjg(LIDAMP(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine LIDAMP_term_NBM


subroutine force_NBM( psik, force, pk, u_isp, v_isp )
!-- calculating total forcing terms in NBM
  use savegloval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik       ! psi
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: force   ! total force
  complex(kind(0d0)), dimension(kxnt,kynt), intent(out), optional :: pk  ! p
  double precision, dimension(jynt,jxnt), intent(out), optional :: u_isp  ! u_isp
  double precision, dimension(jynt,jxnt), intent(out), optional :: v_isp  ! v_isp

  integer :: i, j
  complex(kind(0d0)), dimension(kxnt,kynt) :: ADV, DIFF, STRETCH, LIDAMP
  complex(kind(0d0)), dimension(kxnt,kynt) :: auukl, auvkl, avvkl

  force=0.0d0
  STRETCH=0.0d0
  LIDAMP=0.0d0

!-- calculating advecting term 

  if(calc_mbl_flag.eqv..true.)then
     call ADV_term_NBM( psik, ADV, u_nbm_isp=u_isp, v_nbm_isp=v_isp,  &
  &                     auukl=auukl, auvkl=auvkl, avvkl=avvkl )
     call diag_PRES( psik, auukl, auvkl, avvkl, pk )
  else
     call ADV_term_NBM( psik, ADV )
  end if

!-- calculating beta effect

!  call BETA_term_NBM( v, BETA )

!-- calculating diffusion term

  call DIFF_term_NBM( psik, DIFF )

!-- calculating stretching term

  if(flag_stretch.eqv..true.)then
     call STRETCH_term_NBM( psik, STRETCH )
  end if

!-- calculating rayleigh damping term

  if(flag_fric.eqv..true.)then
     call LIDAMP_term_NBM( psik, LIDAMP )
  end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do j=1,2*hynt+1
     do i=1,hxnt+1
!        force(i,j)=-ADV(i,j)+BETA(i,j)+DIFF(i,j)
!        force(i,j)=DIFF(i,j)
        force(i,j)=ADV(i,j)+DIFF(i,j)+STRETCH(i,j)+LIDAMP(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine force_NBM


end module force_nbm_solv
