!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Basis  ! Ūʷ׻ؿ¹Ԥ⥸塼

  type dtime  ! 
     integer :: year_d  ! 
     integer :: month_d  ! 
     integer :: day_d  ! 
     integer :: hour_d  ! 
     integer :: min_d  ! ʬ
     integer :: sec_d  ! 
  end type dtime

  integer, save :: check_array_size_iflag=0

  public  :: check_array_size_1d,  &
  &          check_array_size_i1_1d,  &
  &          check_array_size_i2_1d,  &
  &          check_array_size_i4_1d,  &
  &          check_array_size_f4_1d,  &
  &          check_array_size_d8_1d

  public  :: check_array_size_2d,  &
  &          check_array_size_i1_2d,  &
  &          check_array_size_i2_2d,  &
  &          check_array_size_i4_2d,  &
  &          check_array_size_f4_2d,  &
  &          check_array_size_d8_2d

  public  :: check_array_size_3d,  &
  &          check_array_size_i1_3d,  &
  &          check_array_size_i2_3d,  &
  &          check_array_size_i4_3d,  &
  &          check_array_size_f4_3d,  &
  &          check_array_size_d8_3d

  interface check_array_size_1d
     module procedure check_array_size_i1_1d,  &
  &                   check_array_size_i2_1d,  &
  &                   check_array_size_i4_1d,  &
  &                   check_array_size_f4_1d,  &
  &                   check_array_size_d8_1d
  end interface check_array_size_1d

  interface check_array_size_2d
     module procedure check_array_size_i1_2d,  &
  &                   check_array_size_i2_2d,  &
  &                   check_array_size_i4_2d,  &
  &                   check_array_size_f4_2d,  &
  &                   check_array_size_d8_2d
  end interface check_array_size_2d

  interface check_array_size_3d
     module procedure check_array_size_i1_3d,  &
  &                   check_array_size_i2_3d,  &
  &                   check_array_size_i4_3d,  &
  &                   check_array_size_f4_3d,  &
  &                   check_array_size_d8_3d
  end interface check_array_size_3d

contains

subroutine rand_make(L,output)
  ! Ǥդηǵ륵֥롼
  ! ƱˡȤ르ꥺѤƵ
  ! $x_{n+1}=a\times x_{n}+b (mod \; L)$
  implicit none
  integer, intent(in) :: L  ! Ϥ + 1 ο
  integer, intent(inout) :: output  ! Ϥ
  integer :: a, b, x0, i, input
  integer, external :: time

  input=time()
  input=mod(input,L)
  a=11
  b=12
  x0=input

  do i=1,10
     x0=a*x0+b
     x0=mod(x0,L)
  end do

  output=x0

end subroutine

!-----------------------------------
!-----------------------------------

subroutine multi_rand_make(L,n,interval,output)
  ! rand_make ѤǤդθĿ.
  implicit none
  integer, intent(in) :: L  ! Ϥ + 1 ο
  integer, intent(in) :: n  ! θĿ
  integer, intent(in) :: interval  ! μδֳ
  integer, intent(inout) :: output(n)  ! Ϥ
  integer :: a, b, x0, i, j, input, itmp
  integer, external :: time

  itmp=0

  do j=1,n
     if(j==1)then
        itmp=time()
     else
        itmp=itmp+interval
     end if

     input=mod(itmp,L)
     a=11
     b=12
     x0=input

     do i=1,10
        x0=a*x0+b
        x0=mod(x0,L)
     end do

     output(j)=x0

  end do

end subroutine

!-----------------------------------
!-----------------------------------

character(100) function r2c_convert( rval, forma )
! ¿ʸѴ
  implicit none
  real, intent(in) :: rval  ! Ѵ¿
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) rval
  else
     write(tmp,*) rval
  end if

  r2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

real function c2r_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2r_convert

  return
end function

!-----------------------------------
!-----------------------------------

character(100) function i2c_convert( ival, forma )
! ¿ʸѴ
  implicit none
  integer, intent(in) :: ival  ! Ѵ
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) ival
  else
     write(tmp,*) ival
  end if

  i2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

integer function c2i_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2i_convert

  return
end function

!-----------------------------------
!-----------------------------------

integer function split_num( cval, split_str )
! split_str ǻꤵ줿ʸʬȤ, ʸ cval ʬ䤷Ȥ
! ʬĿ֤. split_str ꤵʤ, ʸʬ䵭Ȥƽ.
! , ʬ䵭 1 ʸΤб.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  character(1), intent(in), optional :: split_str  ! ʬ䵭
  character(1) :: split
  integer :: nc, counter, i
  logical :: double_flag

  if(present(split_str))then
     split=trim(adjustl(split_str))
  else
     split=' '
  end if

  nc=len_trim(adjustl(cval))
  counter=0
  double_flag=.false.

  do i=1,nc
     if(cval(i:i)==split)then
        counter=counter+1
     end if
  end do

  split_num=counter+1

  return
end function

!-----------------------------------
!-----------------------------------

subroutine splitting( cval, num, cval_ar, split_str )
! cval  split_str ʬʸȤ cval_ar Ȥʬ䤹.
! , split_str  1 ʸˤΤбƤ. ǥեȤǤȾѥڡ
! бƤ.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  integer, intent(in) :: num        ! num Ĥʬ.
                                    ! ͤ split_num ؿĴ٤Ƥ.
  character(*), dimension(num), intent(inout) :: cval_ar
                                    ! ʬ䤵줿ʸ󤬳Ǽ.
  character(1), intent(in), optional :: split_str
  character(1) :: split
  integer :: nc, counter, i
  integer, dimension(num) :: isnum, ienum
  logical :: double_flag

  if(present(split_str))then
     split=split_str
  else
     split=' '
  end if

  nc=len(cval)
  double_flag=.false.

  if(cval(1:1)==split)then
     isnum(1)=-1
     ienum(1)=0
     isnum(2)=2
     counter=2
  else
     isnum(1)=1
     counter=1
  end if

  do i=2,nc-1  ! ʸκǽȺǸʬʸäƤƤ⤽̵Ǥ뤿.
     if(cval(i:i)==split)then
        ienum(counter)=i-1
        counter=counter+1
        isnum(counter)=i+1
     end if
  end do

  if(counter>num)then
     write(*,*) "*** ERROR (basis:splitting) *** : counter exceeds num. Stop."
     stop
  end if

  if(cval(nc:nc)==split)then
     ienum(counter)=nc-1
  else
     ienum(num)=nc
  end if

  do i=1,num
     if(isnum(i)>ienum(i))then
        cval_ar(i)=''
     else
        cval_ar(i)=cval(isnum(i):ienum(i))
     end if
  end do

end subroutine splitting

!-----------------------------------
!-----------------------------------

subroutine gsub( cval, oval, bc, ac, mode )
! cval ˤ, ʸ bc ʸ ac ֤.
! ac  bc ʸפƤɬפϤʤ, bc > ac ξϺͤ
! cval ʸʤʤ. դ ac > bc ξʸ¿ʤ.
!  mode ֤Υץ.
  implicit none
  character(*), intent(in) :: cval ! ֤ʸ
  character(*), intent(inout) :: oval ! ֤̤ʸ
  character(*), intent(in) :: bc    ! ֤ʸ
  character(*), intent(in) :: ac    ! ֤ʸ
  integer, intent(in), optional :: mode  ! 1 = ǥե (1 ֤)
                                         ! 2 = ֤ʸ֤
                                         ! ʸ󤬤ޤĤäƤ, 
                                         ! ֤Ԥ, ʤʤޤ
                                         ! 򷫤֤.
  character(10000) :: tmpc
  integer :: nc, bcounter, acounter, nbc, nac, noc, imode
  logical :: mode_flag, loopflag

  if(present(mode))then
     imode=mode
  else
     imode=1
  end if
  tmpc=''

  nc=len(cval)
  nbc=len(bc)
  nac=len(ac)

  oval=""
  bcounter=1
  acounter=1

  do while (bcounter<=nc)
     if(bcounter+nbc-1<=nc)then  ! ʸĶƤ뤫
        if(cval(bcounter:bcounter+nbc-1)==bc(1:nbc))then
           oval(acounter:acounter+nac-1)=ac(1:nac)
           acounter=acounter+nac
           bcounter=bcounter+nbc
        else
           oval(acounter:acounter)=cval(bcounter:bcounter)
           acounter=acounter+1
           bcounter=bcounter+1
        end if
     else  ! ĶƤФλʹߤ֤ʸ¸ߤʤ.
        oval(acounter:acounter+nc-bcounter+1)=cval(bcounter:nc)
        acounter=acounter+nc-bcounter+2
        bcounter=nc+1
        noc=acounter-1
        exit
     end if
  end do

  select case (imode)
  case (2)   ! ʣåƤʤʤޤ֤

     tmpc=''
     loopflag=.true.

     do while (loopflag.eqv..true.)

        nc=noc
        nbc=len(bc)
        nac=len(ac)

        tmpc=""
        acounter=1
        bcounter=1

        do while (bcounter<=nc)
           if(bcounter+nbc-1<=nc)then  ! ʸĶƤ뤫
              if(oval(bcounter:bcounter+nbc-1)==bc(1:nbc))then
                 tmpc(acounter:acounter+nac-1)=ac(1:nac)
                 acounter=acounter+nac
                 bcounter=bcounter+nbc
              else
                 tmpc(acounter:acounter)=oval(bcounter:bcounter)
                 acounter=acounter+1
                 bcounter=bcounter+1
              end if
           else  ! ĶƤФλʹߤ֤ʸ¸ߤʤ.
              tmpc(acounter:acounter+nc-bcounter+1)=oval(bcounter:nc)
              acounter=acounter+nc-bcounter+2
              bcounter=nc+1
              noc=acounter-1
              exit
           end if
        end do

        if(oval(1:len(oval))==tmpc(1:len(tmpc)))then
           loopflag=.false.
        end if

        oval=tmpc(1:noc)

     end do

  end select

  return

end subroutine gsub

!-----------------------------------
!-----------------------------------

integer function counter_day( stime, etime )
! 齪λޤǤ򥫥Ȥ.
  implicit none
  type(dtime), intent(in) :: stime  ! 
  type(dtime), intent(in) :: etime  ! λ
  integer, parameter, dimension(13) :: month=(/31,28,31,30,31,30,  &
  &                                            31,31,30,31,30,31,29/)
  integer :: nt, nm, days, i, year_tmp, year_fact
  integer :: nsy, nsm, nsd, ney, nem, ned

  nt=etime%year_d-stime%year_d
  nsy=stime%year_d
  ney=etime%year_d

  nm=etime%month_d-stime%month_d
  days=0
  nsm=stime%month_d
  nsd=stime%day_d
  nem=etime%month_d
  ned=etime%day_d

!-- etime%year_d  stime%year_d δ֤ 1 ǯʾ֤,
!-- δ֤ǯñ̤­. (ǯǾʬ.)
  if(nt>1)then
     do i=nsy+1,ney-1
        if(check_leap_year(i).eqv..true.)then
           year_fact=366
        else
           year_fact=365
        end if
        days=days+year_fact
     end do
  end if

!-- νԤäƤΤ, ȤϽλǯ­,
!-- ǯǳޤǤҤΤ.
!-- ޤ, 1 ޤޤ¸ߤ­碌.
!-- ,  12 , λ 1 ξ, ­­Τ,
!-- ǤϥȤʤ.
  if(nsy<ney)then  ! ǯޤ
     ! λ­碌
     if(nem>1)then  ! λ 1 ǤϤʤ.
        do i=1,nem-1
           if((i==2).and.(check_leap_year(ney).eqv..true.))then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if

     do i=nsm,12
        if((i==2).and.(check_leap_year(nsy).eqv..true.))then
           days=days+month(13)
        else
           days=days+month(i)
        end if
     end do

  else

     if(nm>0)then  ! ǯޤ餺, ޤ.
        do i=nsm,nem-1
           if((i==2).and.(check_leap_year(ney).eqv..true.))then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if
  end if

  days=days+ned-nsd

  days=days+1
  counter_day=days

  return
end function

!-----------------------------------
!-----------------------------------

integer function counter_sec( stime, etime )
! 齪λޤǤÿ򥫥Ȥ.
  implicit none
  type(dtime), intent(in) :: stime  ! 
  type(dtime), intent(in) :: etime  ! λ
  integer :: nday, tmp_sec
  integer :: nsh, nsm, nss, neh, nem, nes

  tmp_sec=0

!-- ޤ, 򥫥Ȥ.

  nday=counter_day( stime, etime )

!-- 򸵤, ʬä򥫥.
! counter_day  1 ׻Ƥ뤫
! ƱǤ counter_day = 1, 24 ְޤ counter_day = 2.

  if(nday>2)then
     tmp_sec=(nday-2)*86400
  end if

!-- stime  etime ޤǤ hour, minite, sec ׻, ȡä֤.

  nsh=stime%hour_d
  nsm=stime%min_d
  nss=stime%sec_d
  neh=etime%hour_d
  nem=etime%min_d
  nes=etime%sec_d

  if(nday==1)then  !  1 ¸ߤ, hour Τ߷׻.
     tmp_sec=tmp_sec+(neh-nsh)*3600+(nem-nsm)*60+(nes-nss)
  else  ! ޤäƤ, stime  86400 s ǥȤƤ
        ! nsh, nsm, nss Фä׻Ǥ.
     tmp_sec=tmp_sec+86400  ! stime  1 ʬ
     tmp_sec=tmp_sec+neh*3600+nem*60+nes  ! etime ä­
     tmp_sec=tmp_sec-nsh*3600-nsm*60-nss  ! stime ä
  end if

  counter_sec=tmp_sec

  return
end function

!-----------------------------------
!-----------------------------------

subroutine time_zone_convert( factor, itime, ctime )
! ॾѴԤ롼
! 㤨, JST  UTC Ѵ, factor = -9 ȤФ褤.
  implicit none
  integer, intent(in) :: factor        ! Ѳ뤫.
  type(dtime), intent(in) :: itime     ! Ѵλ
  type(dtime), intent(inout) :: ctime  ! Ѵλ
  integer :: iyear, imonth, iday, ihour
  integer, parameter, dimension(13) :: month=(/31,28,31,30,31,30,  &
  &                                            31,31,30,31,30,31,29/)

  iyear=itime%year_d
  imonth=itime%month_d
  iday=itime%day_d
  ihour=itime%hour_d

  ihour=ihour+factor

  if(ihour<0)then
     do while(ihour<0)
        iday=iday-1
        ihour=ihour+24
     end do
  else if(ihour>=24)then
     do while(ihour>=24)
        iday=iday+1
        ihour=ihour-24
     end do
  end if

  if(iday<1)then
     do while(iday<1)
        if((check_leap_year(iyear).eqv..true.).and.(imonth==2))then
           iday=iday+month(13)
        else
           iday=iday+month(imonth)
        end if

        imonth=imonth-1

        if(imonth<=0)then
           iyear=iyear-1
           imonth=12
        end if
     end do
  else if(iday>month(imonth))then
     do while(iday>month(imonth))
        if((check_leap_year(iyear).eqv..true.).and.(imonth==2))then
           iday=iday-month(13)
        else
           iday=iday-month(imonth)
        end if
        imonth=imonth+1
        if(imonth>12)then
           iyear=iyear+1
           imonth=imonth-12
        end if
     end do
  end if

  ctime%year_d=iyear
  ctime%month_d=imonth
  ctime%day_d=iday
  ctime%hour_d=ihour
  ctime%min_d=itime%min_d
  ctime%sec_d=itime%sec_d

end subroutine

!-----------------------------------
!-----------------------------------

subroutine sec_convert( factor, itime, ctime )
! factor ʬ, øԤ롼
  implicit none
  integer, intent(in) :: factor        ! øԤÿ.
  type(dtime), intent(in) :: itime     ! Ѵλ
  type(dtime), intent(inout) :: ctime  ! Ѵλ
  type(dtime) :: ttime
  integer :: ifact, ofact, fhour, fmin, fsec

  fhour=factor/3600
  fmin=(factor-fhour*3600)/60  ! factor is both of positive and negative.
  fsec=factor-fhour*3600-fmin*60

  !-- sec
  ttime%sec_d=itime%sec_d+fsec
  ttime%min_d=itime%min_d+fmin
  ttime%hour_d=itime%hour_d+fhour
  ttime%day_d=itime%day_d
  ttime%month_d=itime%month_d
  ttime%year_d=itime%year_d

  do while(ttime%sec_d<0)
     ttime%min_d=ttime%min_d-1
     ttime%sec_d=ttime%sec_d+60
  end do

  do while(ttime%sec_d>=60)
     ttime%min_d=ttime%min_d+1
     ttime%sec_d=ttime%sec_d-60
  end do

  do while(ttime%min_d<0)
     ttime%hour_d=ttime%hour_d-1
     ttime%min_d=ttime%min_d+60
  end do

  do while(ttime%min_d>=60)
     ttime%hour_d=ttime%hour_d+1
     ttime%min_d=ttime%min_d-60
  end do

  call time_zone_convert( 0, ttime, ctime )

end subroutine

!-----------------------------------
! Private functions
!-----------------------------------

integer function check_array_size_i1_1d( n1, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer(1), intent(in) :: a(:)

  if(size(a)/=n1)then
     check_array_size_i1_1d=1
  else
     check_array_size_i1_1d=0
  end if

  return

end function check_array_size_i1_1d

integer function check_array_size_i2_1d( n1, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer(2), intent(in) :: a(:)

  if(size(a)/=n1)then
     check_array_size_i2_1d=1
  else
     check_array_size_i2_1d=0
  end if

  return

end function check_array_size_i2_1d

integer function check_array_size_i4_1d( n1, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: a(:)

  if(size(a)/=n1)then
     check_array_size_i4_1d=1
  else
     check_array_size_i4_1d=0
  end if

  return

end function check_array_size_i4_1d

integer function check_array_size_f4_1d( n1, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  real, intent(in) :: a(:)

  if(size(a)/=n1)then
     check_array_size_f4_1d=1
  else
     check_array_size_f4_1d=0
  end if

  return

end function check_array_size_f4_1d

integer function check_array_size_d8_1d( n1, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  double precision, intent(in) :: a(:)

  if(size(a)/=n1)then
     check_array_size_d8_1d=1
  else
     check_array_size_d8_1d=0
  end if

  return

end function check_array_size_d8_1d

integer function check_array_size_i1_2d( n1, n2, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer(1), intent(in) :: a(:,:)

  if(size(a,1)/=n1)then
     check_array_size_i1_2d=1
  else
     check_array_size_i1_2d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i1_2d=check_array_size_i1_2d+2
  end if

  return

end function check_array_size_i1_2d

integer function check_array_size_i2_2d( n1, n2, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer(2), intent(in) :: a(:,:)

  if(size(a,1)/=n1)then
     check_array_size_i2_2d=1
  else
     check_array_size_i2_2d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i2_2d=check_array_size_i2_2d+2
  end if

  return

end function check_array_size_i2_2d

integer function check_array_size_i4_2d( n1, n2, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: a(:,:)

  if(size(a,1)/=n1)then
     check_array_size_i4_2d=1
  else
     check_array_size_i4_2d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i4_2d=check_array_size_i4_2d+2
  end if

  return

end function check_array_size_i4_2d

integer function check_array_size_f4_2d( n1, n2, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  real, intent(in) :: a(:,:)

  if(size(a,1)/=n1)then
     check_array_size_f4_2d=1
  else
     check_array_size_f4_2d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_f4_2d=check_array_size_f4_2d+2
  end if

  return

end function check_array_size_f4_2d

integer function check_array_size_d8_2d( n1, n2, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  double precision, intent(in) :: a(:,:)

  if(size(a,1)/=n1)then
     check_array_size_d8_2d=1
  else
     check_array_size_d8_2d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_d8_2d=check_array_size_d8_2d+2
  end if

  return

end function check_array_size_d8_2d

integer function check_array_size_i1_3d( n1, n2, n3, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: n3  ! reference array size
  integer(1), intent(in) :: a(:,:,:)

  if(size(a,1)/=n1)then
     check_array_size_i1_3d=1
  else
     check_array_size_i1_3d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i1_3d=check_array_size_i1_3d+2
  end if

  if(size(a,3)/=n3)then
     check_array_size_i1_3d=check_array_size_i1_3d+4
  end if

  return

end function check_array_size_i1_3d

integer function check_array_size_i2_3d( n1, n2, n3, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: n3  ! reference array size
  integer(2), intent(in) :: a(:,:,:)

  if(size(a,1)/=n1)then
     check_array_size_i2_3d=1
  else
     check_array_size_i2_3d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i2_3d=check_array_size_i2_3d+2
  end if

  if(size(a,3)/=n3)then
     check_array_size_i2_3d=check_array_size_i2_3d+4
  end if

  return

end function check_array_size_i2_3d

integer function check_array_size_i4_3d( n1, n2, n3, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: n3  ! reference array size
  integer, intent(in) :: a(:,:,:)

  if(size(a,1)/=n1)then
     check_array_size_i4_3d=1
  else
     check_array_size_i4_3d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_i4_3d=check_array_size_i4_3d+2
  end if

  if(size(a,3)/=n3)then
     check_array_size_i4_3d=check_array_size_i4_3d+4
  end if

  return

end function check_array_size_i4_3d

integer function check_array_size_f4_3d( n1, n2, n3, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: n3  ! reference array size
  real, intent(in) :: a(:,:,:)

  if(size(a,1)/=n1)then
     check_array_size_f4_3d=1
  else
     check_array_size_f4_3d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_f4_3d=check_array_size_f4_3d+2
  end if

  if(size(a,3)/=n3)then
     check_array_size_f4_3d=check_array_size_f4_3d+4
  end if

  return

end function check_array_size_f4_3d

integer function check_array_size_d8_3d( n1, n2, n3, a )
  implicit none
  integer, intent(in) :: n1  ! reference array size
  integer, intent(in) :: n2  ! reference array size
  integer, intent(in) :: n3  ! reference array size
  double precision, intent(in) :: a(:,:,:)

  if(size(a,1)/=n1)then
     check_array_size_d8_3d=1
  else
     check_array_size_d8_3d=0
  end if

  if(size(a,2)/=n2)then
     check_array_size_d8_3d=check_array_size_d8_3d+2
  end if

  if(size(a,3)/=n3)then
     check_array_size_d8_3d=check_array_size_d8_3d+4
  end if

  return

end function check_array_size_d8_3d

subroutine check_array_size_dmp_message( stat, routine_name )
  implicit none
  integer, intent(in) :: stat
  character(*), intent(in) :: routine_name
  character(100) :: mes, err_num

  select case (check_array_size_iflag)
  case (1)
     mes='Message'
  case (2)
     mes='Warning'
  case (3)
     mes='Error'
  end select

  if(stat>0)then
     select case (stat)
     case (1)
        err_num='1'
     case (2)
        err_num='2'
     case (3)
        err_num='1, 2'
     case (4)
        err_num='3'
     case (5)
        err_num='1, 3'
     case (6)
        err_num='2, 3'
     case (7)
        err_num='1, 2, 3'
     end select

     write(*,*) "*** "//trim(adjustl(mes))//" ("  &
  &             //trim(adjustl(routine_name))//") *** : "  &
  &             //"Invalid array size = "//trim(adjustl(err_num))//'.'
     if(check_array_size_iflag==3)then
        stop
     end if
  end if

end subroutine check_array_size_dmp_message


logical function check_leap_year( year )
! ǯɤȽǤ, ǯʤ .true. ֤.

  implicit none

  integer, intent(in) :: year    ! 
  logical :: tmpl

  tmpl=.false.

  if(mod(year,4)==0)then
     if(mod(year,100)==0)then
        if(mod(year,400)==0)then
           tmpl=.true.
        end if
     else
        tmpl=.true.
     end if
  end if

  check_leap_year=tmpl

  return

end function check_leap_year

end module
