program traj_sample
! Ū®پǡή׻.
  use Math_Const
  use Trajectory

  implicit none

  integer :: i, j, k, dnum
  integer, parameter :: nx=100, ny=100    ! ʿʻ
  integer, parameter :: nt=10             ! ®پǡλֳִ
  integer, parameter :: tstep=200         ! ήη׻ƥå
  real, dimension(nx,ny,nt) :: u, v       ! ׻Ѥǡ
  real, dimension(nx,ny,nt) :: ru, rv     ! ׻Ѥǡ
  real, dimension(tstep,1) :: tx, ty      ! ή x, y ɸ
  real :: x(nx), y(ny), t(nt), rt(nt)     ! ֺɸ
  real, parameter :: xmin=-pi, xmax=pi    ! x ΰ 
  real, parameter :: ymin=-pi, ymax=pi    ! y ΰ
  real, parameter :: tmin=0.0, tmax=pi    ! t ΰ
  real :: dtstep                          ! ήη׻ֳִ
  real :: dx, dy, dt                      ! ʻҲ
  character(3) :: sche
  logical :: FTF(1)

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)
  dt=(tmax-tmin)/(nt-1)
  dtstep=(tmax-tmin)/(tstep-1)

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)
  t=(/((tmin+dt*(i-1)),i=1,nt)/)
  rt=(/((tmax-dt*(i-1)),i=1,nt)/)

  tx(1,1)=0.1
  ty(1,1)=0.1

  write(*,*) "input scheme of time integration."
  write(*,*) "EU1 or RK4."
  read(*,*) sche

  write(*,*) "input direction of trajectory for time."
  write(*,*) "1 = Forward, 2 = Backward."
  read(*,*) dnum

  do k=1,nt
     do j=1,ny
        do i=1,nx
           u(i,j,k)=cos(t(k))  ! Ū®پͿ.
           v(i,j,k)=sin(t(k))  ! Ū®پͿ.
           ru(i,j,k)=cos(rt(k))  ! Ū®پͿ.
           rv(i,j,k)=sin(rt(k))  ! Ū®پͿ.
!           u(i,j,k)=sin(x(i))+sin(y(j))+sin(t(k))  ! Ū®پͿ.
!           v(i,j,k)=sin(x(i))+sin(y(j))+sin(t(k))  ! Ū®پͿ.
!           ru(i,j,k)=sin(x(i))+sin(y(j))+sin(rt(k))  ! Ū®پͿ.
!           rv(i,j,k)=sin(x(i))+sin(y(j))+sin(rt(k))  ! Ū®پͿ.
        end do
     end do
  end do

  select case (dnum)
  case (1)
  call Forward_Traject_2d(  &
  &                    dtstep,  &            ! ֳִ
  &                    tmin,  &              ! ϻ
  &                    tstep,  &             ! ֥ƥå
  &                    tx(1:1,1),  &       ! ѡν x ɸ
  &                    ty(1:1,1),  &       ! ѡν y ɸ
  &                    t, x, y,  &           ! x, y ɸ
  &                    u, v,  &              ! x, y γƤ®پ
  &                    tx(:,1:1), ty(:,1:1),  &  ! ºݤήε
  &                    FTF(1:1),  &          ! ή׻ΰ賰˽ФȽ
  &                    opt=trim(sche) )      ! ֥
  case (2)
  ! ξ, , ®پǡƵոλ֤ǼƤ.
  call Backward_Traject_2d(  &
  &                    dtstep,  &            ! ֳִ
  &                    tmax,  &              ! ϻ
  &                    tstep,  &             ! ֥ƥå
  &                    tx(1:1,1),  &       ! ѡν x ɸ
  &                    ty(1:1,1),  &       ! ѡν y ɸ
  &                    rt, x, y,  &          ! x, y ɸ
  &                    ru, rv,  &            ! x, y γƤ®پ
  &                    tx(:,1:1), ty(:,1:1),  &  ! ºݤήε
  &                    FTF(1:1),  &          ! ή׻ΰ賰˽ФȽ
  &                    opt=trim(sche) )      ! ֥
  end select

  open(unit=10,file='traj_sample.dat',status='unknown')
     write(10,*) "x ", "y"
     write(10,*) "x ", "y"
     do i=1,tstep
        write(10,*) tx(i,1), ty(i,1)
     end do
  close(unit=10)

end program
