program fft_test
! fft 롼Ѥ, ƥȥǡ饹ڥȥʬۤ׻롼

  use file_operate
  use Basis
  use ffts
  use Math_Const
  use max_min

  implicit none

  integer :: na, nl
  integer :: i, j, l, emax, loop
  integer, dimension(5) :: prim

  real :: period
  real, allocatable :: sp(:,:)
  real, allocatable :: val(:,:)

  complex, allocatable :: co(:,:)
  complex, allocatable, dimension(:,:) :: omegar, omegai, omeganr, omegani

  character(20), allocatable, dimension(:,:) :: cval
  character(20) :: fom, fomc
  character(100) :: fname, foname
  character(1000) :: ctitle

  write(*,*) "Input a reading file name."
  write(*,*) "If there is no file, input 'dummy'"
  read(*,*) fname

  if(trim(fname)/='dummy')then
     write(*,*) "Input the reading number of array."
     read(*,*) na

!-- reading file

     nl=line_number_counter( trim(fname) )

!-- checking "nl" (If nl is not prim factor of 2, 
!-- nl is forced to become prim factor of 2.)

write(*,*) "nl check", nl
     if(mod(nl,2)/=0)then
        nl=nl-1
        write(*,*) "message : colum number is not even number."
        write(*,*) "nl is FORCED to become even number."
     end if

write(*,*) "nl check", nl
     allocate(cval(na,nl))
     allocate(val(nl,na))

     call read_file_text( trim(fname), na, nl, cval )

!-- converting from character to float

     do j=1,nl
        do i=1,na
           val(j,i)=c2r_convert( trim(adjustl(cval(i,j))) )
        end do
     end do

  else

     write(*,*) "Automatically, sample file is producted."

     na=3
     nl=100

     allocate(val(nl,na))

     do i=1,nl
        val(i,1)=sin(2.0*pi*(real(i-1)/real(nl-1)))
        val(i,2)=val(i,1)+sin(4.0*pi*(real(i-1)/real(nl-1)))
        val(i,3)=val(i,1)+val(i,2)+sin(6.0*pi*(real(i-1)/real(nl-1)))
     end do

  end if

!-- NOTICE : array order is opposite (char : na, nl) (float : nl, na)
  allocate(co(nl/2,na))
  allocate(sp(nl/2,na))

!-- calculating prim factors for nl

  call prim_calc( nl, prim(1:4), prim(5) )
  write(*,*) "result prim", prim(1), prim(2), prim(3), prim(4), prim(5)

!-- calculating rotating arrays

  allocate(omegar(0:nl/2-1,0:nl/2-1))
  allocate(omegai(0:nl/2-1,0:nl/2-1))
  allocate(omeganr(0:nl/2-1,0:nl/2-1))
  allocate(omegani(0:nl/2-1,0:nl/2-1))

  call rotate_array_f()
  call rotate_calc( nl/2, 'r', (/prim(1)-1,prim(2),prim(3),prim(4),prim(5)/),  &
  &                 omegar(0:prim(5)-1,0:prim(5)-1),  &
  &                 omeganr(0:nl/2-1,0:nl/2-1) )
  call rotate_calc( nl/2, 'i', (/prim(1)-1,prim(2),prim(3),prim(4),prim(5)/),  &
  &                 omegai(0:prim(5)-1,0:prim(5)-1),  &
  &                 omegani(0:nl/2-1,0:nl/2-1) )


  do j=1,na
     call r2c_ffttp_1d( nl, val(1:nl,j), co(1:nl,j),  &
  &                     prim='o', prim_fact=prim,  &
  &                     omega_fix=omegar, omegan_fix=omeganr )
!     call c2r_ffttp_1d( nl, co, ren(1:nl,j), prim='o', prim_fact=prim,  &
!  &                     omega_fix=omegai, omegan_fix=omegani )
     do i=2,nl/2
        sp(i,j)=abs(co(i,j))
     end do
     sp(1,j)=abs(real(co(1,j)))
     sp(nl/2+1,j)=abs(aimag(co(1,j)))
  end do

  write(*,*) "### Finished calculating."
  write(*,*) "Input the output file name."
  read(*,*) foname

  write(*,*) "Input the calculating period."
  write(*,*) "(data period)"
  read(*,*) period

!-- formatting of output

  fom='(1P,'//trim(adjustl(i2c_convert( na+3 )))//'E14.5)'
write(*,*) "check a format", trim(fom)

  ctitle='wave-number frequency period '

  do i=1,na
     ctitle=trim(ctitle)//' val'
  end do

  fomc='(a'//trim(adjustl(i2c_convert( len_trim(ctitle) )))//')'

!-- output another file

  open(unit=11,file=trim(foname),status='unknown')

     write(11,trim(fomc)) trim(ctitle)
     write(11,trim(fomc)) trim(ctitle)

     write(11,trim(fom)) 0.0, 0.0, period, (sp(1,i),i=1,na)

     do j=2,nl/2+1
        write(11,trim(fom)) real(j-1), real(j-1)/period, period/real(j-1),  &
  &                         (sp(j,i),i=1,na)
     end do

  close(unit=11,status='keep')

end program
