program sound_2d
! ʣΥǥǡƹ٤ˤĤƥڥȥ׻, ȿˤĤƤ
! ڥȥޤץ.
! ꥹȥǡΥեޥåȤ
! YYYYMMDDHH file_name
! FFT ׻Ѥ뤿, ɬǡƤ뤳.
! ̤ 1/day ñ̤ɽ. Ǥδ¬ֳ֤ 6 ٤Ǥ뤿.

  use dcl
  use Dcl_Automatic
  use file_operate
  use basis
  use Statistics
  use Thermo_Function
  use Math_Const
  use ffts

  implicit none

!-- integer
  integer :: nt       ! γʻҿ
  integer :: nz       ! z γʻҿ
  integer :: nf       ! conv_dat ѥǡ
  integer :: IWS      ! ǥХ
  integer :: dt       ! ǡλֳִ [s]
  integer :: period   ! ǡΥȡ [s]
  integer :: i_counter    ! 󥿡
  integer :: i_counter_c  ! 󥿡
  integer :: snum, cnum  ! 顼ο
  integer :: cont_flag, shade_flag  ! 顼, ѥե饰ѿ
  integer :: prim(5)
  integer, allocatable, dimension(:) :: year_v    ! ǯ
  integer, allocatable, dimension(:) :: month_v   ! 
  integer, allocatable, dimension(:) :: day_v     ! 
  integer, allocatable, dimension(:) :: hour_v    ! 
  integer, allocatable, dimension(:) :: inter_z ! ѹ
  integer, allocatable, dimension(:) :: i_flag  ! 
  integer, allocatable, dimension(:) :: o_flag  ! 
  integer, allocatable, dimension(:) :: c_flag  ! 
!-- tmp
  integer :: nttmp, i, j, k, i_undef
!-- parameter
  integer, parameter :: col_num=6
  integer, parameter :: skip_num=2

!-- real
  real :: z_bot       ! βü
  real :: z_top       ! ξü
  real :: dz          ! ľֳ [m]
  real :: dvy         ! vy δֳ
  real :: smax, smin, cmax, cmin  ! 顼, ξ
  real, allocatable, dimension(:) :: freq  ! ư
  real, allocatable, dimension(:) :: z     ! ٺɸ
  real, allocatable, dimension(:) :: vx     ! viewport 
  real, allocatable, dimension(:,:) :: vy     ! viewport 
  real, allocatable, dimension(:,:) :: val_f        ! ׻
  real, allocatable, dimension(:,:) :: val_inter    ! ׻ѿ
  real, allocatable, dimension(:,:) :: tline        ! ׻ѿ
  real, allocatable, dimension(:,:) :: yline        ! ׻ѿ
  real, allocatable, dimension(:,:,:) :: val_tmp    ! ׻ѿ
  real, allocatable, dimension(:,:,:) :: val_draw   ! ѿ
  real :: undef
  real :: conv_undef
!-- tmp
  real, dimension(2) :: pt_tmp, ept_tmp, sept_tmp, rh_tmp, s_int, c_int

!-- complex part
  complex, allocatable, dimension(:) :: val_fft   ! ׻ѿ
  complex, allocatable, dimension(:,:) :: omegar    ! ׻ѿ
  complex, allocatable, dimension(:,:) :: omeganr   ! ׻ѿ

!-- character
  character(80) :: flist         ! եꥹ̾
  character(80) :: conv_dat      ! sound_1d ǽϤήѥ᡼ǡ
  character(80) :: title_txt     ! ȥ̾
  character(10) :: cont_val      ! ѿ̾
  character(10) :: shade_val     ! 顼ѿ̾
  character(10) :: conv_list     ! ǡե饰
  character(80), allocatable, dimension(:,:) :: fname  ! ե̾
  character(20), allocatable, dimension(:,:) :: val_w  ! ƥȥǡ
  character(70) :: sysfont
!-- tmp
  character(80) :: tmp_c

!-- logical
  logical :: mean_flag       ! ʿѾ (FFT  0 ʬ) ե饰
  logical, allocatable, dimension(:) :: fflag  ! ƹ٤ undef  1 ĤǤäƤ뤫.

!-- namelist reading
  namelist /input /flist, conv_dat, conv_list, conv_undef, dz, z_bot,  &
  &                z_top, IWS, title_txt,  &
  &                cmin, cmax, smin, smax, cont_val, shade_val,  &
  &                mean_flag, cnum, snum, undef, sysfont
  read(5,nml=input)

  nz=int((z_top-z_bot)/dz)+1
  nt=line_number_counter( trim(flist) )
  if(mod(nt,2)/=0)then
     nt=nt-1  ! ξ, ֤.
  end if
  period=dt*(nt-1)
  s_int=(/smin, smax/)
  c_int=(/cmin, cmax/)

  allocate(fname(2,nt))
  allocate(freq(nt/2))
  allocate(z(nz))
  allocate(inter_z(nz))
  allocate(val_inter(col_num+4,nz))
  allocate(val_draw(col_num+4,nt,nz))
  allocate(val_tmp(col_num+4,nt,nz))
  allocate(val_fft(nt/2))
  allocate(year_v(nt))
  allocate(month_v(nt))
  allocate(day_v(nt))
  allocate(hour_v(nt))
  allocate(fflag(nz))
  allocate(omegar(nt/2,nt/2))
  allocate(omeganr(nt/2,nt/2))

  fflag=.false.

!-- DCL set
  if(len_trim(adjustl(sysfont))/=0)then
     call SGISET( 'IFONT', 1 )
     call SWLSET( 'LSYSFNT', .true. )
     write(*,*) "This drawing mode is sysfont."
  else
     call SGISET( 'IFONT', 2 )
     write(*,*) "This drawing mode is dclfont."
  end if

  call UZFACT(0.8)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )
  CALL GLRSET( 'RMISS', undef )
  CALL GLLSET( 'LMISS', .TRUE. )

  call read_file_text( trim(flist), 2, nt, fname )

  do i=1,nt
     tmp_c=trim(fname(2,i))
     year_v(i)=c2i_convert( trim(tmp_c(1:4)) )
     month_v(i)=c2i_convert( trim(tmp_c(5:6)) )
     day_v(i)=c2i_convert( trim(tmp_c(7:8)) )
     hour_v(i)=c2i_convert( trim(tmp_c(9:10)) )
  end do

  do i=1,nz
     z(i)=z_bot+dz*real(i-1)
  end do
  do i=1,nt/2
     freq(i)=86400.0*real(i-1)/real(period)
  end do

!-- fft 
!-- ǡǰʬ
  call prim_calc( nt, prim(1:4), prim(5) )
  write(*,*) "prime factor", prim(:)

!-- žη׻
  call rotate_array_f()
  call rotate_calc( nt/2, 'r', (/prim(1)-1,prim(2),prim(3),prim(4),prim(5)/),  &
  &                 omegar(1:prim(5),1:prim(5)),  &
  &                 omeganr(1:nt/2,1:nt/2) )  ! ¥ǡ FFT ʤΤ, ǡ 1/2 Ȥʤ. ȼ, prim_fact(1)  -1 Ȥʤ.

!-- time loop
!-- 1. reading values from text file
!-- 2. interpolating to grid point
!-- 3. calculating each value

  do i=1,nt
     nttmp=line_number_counter( trim(fname(1,i)) ) -2
     allocate(val_w(col_num,nttmp))
     allocate(val_f(col_num,nttmp))
     call read_file_text( trim(fname(1,i)), col_num, nttmp, val_w,  &
  &                       skip=skip_num )

  !-- convert type from character to float
     do k=1,nttmp
        do j=1,col_num
           val_f(j,k)=c2r_convert( val_w(j,k) )
        end do
     end do

  !-- calculating the interpolating points
     do k=1,nz
        call interpo_search_1d( val_f(1,:), z(k), inter_z(k), undeff=int(undef) )
     end do

  !-- calculating each value (temp, u, v, rh)
     do k=1,nz
        do j=2,col_num
           if(inter_z(k)/=int(undef).and.inter_z(k)/=nttmp)then
              if(val_f(j,inter_z(k))==undef.or.  &
  &              val_f(j,inter_z(k)+1)==undef)then
                 val_inter(:,k)=undef
                 fflag(k)=.true.
                 exit
              end if

              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  val_f(j,inter_z(k):inter_z(k)+1),  &
  &                                  z(k), val_inter(j,k) )
           else
              val_inter(j,k)=undef
              fflag(k)=.true.
           end if
        end do
     end do

  !-- calculating each value (pt, ept, sept)
     do k=1,nz
        if(val_inter(2,k)==undef)then
           val_inter(col_num+1,k)=undef
           val_inter(col_num+2,k)=undef
           val_inter(col_num+3,k)=undef
           val_inter(col_num+4,k)=undef
           fflag(k)=.true.
        else
           pt_tmp(1)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
           ept_tmp(1)=thetae_Bolton( val_f(3,inter_z(k)),  &
  &                                  val_f(4,inter_z(k)),  &
  &                                  val_f(2,inter_z(k)) )
           sept_tmp(1)=thetaes_Bolton( val_f(3,inter_z(k)),  &
  &                                    val_f(2,inter_z(k)) )
           rh_tmp(1)=qvTP_2_RH( val_f(4,inter_z(k)),  &
  &                             val_f(3,inter_z(k)),  &
  &                             val_f(2,inter_z(k)) )
           pt_tmp(2)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
           ept_tmp(2)=thetae_Bolton( val_f(3,inter_z(k)+1),  &
  &                                  val_f(4,inter_z(k)+1),  &
  &                                  val_f(2,inter_z(k)+1) )
           sept_tmp(2)=thetaes_Bolton( val_f(3,inter_z(k)+1),  &
  &                                    val_f(2,inter_z(k)+1) )
           rh_tmp(2)=qvTP_2_RH( val_f(4,inter_z(k)+1),  &
  &                             val_f(3,inter_z(k)+1),  &
  &                             val_f(2,inter_z(k)+1) )

           call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                               pt_tmp, z(k), val_inter(col_num+1,k) )
           call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                               ept_tmp, z(k), val_inter(col_num+2,k) )
           call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                               sept_tmp, z(k), val_inter(col_num+3,k) )
           call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                               rh_tmp, z(k), val_inter(col_num+4,k) )

        end if
     end do

     deallocate(val_w)
     deallocate(val_f)

     do j=1,col_num+4
        do k=1,nz
           val_tmp(j,i,k)=val_inter(j,k)
        end do
     end do

  end do

!-- ֥ǡ򥹥ڥȥǡѴ.

  do k=1,nz
     if(fflag(k).eqv..false.)then
        do j=1,col_num+4
           call r2c_ffttp_1d( nt, val_tmp(k,j,1:nt), val_fft(1:nt/2),  &
  &                           prim='x', prim_fact=prim,  &
  &                           omega_fix=omegar, omegan_fix=omeganr )
           do i=1,nt/2
              val_draw(j,i,k)=abs(val_fft(i))
           end do
        end do
     else
        do j=1,col_num+4
           do i=1,nt/2
              val_draw(j,i,k)=undef
           end do
        end do
     end if
  end do

!-- draw value separate
!--  val_inter ȤƤ.(ޤ̤)

  select case (cont_val)
  case ('temp')
     cont_flag=3
  case ('qv')
     cont_flag=4
  case ('pt')
     cont_flag=col_num+1
  case ('ept')
     cont_flag=col_num+2
  case ('sept')
     cont_flag=col_num+3
  case ('rh')
     cont_flag=col_num+4
  case ('east')
     cont_flag=5
  case ('north')
     cont_flag=6
  end select

  select case (shade_val)
  case ('temp')
     shade_flag=3
  case ('qv')
     shade_flag=4
  case ('pt')
     shade_flag=col_num+1
  case ('ept')
     shade_flag=col_num+2
  case ('sept')
     shade_flag=col_num+3
  case ('rh')
     shade_flag=col_num+4
  case ('east')
     shade_flag=5
  case ('north')
     shade_flag=6
  end select

!-- DCL part
!-- ޤ, -
  call color_setting( snum, s_int, col_min=15, col_max=85,  &
  &                   min_tab=10999, max_tab=99999 )

  call DclOpenGraphics(IWS)

  if(len_trim(adjustl(sysfont))/=0)then
!     CALL SWSLFT(sysfont)
     CALL SWCSET('FONTNAME', sysfont)
  end if

  if(mean_flag.eqv..true.)then
     call Dcl_2D_Cont_Shade( trim(title_txt),  &
  &       freq, z,  &
  &       val_draw(cont_flag,:,:), val_draw(shade_flag,:,:),  &
  &       c_int, s_int,  &
  &       (/'Frequency (1/day)', 'altitude (m)'/),  &
  &       (/'(f6.1)', '(f6.1)'/),  &
  &       c_num=(/cnum, snum/), trigleg='a' )
  else
     call Dcl_2D_Cont_Shade( trim(title_txt),  &
  &       freq(2:nt/2), z,  &
  &       val_draw(cont_flag,2:nt/2,:), val_draw(shade_flag,2:nt/2,:),  &
  &       c_int, s_int,  &
  &       (/'Frequency (1/day)', 'altitude (m)'/),  &
  &       (/'(f6.1)', '(f6.1)'/),  &
  &       c_num=(/cnum, snum/), trigleg='a' )
  end if

  call DclCloseGraphics

end program
