module time_scheme
! ֥ऴȤ˷׻Ԥ⥸塼
! force_solv Ƿ׻ͤ򥹥˹碌Ƴ꿶,
! ֥ƥåפȯŸ.
  use Derivation
  use Ellip_Slv
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_init
  use val_coord
  use real_initialize
  use sub_calc
  use force_solv
  use HEVI_mod
  use Cloud_Basic

contains

subroutine time_schematic( step, mode )

  implicit none
  integer, intent(in) :: step  ! ॹƥåֹ
  character(1), intent(in) :: mode  ! time splitting mode : 's' = small, 'b' = large
  integer :: ct, i, j, k
  real :: dt, pres

  if(mode(1:1)=='s')then
     dt=dts
  else if(mode(1:1)=='b')then
     dt=dtb
  end if

  if(mode(1:1)=='b')then
     select case (time_flag(1:1))
     case ('1')  ! RK4 

     !-- ѿι
        do j=1,nz+1
           do i=1,nr+1
              u_tmp(i,j)=u_new(i,j)
              v_tmp(i,j)=v_new(i,j)
              w_tmp(i,j)=w_new(i,j)
              p_tmp(i,j)=p_new(i,j)
              t_tmp(i,j)=t_new(i,j)
              qv_tmp(i,j)=qv_new(i,j)
              qc_tmp(i,j)=qc_new(i,j)
              ql_tmp(i,j)=ql_new(i,j)
              u_old(i,j)=u_new(i,j)
              v_old(i,j)=v_new(i,j)
              w_old(i,j)=w_new(i,j)
              p_old(i,j)=p_new(i,j)
              t_old(i,j)=t_new(i,j)
              qv_old(i,j)=qv_new(i,j)
              qc_old(i,j)=qc_new(i,j)
              ql_old(i,j)=ql_new(i,j)
           end do
        end do

     !-- RK4 ΤȤΤѤѿν force_solv ȤΩ RK4 ΤȤΤư.

        call real_init( forcea_v )
        call real_init( forcea_t )
        call real_init( forcea_qv )
        call real_init( forcea_qc )
        call real_init( forcea_ql )

        do ct=1,4  ! RK4 η򤽤줾׻

        !-- ׻.

           call force( mode )

!--  ʬ (RK4 ˡ)
           select case (ct)
           case (1)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
              do j=1,nz
                 do i=1,nr
                    forcea_v(i,j)=forcea_v(i,j)+force_v(i,j)
                    forcea_t(i,j)=forcea_t(i,j)+force_t(i,j)
                    forcea_qv(i,j)=forcea_qv(i,j)+force_qv(i,j)
                    forcea_qc(i,j)=forcea_qc(i,j)+force_qc(i,j)
                    forcea_ql(i,j)=forcea_ql(i,j)+force_ql(i,j)

                    v_old(i,j)=v_tmp(i,j)+(0.5*dt)*force_v(i,j)
                    t_old(i,j)=t_tmp(i,j)+(0.5*dt)*force_t(i,j)
                    qv_old(i,j)=qv_tmp(i,j)+(0.5*dt)*force_qv(i,j)
                    qc_old(i,j)=qc_tmp(i,j)+(0.5*dt)*force_qc(i,j)
                    ql_old(i,j)=ql_tmp(i,j)+(0.5*dt)*force_ql(i,j)
                    pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                    if(qv_old(i,j)<0.0)then
                       qv_old(i,j)=0.0
                    end if
                    if(qc_old(i,j)<0.0)then
                       qc_old(i,j)=0.0
                    end if
                    call Moist_Sature_Adjust( pres, t_old(i,j),  &
                            qv_old(i,j), qc_old(i,j), ln=3 )
                 end do
              end do
!$omp end do
!$omp end parallel

              call set_zero( qv_old )
              call set_zero( qc_old )
              call set_zero( ql_old )

           case (2)                         

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
              do j=1,nz
                 do i=1,nr
                    forcea_v(i,j)=forcea_v(i,j)+2.0*force_v(i,j)
                    forcea_t(i,j)=forcea_t(i,j)+2.0*force_t(i,j)
                    forcea_qv(i,j)=forcea_qv(i,j)+2.0*force_qv(i,j)
                    forcea_qc(i,j)=forcea_qc(i,j)+2.0*force_qc(i,j)
                    forcea_ql(i,j)=forcea_ql(i,j)+2.0*force_ql(i,j)

                    v_old(i,j)=v_tmp(i,j)+(0.5*dt)*force_v(i,j)
                    t_old(i,j)=t_tmp(i,j)+(0.5*dt)*force_t(i,j)
                    qv_old(i,j)=qv_tmp(i,j)+(0.5*dt)*force_qv(i,j)
                    qc_old(i,j)=qc_tmp(i,j)+(0.5*dt)*force_qc(i,j)
                    ql_old(i,j)=ql_tmp(i,j)+(0.5*dt)*force_ql(i,j)
                    pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                    if(qv_old(i,j)<0.0)then
                       qv_old(i,j)=0.0
                    end if
                    if(qc_old(i,j)<0.0)then
                       qc_old(i,j)=0.0
                    end if
                    call Moist_Sature_Adjust( pres, t_old(i,j),  &
                            qv_old(i,j), qc_old(i,j), ln=3 )
                 end do
              end do
!$omp end do
!$omp end parallel

              call set_zero( qv_old )
              call set_zero( qc_old )
              call set_zero( ql_old )

           case (3)                         

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
              do j=1,nz
                 do i=1,nr
                    forcea_v(i,j)=forcea_v(i,j)+2.0*force_v(i,j)
                    forcea_t(i,j)=forcea_t(i,j)+2.0*force_t(i,j)
                    forcea_qv(i,j)=forcea_qv(i,j)+2.0*force_qv(i,j)
                    forcea_qc(i,j)=forcea_qc(i,j)+2.0*force_qc(i,j)
                    forcea_ql(i,j)=forcea_ql(i,j)+2.0*force_ql(i,j)

                    v_old(i,j)=v_tmp(i,j)+(dt)*force_v(i,j)
                    t_old(i,j)=t_tmp(i,j)+(dt)*force_t(i,j)
                    qv_old(i,j)=qv_tmp(i,j)+(dt)*force_qv(i,j)
                    qc_old(i,j)=qc_tmp(i,j)+(dt)*force_qc(i,j)
                    ql_old(i,j)=ql_tmp(i,j)+(dt)*force_ql(i,j)
                    pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                    if(qv_old(i,j)<0.0)then
                       qv_old(i,j)=0.0
                    end if
                    if(qc_old(i,j)<0.0)then
                       qc_old(i,j)=0.0
                    end if
                    call Moist_Sature_Adjust( pres, t_old(i,j),  &
                            qv_old(i,j), qc_old(i,j), ln=3 )
                 end do
              end do
!$omp end do
!$omp end parallel

              call set_zero( qv_old )
              call set_zero( qc_old )
              call set_zero( ql_old )

           case (4)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
              do j=1,nz
                 do i=1,nr
                    forcea_v(i,j)=forcea_v(i,j)+force_v(i,j)
                    forcea_t(i,j)=forcea_t(i,j)+force_t(i,j)
                    forcea_qv(i,j)=forcea_qv(i,j)+force_qv(i,j)
                    forcea_qc(i,j)=forcea_qc(i,j)+force_qc(i,j)
                    forcea_ql(i,j)=forcea_ql(i,j)+force_ql(i,j)

                    v_new(i,j)=v_tmp(i,j)+(dt/6.0)*forcea_v(i,j)
                    t_new(i,j)=t_tmp(i,j)+(dt/6.0)*forcea_t(i,j)
                    qv_new(i,j)=qv_tmp(i,j)+(dt/6.0)*forcea_qv(i,j)
                    qc_new(i,j)=qc_tmp(i,j)+(dt/6.0)*forcea_qc(i,j)
                    ql_new(i,j)=ql_tmp(i,j)+(dt/6.0)*forcea_ql(i,j)
                    pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                    if(qv_new(i,j)<0.0)then
                       qv_new(i,j)=0.0
                    end if
                    if(qc_new(i,j)<0.0)then
                       qc_new(i,j)=0.0
                    end if
                    call Moist_Sature_Adjust( pres, t_new(i,j),  &
                            qv_new(i,j), qc_new(i,j), ln=3 )
                 end do
              end do
!$omp end do
!$omp end parallel

              call set_zero( qv_new )
              call set_zero( qc_new )
              call set_zero( ql_new )

           end select

        end do

     case ('2')  ! Leap Frog 

        if(step==1)then
           do j=1,nz+1
              do i=1,nr+1
                 u_tmp(i,j)=u_new(i,j)  ! old ()  tmp (1 ƥå) .
                 v_tmp(i,j)=v_new(i,j)  ! old ()  tmp (1 ƥå) .
                 w_tmp(i,j)=w_new(i,j)  ! old ()  tmp (1 ƥå) .
                 p_tmp(i,j)=p_new(i,j)  ! old ()  tmp (1 ƥå) .
                 t_tmp(i,j)=t_new(i,j)  ! old ()  tmp (1 ƥå) .
                 qv_tmp(i,j)=qv_new(i,j)  ! old ()  tmp (1 ƥå) .
                 qc_tmp(i,j)=qc_new(i,j)  ! old ()  tmp (1 ƥå) .
                 ql_tmp(i,j)=ql_new(i,j)  ! old ()  tmp (1 ƥå) .
                 u_old(i,j)=u_new(i,j)  ! new (1 ƥå)  old () .
                 v_old(i,j)=v_new(i,j)  ! new (1 ƥå)  old () .
                 w_old(i,j)=w_new(i,j)  ! new (1 ƥå)  old () .
                 p_old(i,j)=p_new(i,j)  ! new (1 ƥå)  old () .
                 t_old(i,j)=t_new(i,j)  ! new (1 ƥå)  old () .
                 qv_old(i,j)=qv_new(i,j)  ! new (1 ƥå)  old () .
                 qc_old(i,j)=qc_new(i,j)  ! new (1 ƥå)  old () .
                 ql_old(i,j)=ql_new(i,j)  ! new (1 ƥå)  old () .
              end do
           end do
        else
           do j=1,nz+1
              do i=1,nr+1
                 u_tmp(i,j)=u_old(i,j)  ! old ()  tmp (1 ƥå) .
                 v_tmp(i,j)=v_old(i,j)  ! old ()  tmp (1 ƥå) .
                 w_tmp(i,j)=w_old(i,j)  ! old ()  tmp (1 ƥå) .
                 p_tmp(i,j)=p_old(i,j)  ! old ()  tmp (1 ƥå) .
                 t_tmp(i,j)=t_old(i,j)  ! old ()  tmp (1 ƥå) .
                 qv_tmp(i,j)=qv_old(i,j)  ! old ()  tmp (1 ƥå) .
                 qc_tmp(i,j)=qc_old(i,j)  ! old ()  tmp (1 ƥå) .
                 ql_tmp(i,j)=ql_old(i,j)  ! old ()  tmp (1 ƥå) .
                 u_old(i,j)=u_new(i,j)  ! new (1 ƥå)  old () .
                 v_old(i,j)=v_new(i,j)  ! new (1 ƥå)  old () .
                 w_old(i,j)=w_new(i,j)  ! new (1 ƥå)  old () .
                 p_old(i,j)=p_new(i,j)  ! new (1 ƥå)  old () .
                 t_old(i,j)=t_new(i,j)  ! new (1 ƥå)  old () .
                 qv_old(i,j)=qv_new(i,j)  ! new (1 ƥå)  old () .
                 qc_old(i,j)=qc_new(i,j)  ! new (1 ƥå)  old () .
                 ql_old(i,j)=ql_new(i,j)  ! new (1 ƥå)  old () .
              end do
           end do
        end if

     !-- ׻.

        call force( mode )

        if(step==1)then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
           do j=1,nz
              do i=1,nr
                 v_new(i,j)=v_old(i,j)+dt*force_v(i,j)
                 t_new(i,j)=t_old(i,j)+dt*force_t(i,j)
                 qv_new(i,j)=qv_old(i,j)+dt*force_qv(i,j)
                 qc_new(i,j)=qc_old(i,j)+dt*force_qc(i,j)
                 ql_new(i,j)=ql_old(i,j)+dt*force_ql(i,j)
                 pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                 if(qv_new(i,j)<0.0)then
                    qv_new(i,j)=0.0
                 end if
                 if(qc_new(i,j)<0.0)then
                    qc_new(i,j)=0.0
                 end if
                 call Moist_Sature_Adjust( pres, t_new(i,j),  &
                         qv_new(i,j), qc_new(i,j), ln=3 )
              end do
           end do
!$omp end do
!$omp end parallel

           call set_zero( qv_new )
           call set_zero( qc_new )
           call set_zero( ql_new )

        else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i,pres)
           do j=1,nz
              do i=1,nr
                 v_new(i,j)=v_tmp(i,j)+2.0*dt*force_v(i,j)
                 t_new(i,j)=t_tmp(i,j)+2.0*dt*force_t(i,j)
                 qv_new(i,j)=qv_tmp(i,j)+2.0*dt*force_qv(i,j)
                 qc_new(i,j)=qc_tmp(i,j)+2.0*dt*force_qc(i,j)
                 ql_new(i,j)=ql_tmp(i,j)+2.0*dt*force_ql(i,j)
                 pres=p0*((p_old(i,j)+pb_s(i,j))**(Cpd/Rd))

                 if(qv_new(i,j)<0.0)then
                    qv_new(i,j)=0.0
                 end if
                 if(qc_new(i,j)<0.0)then
                    qc_new(i,j)=0.0
                 end if
                 call Moist_Sature_Adjust( pres, t_new(i,j),  &
                         qv_new(i,j), qc_new(i,j), ln=3 )
              end do
           end do
!$omp end do
!$omp end parallel

           call set_zero( qv_new )
           call set_zero( qc_new )
           call set_zero( ql_new )

        end if

     case default

        write(*,*) "*** ERROR (main) *** : time flag must be 1 or 2."
        write(*,*) "Now, You set time flag as '", time_flag(1:1), "'."
        write(*,*) "STOP"
        stop

     end select

  else if(mode(1:1)=='s')then   ! Crank-Nicolson (For small time)

     if(step==1)then

     !-- ѿι
        do j=1,nz+1
           do i=1,nr+1
              u_old(i,j)=u_new(i,j)
              v_old(i,j)=v_new(i,j)
              w_old(i,j)=w_new(i,j)
              p_old(i,j)=p_new(i,j)
              t_old(i,j)=t_new(i,j)
              qv_old(i,j)=qv_new(i,j)
              qc_old(i,j)=qc_new(i,j)
              ql_old(i,j)=ql_new(i,j)
           end do
        end do

        call force( mode )    ! calculating each term except for acoustic.

     else

     !-- ѿι
        do j=1,nz+1
           do i=1,nr+1
              u_old(i,j)=u_new(i,j)
              w_old(i,j)=w_new(i,j)
              p_old(i,j)=p_new(i,j)
           end do
        end do

     end if

     call HEVI()

  end if

end subroutine

end module
