!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module typhoon_analy  ! ټ¸ѥڥϥ⥸塼

  use Statistics

  implicit none

!  private :: search_region_1d  ! ʿѤǽȾ¤ܺ.

contains

subroutine tangent_conv_scal( x, y, xc, yc, u, r, theta, v, undef,  &
  &                           undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  use Map_Function
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt, i_undef
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  character(1) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf, stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.
  i_undef=0

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---
!-- ϹԤʤ.

!  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr,  &
!  &                      stdopt=stderr, axis=ax_flag(1:2) )

!--  v  undef ͤƤ.
!  do j=1,nt
!     do i=1,nrr
!        v(i,j)=r_undef
!     end do
!  end do

!-- (1) ---
  if(ax_flag(1:2)=='xy')then
     do j=1,nt
        do i=1,nr
           call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
           point(i,j,1)=xc+point(i,j,1)
           point(i,j,2)=yc+point(i,j,2)
        end do
     end do
  else
     do j=1,nt
        do i=1,nr
           if(r(i)/=0.0)then
              call rt2ll( r(i), theta(j), xc, yc, point(i,j,1), point(i,j,2) )
           else
              point(i,j,1)=xc
              point(i,j,2)=yc
           end if
        end do
     end do
  end if

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2), undeff=i_undef,  &
  &                             stdopt=stderr )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        if(ip(i,j,1)/=i_undef.and.ip(i,j,2)/=i_undef.and.  &
  &        ip(i,j,1)/=nx.and.ip(i,j,2)/=ny)then
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)

           if(present(undefg))then
              ucf=undef_checker_2d( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
              else
                 work(i,j)=r_undefg
                 undefgc_check(i)=.false.
              end if
           else
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           end if
        else
           work(i,j)=r_undef
        end if
     end do
  end do

  do j=1,nt
     do i=1,nr
        v(i,j)=work(i,j)
     end do
  end do

end subroutine tangent_conv_scal

!--------------------------------------------------------------
!--------------------------------------------------------------
subroutine tangent_mean_scal( x, y, xc, yc, u, r, theta, v, undef,  &
  &                           undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef   ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, nx, ny, nr, nt
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3)

  call tangent_conv_scal( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                       undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                       stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Mean_1d( work(i,:), v(i), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Mean_1d( work(i,:), v(i) )
           else
              v(i)=undefg
           end if
        end do
     end if
  else
     do i=1,nr
        call Mean_1d( work(i,:), v(i) )
     end do
  end if

end subroutine tangent_mean_scal

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal( x, y, xc, yc, u, r, theta, v, undef,  &
  &                                undefg, undefgc, stdopt, axis )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt к׻ Anomaly_1d .
  ! ʾǳ nr ˤĤкͤ.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: y(:)  ! ɸϤǤʬ [m or rad]
  real, intent(in) :: u(size(x),size(y))  ! ɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ. [m or rad]
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ. [m or rad]
  real, intent(in) :: r(:)  ! (xc, yc) 濴Ȥ˺ɸưºɸ [m].
  real, intent(in) :: theta(:)  ! (xc, yc) 濴Ȥ˺ɸƱ̳Ѻɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: i, j, nx, ny, nr, nt
  real :: r_undef, r_undefg
  real :: work(size(r),size(theta))
  character(3) :: undefgcflag
  character(2) :: ax_flag
  logical, dimension(size(r)) :: undefgc_check
  logical :: stderr

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undef))then
    r_undef=undef
  else
    r_undef=-999.0
  end if

  if(present(undefg))then
    r_undefg=undefg
  else
    r_undefg=-999.0
  end if

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(axis))then
     ax_flag=axis(1:2)
  else
     ax_flag='xy'
  end if

!-- (1) - (3) ---

  call tangent_conv_scal( x, y, xc, yc, u, r, theta, work, undef=r_undef,  &
  &                       undefg=r_undefg, undefgc=undefgcflag(1:3),  &
  &                       stdopt=stderr, axis=ax_flag(1:2) )

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=1,nr
           call Anomaly_1d( work(i,:), v(i,:), error=undefg )
        end do
     else
        do i=1,nr
           if(undefgc_check(i).eqv..true.)then
              call Anomaly_1d( work(i,:), v(i,:) )
           else
              do j=1,nt
                 v(i,j)=undefg
              end do
           end if
        end do
     end if
  else
     do i=1,nr
        call Anomaly_1d( work(i,:), v(i,:) )
     end do
  end if

end subroutine tangent_mean_anom_scal

!--------------------------------------------------------------
!--------------------------------------------------------------
subroutine tangent_mean_anom_scal_Cart( x, y, xc, yc, scal, r, theta,  &
  &                                     scal_anom, undef, undefg, undefgc,  &
  &                                     stdopt, axis )
  ! 濴Υޥ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ε᤿ͤ򸵤ΥǥȥǡȤǥΥޥȤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use statistics
  use map_function
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ [m] or lon [rad]
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ [m] or lat [rad]
  real, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ [m] or [rad].
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ [m] or [rad].
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: scal_anom(size(x),size(y))  ! ǥȷϤǤΥΥޥ.
  real, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  character(2), intent(in), optional :: axis  ! x, y κɸ
                                           ! 'xy' = ǥȺɸ [m]
                                           ! 'll' = ̰ٷٺɸ [rad]
                                           ! ǥեȤ 'xy'.
  integer :: j, k, nx, ny, nr, nt, itmpr
  real :: tmp(size(r))
  real :: tmpr, tmp_anom, undeff
  character(2) :: ax
  character(3) :: undefgcflag
  logical :: stderr

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(axis))then
     ax(1:2)=axis(1:2)
  else
     ax='xy'
  end if

  if(present(undefg))then
     call tangent_mean_scal( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3),  &
  &                    stdopt=stderr, axis=ax )
  else
     call tangent_mean_scal( x, y, xc, yc, scal, r, theta, tmp, undef=undeff,  &
  &                          stdopt=stderr, axis=ax )
  end if

!-- ʿͤޤ, ͤƥΥޥ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              if(ax(1:2)=='xy')then  ! Cart.
                 tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              else  ! lon-lat
                 tmpr=ll2radi( xc, yc, x(j), y(k) )
              end if
              call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           if(ax(1:2)=='xy')then  ! Cart.
              tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
           else  ! lon-lat
              tmpr=ll2radi( xc, yc, x(j), y(k) )
           end if
           call interpo_search_1d( r, tmpr, itmpr, stdopt=stderr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_anom(j,k)=scal(j,k)-tmp_anom
           else
              scal_anom(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_anom_scal_Cart

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_vec( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                          undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r.
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, z_count
  real, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0)then
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                             undef=undef, undefg=undefg,  &
  &                             undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                             undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                          undefg=undefg, undefgc=trim(undefgc),  &
  &                          stdopt=stderr )
  else
     call tangent_mean_scal( x, y, xc, yc, vecz, r, theta, v, stdopt=stderr )
  end if

end subroutine tangent_mean_vec

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_vec( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                               undef, undefg, undefgc, stdopt )
  ! Ǥդʪ̤濴ʿѥΥޥ׻롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod_2d ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  ! ʤ, ܥ롼ϲΤ, β tangent_mean_scal 롼
  ! ꤲƤ. ܥ롼ǹԤΤ, charc ˹碌,
  ! ƥǥȺɸˤ濴Ф, ư׻ΤߤǤ.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! Υޥ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: i, j, nx, ny, z_count
  real, dimension(size(x),size(y)) :: posx, posy, abpos, vecz
  logical :: stderr

  nx=size(x)
  ny=size(y)
  z_count=0

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ޤ, charc ˹碌, ʿ٥ȥư¡Ѵ.
!-- Ѵ, ͤϥ顼ͤȤɾΤ,
!-- tangent_mean_scal ꤲ.

!-- 濴ФƥǥȺɸοʿ֥٥ȥ׻.

  do j=1,ny
     do i=1,nx
        posx(i,j)=x(i)-xc
        posy(i,j)=y(j)-yc
     end do
  end do

  select case (trim(charc))
  case ('vector')
     if(present(undefg))then
        call vec_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call vec_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case ('scalar')
     if(present(undefg))then
        call dot_prod_2d( posx, posy, u1, u2, vecz, undeff=undefg )
     else
        call dot_prod_2d( posx, posy, u1, u2, vecz )
     end if
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

  call abst_2d( posx, posy, abpos )

  if(present(undefg))then
     do j=1,ny
        do i=1,nx   
           if(vecz(i,j)/=undefg.and.abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else if(abpos(i,j)==0.0)then
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           if(abpos(i,j)/=0.0)then
              vecz(i,j)=vecz(i,j)/abpos(i,j)
           else
              z_count=z_count+1
              vecz(i,j)=0.0
           end if
        end do
     end do
  end if

  if(present(undef))then
     if(present(undefg))then
        call tangent_mean_anom_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                                  undef=undef, undefg=undefg,  &
  &                                  undefgc=trim(undefgc), stdopt=stderr )
     else
        call tangent_mean_anom_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                                  undef=undef, stdopt=stderr )
     end if
  else if(present(undefg))then
     call tangent_mean_anom_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                               undefg=undefg, undefgc=trim(undefgc),  &
  &                               stdopt=stderr )
  else
     call tangent_mean_anom_scal( x, y, xc, yc, vecz, r, theta, v,  &
  &                               stdopt=stderr )
  end if

end subroutine tangent_mean_anom_vec

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_turb( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
!  ʿѤήեå׻.
!  ʿѤƤΤ, tau_{*2} ʬ (\theta ʬʬ) ϴޤޤʤ.
  use algebra
  use Derivation
  implicit none
  character(1) :: signal  ! ɸϤβܤήʬȽꤹ.
                  ! [1] = ɸˤ radial ɸʬ ( vr ʬ)
                  ! [2] = ɸˤ tangential ɸʬ ( vt ʬ)
                  ! [3] = ɸˤ vertical ɸʬ ( w ʬ)
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  real, intent(in) :: z(:)  ! ľΰֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! y б 2 >ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: id   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]
  character(1) :: signaltau(3)
  real, dimension(size(r),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  real, dimension(size(r),size(z)) :: tmp
  real, dimension(size(r)) :: stau

  signaltau=(/ '1', '2', '3' /)

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z) 

  val=0.0

  do id=1,3
     if(id/=2)then  ! tau_{*2} ʬϥʤΤ, ׻ʤ.
        if(present(sfctau))then
           stau(:)=sfctau(:)
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id), sfctau=stau )
        else
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id) )
        end if
     end if
  end do

!-- (signal, 1) ʬη׻
  do k=1,nz
     call grad_1d( r, tau(:,k,1), tmp(:,k))
     do i=1,nr
        if(r(i)/=0.0)then
           val(i,k)=tmp(i,k)+val(i,k)+tau(i,k,1)/r(i)
        else
           val(i,k)=tmp(i,k)+val(i,k)
        end if
     end do
  end do

!-- (signal, 3) ʬη׻
  do i=1,nr
     call grad_1d( z, tau(i,:,3), tmp(i,:))
     do k=1,nz
        val(i,k)=tmp(i,k)+val(i,k)
     end do
  end do



end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_Reynolds( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
! ɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  use algebra
  use Derivation
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 3 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]
  real :: sxx(size(r),size(z)), nu(size(r),size(z))
  real :: stau(size(r))

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

  val=0.0
  stau=0.0

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:)=sfctau(:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='11')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='22')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

  if(signal(1:2)=='33')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

!-- ʲμ, ǽ val = 0  if ʸǷ׻ƤΤȤƤʤ
!-- ΤʬΤ, μɾǤ.
!-- ׻ƤʤΤˤĤƤϤ⤽⥼Ǥ.

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do i=1,nr
        val(i,1)=stau(i)
     end do
  else
     do i=1,nr
        val(i,1)=rho(1)*nu(i,1)*(sxx(i,1)-(2.0/3.0)*val(i,1))
     end do
  end if

  do k=2,nz
     do i=1,nr
        val(i,k)=rho(k)*nu(i,k)*(sxx(i,k)-(2.0/3.0)*val(i,k))
     end do
  end do

end subroutine


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_deform( signal, r, z, u, v, w, val, undef )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  use algebra
  use Derivation
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     do k=1,nz
        call grad_1d( r, v(:,k), val(:,k) )
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)-v(i,k)/r(i)
           end if
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nr
        call grad_1d( z, v(k,:), val(k,:) )
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call div( r, z, w, u, val )
  end if

  if(signal(1:2)=='11')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call grad_1d( r, u(:,k), val(:,k) )
        val(:,k)=2.0*val(:,k)
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='22')then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
     do k=1,nz
        do j=1,nr
           if(r(j)/=0.0)then
              val(j,k)=2.0*u(j,k)/r(j)
           else
              val(j,k)=0.0
           end if
        end do
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='33')then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)
     do j=1,nr
        call grad_1d( z, w(j,:), val(j,:) )
        val(j,:)=2.0*val(j,:)
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine hydro_grad_eqb( r, z, coril, v, pres_s, rho_s, pres, rho, error, dl )
!  ǥ󥰤ȼоήϳءʿվη׻.
  use Thermo_Const
  use Phys_Const
  use algebra
  use stdio
  use Derivation
  implicit none
  real, intent(in) :: r(:)  ! ưºɸ [m]
  real, intent(in) :: z(:)  ! ľɸ [m]
  real, intent(in) :: coril(size(r),size(z))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r),size(z))  ! оή [m/s]
  real, intent(in) :: pres_s(size(z))  ! ǥ󥰤ε [Pa]
  real, intent(in) :: rho_s(size(z))  ! ǥ󥰤̩ [kg/m^3]
  real, intent(in), optional :: error  ! 졼μ«
                    ! default = 1.0e-5
  real, intent(inout) :: pres(size(r),size(z))  ! ʿվε [Pa]
  real, intent(inout) :: rho(size(r),size(z))  ! ʿվ̩ [kg/m^3]
  integer, intent(in), optional :: dl  ! ǥХå٥
  real :: dr(size(r)), dz(size(z))
  real :: old_pres(size(r),size(z)), old_rho(size(r),size(z))
  real :: N2(size(r),size(z)), tmprho(size(r),size(z)), force(size(r),size(z))
  integer :: nr, nz
  integer :: i, j
  real :: err, err_tmp, err_max, tmpp, tmpc, tmpr

  nr=size(r)
  nz=size(z)

  if(present(error))then
     err_max=error
  else
     err_max=1.0e-5
  end if

!-- ʲǳƹ٤ˤ, ̩٤ϰǤȤƷʿդ鵤׻,
!-- ͤѤϳʿդ̩٤. eps ʲˤʤޤǷ֤.
!--  2 ȥǥ󥰤.
  do j=1,nz
     do i=1,nr
        old_pres(i,j)=pres_s(j)
     end do
  end do
!-- ̩٤ˤĤƤ, ʿ̰ͤ
  do j=1,nz
     do i=1,nr
        old_rho(i,j)=log(rho_s(j))
     end do
  end do

  do i=1,nr-1
     dr(i)=r(i+1)-r(i)
  end do
  do j=1,nz-1
     dz(j)=z(j+1)-z(j)
  end do

!-- ʲǥ졼󳫻.
  err=err_max

  do while(err>=err_max)
     err=0.0

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              force(i,j)=coril(i,j)*v(i,j)+v(i,j)*v(i,j)/r(i)
           else
              force(i,j)=0.0
           end if
        end do
     end do

!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,tmpp,tmpc,tmpr)

     do j=1,nz-1
        do i=1,nr-1
           tmpp=old_pres(i+1,j)*dz(j)+force(i,j)*dr(i)*old_pres(i,j+1)/g
           tmpc=dz(j)+dr(i)*force(i,j)/g
           tmpr=old_rho(i+1,j)*dz(j)+force(i,j)*dr(i)*old_rho(i,j+1)/g  &
  &             +(force(i,j+1)-force(i,j))*dr(i)/g
           pres(i,j)=tmpp/tmpc
           tmprho(i,j)=tmpr/tmpc
        end do
     end do

!$omp end do
!$omp end parallel

!-- ͤ
     do i=1,nr
        pres(i,nz)=pres_s(nz)
        tmprho(i,nz)=log(rho_s(nz))
     end do
     do j=1,nz
        pres(nr,j)=pres_s(j)
        tmprho(nr,j)=log(rho_s(j))
     end do

!-- ̩پμ«׻
     do j=1,nz
        do i=1,nr
           if(tmprho(i,j)==0.0)then
              err_tmp=abs(exp(old_rho(i,j))-exp(tmprho(i,j)))/abs(exp(old_rho(i,j)))
           else
              err_tmp=abs(exp(old_rho(i,j))-exp(tmprho(i,j)))/abs(exp(tmprho(i,j)))
           end if

!-- ι
           if(err<=err_tmp)then
              err=err_tmp
           end if

           old_rho(i,j)=tmprho(i,j)
           old_pres(i,j)=pres(i,j)

        end do
     end do

  end do

  do j=1,nz
     do i=1,nr
        rho(i,j)=exp(tmprho(i,j))
     end do
  end do

  if(present(dl))then
     do j=1,nz
        call debug_flag_r( dl, 'typhoon_analy', 'hydro_grad_eqb (pres)',  &
  &                        pres(1,j), 'Pa' )
     end do
  end if

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine grad_wind_pres( r, coril, v, rho, r_ref, p_ref, pres )
!  ʿվ׻.
  use Algebra
  implicit none
  real, intent(in) :: r(:)  ! r ΰֺɸ [m]
  real, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r))  ! r ΰֺɸ [m]
  real, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  real, intent(in) :: r_ref  ! ʬȤʤֺɸ [m]
  real, intent(in) :: p_ref  ! r_ref Ǥε (ʬ) [Pa]
  real, intent(inout) :: pres(size(r))  ! ʿդǤε [Pa]
  integer :: i, nr
  real :: grad(size(r))

  nr=size(r)

  do i=1,nr
     if(r(i)/=0.0)then
        grad(i)=rho(i)*(v(i)*v(i)/r(i)+coril(i)*v(i))
     else
        grad(i)=0.0
     end if
  end do

  do i=1,nr
     if(r(i)<r_ref)then
        call rectangle_int( r, grad, r(i), r_ref, pres(i) )
        pres(i)=p_ref-pres(i)
     else if(r(i)>r_ref)then
        call rectangle_int( r, grad, r_ref, r(i), pres(i) )
        pres(i)=p_ref+pres(i)
     else
        pres(i)=p_ref
     end if
  end do

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine CPS_Hart( x, y, center, z300, z600, z900, mv, B, VTL, VTU )
! ȫ (2011; ŷ) ˴Ť, Hart (2003a) 㵤֥ѥ᡼
! γʬ׻.
! ׻ϰʲ.
! (1) ư () η : atan(mv(2)/mv(1))
! (2) 500 km ϰǤʿѲ.
!     ư (1)  rad ѴƤΤ, tangen_mean 롼
!     Ǥճ rad ΤߤʿѲԤ.
! (3) 500 km ϰǤκǾͤη׻.
!     (1) Ƥ rad 󤫤, 500 km ʱγʻҤ˴ؤƤ
!     undef ͿƤ, max_min ⥸塼Ѥ.
! [] : ͤȾꤷƷ׻ƤΤ,
!          ȾŬѤݤ,  B ͿФ褤.
!          ޤ, ܥ롼Ѥݤ p ɸϤǹԤ뤳ȤꤷƤ.

  use Statistics
  use Max_Min
  use Math_Const
  use Algebra

  implicit none

  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  real, intent(in) :: center(2)
                         ! 㵤濴ɸ [m].
                         ! 줾 x, y ʬκɸб.
  real, intent(in) :: z300(size(x),size(y))
                      ! 300 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: z600(size(x),size(y))
                      ! 600 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: z900(size(x),size(y))
                      ! 900 hPa ̤ǤΥݥƥ󥷥 [m]
  real, intent(in) :: mv(2)   ! ư®٤ x, y ʬ [m/s].
  real, intent(inout) :: B    ! ѥ᡼
  real, intent(inout) :: VTL  ! زٳ˹¤
  real, intent(inout) :: VTU  ! زٳ˹¤
  integer :: nx, ny, i, j, nr, nt
  integer :: irad, itmp
  real, parameter :: rcalc=500.0e3   ! ׻ϰ [m].
  real, parameter :: undef=-1.0e6
  real :: radt, dzmax3, dzmax6, dzmax9, dzmin3, dzmin6, dzmin9, rb, lb
  real, dimension(size(x),size(y)) :: thick, tmpz3, tmpz6, tmpz9
  real, allocatable, dimension(:) :: theta   !  [rad].
  real, allocatable, dimension(:) :: r       ! 濴εΥ [m].
  real, allocatable, dimension(:) :: tmpr, tmpl

  nx=size(x)
  ny=size(y)
  nr=nx

  allocate(r(nr))
  allocate(tmpr(nr))
  allocate(tmpl(nr))
  r=(/(((x(2)-x(1))*real(i-1)),i=1,nr)/)
  nt=int(2.0*pi*rcalc/(x(2)-x(1)))
  write(*,*) "*** MESSAGE (CPS_Hart:typhoon_analy) ***"
  write(*,*) "theta number is set of ", nt
  allocate(theta(nt))

  !-- (1) ưη׻
  if(mv(1)>=0.0.and.mv(2)>=0.0)then        ! ݸ
     if(mv(1)==0.0.and.mv(2)==0.0)then
        radt=0.0
     else if(mv(1)==0.0)then
        radt=0.5*pi
     else if(mv(2)==0.0)then
        radt=0.0
     else
        radt=atan(mv(2)/mv(1))
     end if
  else if(mv(1)<0.0.and.mv(2)>=0.0)then    ! ݸ
     radt=acos(mv(1)/sqrt(mv(1)**2+mv(2)**2))
  else if(mv(1)<0.0.and.mv(2)<0.0)then     ! 軰ݸ
     radt=pi+atan(abs(mv(2))/abs(mv(1)))
  else if(mv(1)>=0.0.and.mv(2)<0.0)then    ! ;ݸ
     radt=asin(mv(2)/sqrt(mv(1)**2+mv(2)**2))
  end if

  if(0.0>radt)then
     radt=radt+2.0*pi
  else if(2.0*pi<radt)then
     radt=radt-2.0*pi
  end if

  theta=(/((radt+2.0*pi*real(i-1)/real(nt)),i=1,nt)/)

  call interpo_search_1d( r, rcalc, irad )

  !-- 500 km ʱ undef .
  thick=undef
  tmpz3=undef
  tmpz6=undef
  tmpz9=undef

  do j=1,ny
     do i=1,nx
        if(sqrt((x(i)-center(1))**2+(y(j)-center(2))**2)<=rcalc)then
           thick(i,j)=z600(i,j)-z900(i,j)
           tmpz3(i,j)=z300(i,j)
           tmpz6(i,j)=z600(i,j)
           tmpz9(i,j)=z900(i,j)
        end if
     end do
  end do

  !-- (2) 500 km Ǥʿ
  call tangent_mean_scal( x, y, center(1), center(2), thick,  &
  &                       r(1:irad), theta(1:nt/2), tmpl(1:irad),  &
  &                       undef=undef, undefg=undef, undefgc='inc' )
  call tangent_mean_scal( x, y, center(1), center(2), thick,  &
  &                       r(1:irad), theta(nt/2+1:nt), tmpr(1:irad),  &
  &                       undef=undef, undefg=undef, undefgc='inc' )

  do i=1,irad
     tmpr(i)=tmpr(i)*r(i)
     tmpl(i)=tmpl(i)*r(i)
  end do

  call rectangle_int( r, tmpr, r(1), r(irad), rb )
  call rectangle_int( r, tmpl, r(1), r(irad), lb )

  rb=rb/(r(irad)**2-r(1)**2)
  lb=lb/(r(irad)**2-r(1)**2)

  !-- (3) 500 km Ǥκ, Ǿ
  call max_val_2d( tmpz3, itmp, itmp, dzmax3, undef=undef )
  call max_val_2d( tmpz6, itmp, itmp, dzmax6, undef=undef )
  call max_val_2d( tmpz9, itmp, itmp, dzmax9, undef=undef )
  call min_val_2d( tmpz3, itmp, itmp, dzmin3, undef=undef )
  call min_val_2d( tmpz6, itmp, itmp, dzmin6, undef=undef )
  call min_val_2d( tmpz9, itmp, itmp, dzmin9, undef=undef )

  B=(rb-lb)
  VTL=((dzmax6-dzmin6)-(dzmax9-dzmin9))/(log(2.0/3.0))
  VTU=((dzmax3-dzmin3)-(dzmax6-dzmin6))/(log(0.5))

end subroutine CPS_Hart

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine DC_Braun( x, y, fg, pres, search_dis, var_dis, center, undef,  &
  &                  stdopt )
! Braun (2002) ˡ濴ꤹ.
  use Math_Const
  use Max_Min
  use Statistics
  implicit none
  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  integer, intent(in) :: fg(2)
                         ! 濴 (̾ﵤκ)
                         ! fg(1) = x ֹ, fg(2) = y ֹ
  real, intent(in) :: pres(size(x),size(y))
                         ! ٤Ǥε (ɽ̵Ǥ褤.)
                         ! , ɽ̵ξ, ̹Ƥ.
  real, intent(in) :: search_dis  ! ΰ (fg ΰ֤濴)
                         ! 㤨, 100000.0 ʤ, fg 濴˽Ĳ 100 km 
  real, intent(in) :: var_dis  ! 濴֤к׻Ⱦ [m]
  integer, intent(inout) :: center(2)  ! ᤿濴γǿ
  real, intent(in), optional :: undef  ! ̤ͤ, ̤.
                             ! ܥ롼Ǥ, ̤ͤ, 
                             ! γʻΤк׻˻Ѥʤ.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)

  integer :: i, j, ix, jy, nx, ny, nr, nt, nxgmin, nxgmax, nygmin, nygmax
  integer :: ompnum, tmp_o_num
  real :: dr, dtheta, undeff, tmpmin, tmp_anom, tmp_counter
  real, allocatable, dimension(:) :: rad, theta
  real, allocatable, dimension(:,:) :: anom_check
  real, allocatable, dimension(:,:,:) :: apres
  logical :: stderr

!-- OpenMP ؿ
!$ integer :: OMP_GET_THREAD_NUM, OMP_GET_MAX_THREADS

  nx=size(x)
  ny=size(y)

  if(present(undef))then
     undeff=undef
  else
     undeff=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- ʻϰϤ

  call interpo_search_2d( x, y, x(fg(1))-0.5*search_dis,  &
  &                             y(fg(2))-0.5*search_dis,  &
  &                       nxgmin, nygmin, undeff=int(undeff),  &
  &                       stdopt=stderr )

  call interpo_search_2d( x, y, x(fg(1))+0.5*search_dis,  &
  &                             y(fg(2))+0.5*search_dis,  &
  &                       nxgmax, nygmax, undeff=int(undeff),  &
  &                       stdopt=stderr )

  if(nxgmin==int(undeff))then  ! ΰ賰Ȥξν
     nxgmin=1
  end if
  if(nygmin==int(undeff))then  ! ΰ賰Ȥξν
     nygmin=1
  end if
  if(nxgmax==int(undeff))then  ! ΰ賰Ȥξν
     nxgmax=1
  end if
  if(nygmax==int(undeff))then  ! ΰ賰Ȥξν
     nygmax=1
  end if

!  nxgmin=fg(1)-(search_dis-1)/2
!  nxgmax=fg(1)+(search_dis-1)/2
!  nygmin=fg(2)-(search_dis-1)/2
!  nygmax=fg(2)+(search_dis-1)/2

  allocate(anom_check(nx,ny))

!-- openmp Ǥξդѥ
!-- ʿѥΥޥβս openmp 󤷤,
!-- apres  inout °ʤΤ, private °ꤷʤ
!-- thread Ȥ apres ͤ񤭤Ƥޤ.
!-- , threads number 򻲾Ȥ 3 ˤ,
!-- thread Ȥ̤Ȥ褦ѹ.

   ompnum=1
!$   ompnum=OMP_GET_MAX_THREADS()  ! OpenMP ͭξϤͭ.

  allocate(apres(nx,ny,ompnum))

!-- ϤؤѴκݤˤ, var_dis Ǥ٤ x, y ʤ褦
!-- ꤹ.

  nr=int(var_dis/(x(2)-x(1)))+1
  nt=int(2.0*pi*var_dis/(x(2)-x(1)))+1
!  nt=4
  dr=x(2)-x(1)
  dtheta=2.0*pi/real(nt-1)

  allocate(rad(nr))
  allocate(theta(nt))

  rad=(/((dr*real(i-1)),i=1,nr)/)
  theta=(/((dtheta*real(i-1)),i=1,nt)/)

!-- õʻˤĤ, ʿкȤ,
!-- Ƴʻˤкιפ׻.

  anom_check=undeff  ! õϰϳγʻˤϤ٤ undeff .
                     ! õϰγʻҤˤϤȤǥ.

  tmp_o_num=1  ! OpenMP ͭǤʤ, ͤ apres  3 ܤ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,tmp_anom,tmp_o_num,tmp_counter)

  do j=nygmin,nygmax
     do i=nxgmin,nxgmax

        if(pres(i,j)/=undeff)then
!$         tmp_o_num=OMP_GET_THREAD_NUM()+1  ! OpenMP ͭξ, ͤ apres  3 ܤ

           apres(:,:,tmp_o_num)=0.0
           tmp_counter=0

           call tangent_mean_anom_scal_Cart( x, y, x(i), y(j), pres, rad, theta,  &
  &                                          apres(:,:,tmp_o_num), undef=undeff,  &
  &                                          undefg=undeff, undefgc='inc',  &
  &                                          stdopt=stderr )

           tmp_anom=0.0

           do jy=1,ny
              do ix=1,nx
                 if(apres(ix,jy,tmp_o_num)/=undeff)then
                    tmp_counter=tmp_counter+1
                    tmp_anom=tmp_anom+apres(ix,jy,tmp_o_num)*apres(ix,jy,tmp_o_num)
                 end if
              end do
           end do

           if(tmp_counter>0)then  ! ʿѤ undef ʤȤϹʤ.
              anom_check(i,j)=tmp_anom
           end if
        end if
     end do
  end do

!$omp end do
!$omp end parallel

!-- ׻кιͤΤ, ǾȤʤʻ.

  call min_val_2d( anom_check, center(1), center(2), tmpmin, undef=undeff )

  if(stderr.eqv..false.)then
     if(center(1)==nx+1.or.center(2)==ny+1)then
        write(*,*) "*** WARNING *** : DC_Braun (typhoon_analy)"
        write(*,*) "Setting the undef only point."
     end if
  end if

  deallocate(rad)
  deallocate(theta)
  deallocate(anom_check)
  deallocate(apres)

end subroutine DC_Braun

!--------------------------------------------------------------
!  ʲ, private 롼
!--------------------------------------------------------------

subroutine search_region_1d( x, y, c, r, nr, stdopt )
! ʿѲǽȾ¤׻롼
  use Statistics
  implicit none
  real, intent(in) :: x(2)  ! x ξüɸ [m]
  real, intent(in) :: y(2)  ! y ξüɸ [m]
  real, intent(in) :: c(2)  ! 濴ΰֺɸ (x,y) [m]
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  integer, intent(inout) :: nr  ! ʿѲǽȾ¤ֹ (r(nr) ǽȾ)
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nrr, tmp_nr
  real :: xc, yc
  logical :: stderr

  nrr=size(r)
  xc=c(1)
  yc=c(2)
  nr=nrr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(abs(x(1)-xc) < r(nrr))then
     if(stderr.eqv..false.)then
        write(*,*) "typhoon_analy WARNING :"
        write(*,*) "|x(1)-xc| >= rmax. "
        write(*,*) "undef value is substituted out of region."
     end if
     call interpo_search_1d( r, abs(x(1)-xc), tmp_nr, stdopt=stderr )
     nr=tmp_nr+1  ! interpo_search  abs ͤ꾮 r ֹ椬뤿.
                  ! ʲƱͳ
  else
     if(abs(x(2)-xc) < r(nrr))then
        if(stderr.eqv..false.)then
           write(*,*) "typhoon_analy WARNING :"
           write(*,*) "|x(nx)-xc| >= rmax. "
           write(*,*) "undef value is substituted out of region."
        end if
        call interpo_search_1d( r, abs(x(2)-xc), tmp_nr, stdopt=stderr )
        if(tmp_nr+1<nr)then
           nr=tmp_nr+1
        end if
     else
        if(abs(y(1)-yc) < r(nrr))then
           if(stderr.eqv..false.)then
              write(*,*) "typhoon_analy WARNING :"
              write(*,*) "|y(1)-yc| >= rmax. "
              write(*,*) "undef value is substituted out of region."
           end if
           call interpo_search_1d( r, abs(y(1)-yc), tmp_nr, stdopt=stderr )
           if(tmp_nr+1<nr)then
              nr=tmp_nr+1
           end if
        else
           if(abs(y(2)-yc) < r(nrr))then
              if(stderr.eqv..false.)then
                 write(*,*) "typhoon_analy WARNING :"
                 write(*,*) "|y(ny)-yc| >= rmax. "
                 write(*,*) "undef value is substituted out of region."
              end if
              call interpo_search_1d( r, abs(y(2)-yc), tmp_nr, stdopt=stderr )
              if(tmp_nr+1<nr)then
                 nr=tmp_nr+1
              end if
           end if
        end if
     end if
  end if

end subroutine search_region_1d

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_1d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val)
  checker=.false.

  do i=1,nx
     if(val(i)==undef)then
        checker=.true.
        exit
     end if
  end do

  undef_checker_1d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_2d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,2)
  checker=.false.

  do i=1,nx
     checker=undef_checker_1d( val(:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_2d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_3d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,3)
  checker=.false.

  do i=1,nx
     checker=undef_checker_2d( val(:,:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_3d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

!subroutine Rangular_moment(xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod_2d Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod_2d(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!
!end subroutine Rangular_moment
!
!
!subroutine Aangular_moment(xp,yp,x,y,u,v,f,mome)
!! Ǥդޤгѱư̤׻롼
!!
!! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!!
!! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!!
!! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
!! ׻뤳Ȥǽ.
!!
!! ٥ȥγѷ׻롼 vec_prod_2d Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: f(size(x),size(y))  !  i,j ǤΥꥪѥ᡼
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1), rp(size(x),size(y)), tmp1(1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod_2d(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!  call radius(xp,yp,0.0,x,y,tmp1,rp)
!
!!$omp parallel do shared(mome,f,rp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
!     end do
!  end do
!!$omp end parallel do
!
!end subroutine Aangular_moment

!-----------------------------------------
!-----------------------------------------

!-----------------------------------------
!-----------------------------------------

end module typhoon_analy
