!-----------------------------------------------------------------------
!     Copyright (C) 2000-2013 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module vert_coord_conv
! ľκɸѴ˴ؤ⥸塼

  use Statistics

  implicit none

contains

subroutine v1_2_v2_1d( v1, v2, val1, val2, undef, sig )
! Ǥդαľɸ v1 ̤αľɸ v2 ؤ val1 ȤѿѴԤ.
! ܥ롼˳Ǽʪ̤ϴ٤Ǹ㤤ֹ
! Τ˳ǼƤȲꤷƤ.
  use Statistics
  implicit none
  real, dimension(:), intent(in) :: v1  ! Ȥʤľɸ [v2 Ʊñ]
  real, dimension(:), intent(in) :: v2  ! Ѵαľɸ [v1 Ʊñ]
  real, dimension(size(v1)), intent(in) :: val1  ! v1 Ǥѿ
  real, dimension(size(v2)), intent(inout) :: val2  ! v2 Ǥѿ
  real, intent(in), optional :: undef  ! ѴǤʤ̤
                                       ! ǥեȤϥ
  character(1), intent(in), optional :: sig  ! Ѵκɸ
                            ! , ؿΤɤ餫ꤹ.
                            ! ξ -> "p", ξ -> "m".
                            ! ǥեȤ "p".
                            ! [] ξ "m", ٤ξ "p".
  integer :: i, j, n1, n2
  real :: tmp1(size(v1)), tmp2(size(v2))
  real :: tmpv1(size(v1)), tmpv2(size(v2))
  real :: undeff
  character(1) :: vc1

  n1=size(v1)
  n2=size(v2)

!-- ץν

  if(present(undef))then
     undeff=undef
  else
     undeff=0.0
  end if

  if(present(sig))then
     vc1(1:1)=sig(1:1)
  else
     vc1(1:1)='p'
  end if

!-- ؿˤĤ, Ȥʤ褦֤.

  if(vc1(1:1)=='m')then
     do i=1,n1
        tmp1(i)=v1(n1-i+1)
        tmpv1(i)=val1(n1-i+1)
     end do
     do i=1,n2
        tmp2(i)=v2(n2-i+1)
     end do
  else
     do i=1,n1
        tmp1(i)=v1(i)
        tmpv1(i)=val1(i)
     end do
     do i=1,n2
        tmp2(i)=v2(i)
     end do
  end if

  call auto_interpolation_1d( tmp1, tmp2, tmpv1, tmpv2, undef=undeff,  &
  &                           undefr=undeff )

  if(vc1(1:1)=='m')then
     do i=1,n2
        val2(i)=tmpv2(n2-i+1)
     end do
  else
     do i=1,n2
        val2(i)=tmpv2(i)
     end do
  end if

end subroutine v1_2_v2_1d

!------------------------------------------
!------------------------------------------

subroutine v1_2_v2_3d( v1, v2, val1, val2, undef, sig )
! Ǥդαľɸ v1 ̤αľɸ v2 ؤ val1 ȤѿѴԤ.
! ܥ롼˳Ǽʪ̤ϴ٤Ǹ㤤ֹ
! Τ˳ǼƤȲꤷƤ.
  use Statistics
  implicit none
  real, dimension(:,:,:), intent(in) :: v1  ! Ȥʤľɸ [v2 Ʊñ]
  real, dimension(:,:,:), intent(in) :: v2
                             ! Ѵαľɸ [v1 Ʊñ]
  real, dimension(size(v1,1),size(v1,2),size(v1,3)), intent(in) :: val1
                             ! v1 Ǥѿ
  real, dimension(size(v1,1),size(v1,2),size(v2,3)), intent(inout) :: val2
                             ! v2 Ǥѿ
  real, intent(in), optional :: undef  ! ѴǤʤ̤
                                       ! ǥեȤϥ
  character(1), intent(in), optional :: sig  ! Ѵκɸ
                            ! , ؿΤɤ餫ꤹ.
                            ! ξ -> "p", ξ -> "m".
                            ! ǥեȤ "p".
                            ! [] ξ "m", ٤ξ "p".
  integer :: i, j, k, nx, ny, nz1, nz2
  real :: tmp1(size(v1,1),size(v1,2),size(v1,3))
  real :: tmp2(size(v1,1),size(v1,2),size(v2,3))
  real :: undeff
  character(1) :: vc1

  nx=size(v1,1)
  ny=size(v1,2)
  nz1=size(v1,3)
  nz2=size(v2,3)

!-- ץν

  if(present(undef))then
     undeff=undef
  else
     undeff=0.0
  end if

  if(present(sig))then
     vc1(1:1)=sig(1:1)
  else
     vc1(1:1)='p'
  end if

!-- ؿˤĤ, Ȥʤ褦֤.

  do j=1,ny
     do k=1,nx
        call v1_2_v2_1d( v1(k,j,:), v2(k,j,:), val1(k,j,:), val2(k,j,:),  &
  &                      undeff, vc1(1:1) )
     end do
  end do

end subroutine

!------------------------------------------
!------------------------------------------

end module
