!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Matrix_Calc
!  ׻˹Ԥ롼.
!  ͭͷ׻չ׻, ϢΩεʤɤԤ.
!  ˥٥ȥ.

  public :: Gau_Sei
  public :: LU_devs
  public :: Jacobi_algebra
  public :: SOR_Gau_Sei
  public :: SOR_Jacobi_algebra
  public :: gausss
  public :: schumit_norm
  public :: mat_dot
  public :: Householder
  public :: QR_method
  private :: errata
  private :: Pivot_part
  private :: vec_dot
  private :: sum_sq


interface trans_mat
!  module Matrix_Calc

  module procedure trans_mat_i, trans_mat_f

end interface trans_mat

interface determ_2d
!  module Matrix_Calc

  module procedure determ_2d_i, determ_2d_f

end interface determ_2d



contains

subroutine trans_mat_i( a )
!  ʬž֤֤
  implicit none
  integer, intent(inout), dimension(:,:) :: a  ! Ϲ
  integer :: i, j, tmp, nx

  nx=size(a,1)

  do j=1,nx
     do i=1,nx
        if(i<j)then
           tmp=a(j,i)
           a(j,i)=a(i,j)
           a(i,j)=tmp
        end if
     end do
  end do

end subroutine

!-----------------------------------------------------------------

subroutine trans_mat_f( a )
!  ʬž֤֤(¿)
  implicit none
  real, intent(inout), dimension(:,:) :: a  ! Ϲ
  integer :: i, j, nx
  real :: tmp

  nx=size(a,1)

  do j=1,nx
     do i=1,nx
        if(i<j)then
           tmp=a(j,i)
           a(j,i)=a(i,j)
           a(i,j)=tmp
        end if
     end do
  end do

end subroutine

!-----------------------------------------------------------------
!-----------------------------------------------------------------

recursive function determ_2d_i( a ) result(res)
! 2x2 ι󼰤׻ؿ()
  implicit none
  integer, dimension(2,2), intent(in) :: a  ! 2x2 
  integer :: res

  res=a(1,1)*a(2,2)-a(1,2)*a(2,1)

  return
end function

!-----------------------------------------------------------------
!-----------------------------------------------------------------

recursive function determ_2d_f( a ) result(res)
! 2x2 ι󼰤׻ؿ(¿)
  implicit none
  real, dimension(2,2), intent(in) :: a  ! 2x2 
  real :: res

  res=a(1,1)*a(2,2)-a(1,2)*a(2,1)

  return
end function

!-----------------------------------------------------------------
!-----------------------------------------------------------------

subroutine mat_dot( a, b, c )
! ƱΤѤ׻ (a * b = c).
  implicit none
  real, dimension(:,:), intent(in) :: a, b
  real, dimension(:,:), intent(inout) :: c
  integer :: i, j, k, l, m, n

  m=size(a,1)
  n=size(a,2)

  if(n/=size(b,1).or.m/=size(b,2).or.m/=size(c,1).or.m/=size(c,2))then
     write(*,*) "ERROR (mat_dot) : when a * b = c, a=mxn -> b=nxm, c=mxm"
     write(*,*) "STOP."
     stop
  end if

  do j=1,m
     do i=1,m
        c(i,j)=0.0
        do k=1,n
           c(i,j)=c(i,j)+a(i,k)*b(k,j)
        end do
     end do
  end do

end subroutine mat_dot

!-----------------------------------------------------------------
!-----------------------------------------------------------------

subroutine invert_mat( ax, xx )
! ξõˡĥ, չ׻.
! Ūˤ, դ b ñ̥٥ȥ 1 Ĥ,õ̤Υ٥ȥ¤٤
! չˤ.
  implicit none
  real, intent(in) :: ax(:,:)  ! չ
  real, intent(inout) :: xx(size(ax,1),size(ax,2))  ! ᤿չ
  integer :: i, j, k
  real :: c(size(ax,1),size(ax,2))  ! ñ̹
  real :: d(size(ax,1),size(ax,2))  ! a(i,j) 򥬥롼Ϥ, ̤ѲΤǤ˰
  integer :: nx

  nx=size(ax,1)

  c=0.0

  do i=1,nx
     c(i,i)=1.0
  end do

  do i=1,nx

     do j=1,nx
        do k=1,nx
           d(k,j)=ax(k,j)  ! ߡѿ
        end do
     end do

     call gausss( d, c(:,i), xx(:,i) )  !  2 ʬɽΤ, ν֤ OK.
  end do

end subroutine invert_mat

!-----------------------------------------------------------------
!  ʲ, ϢΩ 1 ε롼
!-----------------------------------------------------------------

subroutine gausss( c, d, x )
! ʬԥܥåդξõˡ
  implicit none
  real, intent(in) :: d(:)
  real, intent(in) :: c(size(d),size(d))  !  ( 1 ǤԤɽ)
  real, intent(inout) :: x(size(d))
  real :: b(size(d))
  real :: a(size(d),size(d))  !  ( 1 ǤԤɽ)
  real :: s, pivotb
  real :: pivot(size(d)+1)
  integer :: piv, i, j, k, nmax

  nmax=size(b)

  do k=1,nmax
     do j=1,nmax
        a(j,k)=c(j,k)
     end do
     b(k)=d(k)
  end do

!-- ʾõ ---
!-- A(I,J) ʾõ ---
  do k=1,nmax-1
!-- PIVOT  ---
!-- ޤ, I ʬκͤꤹ ---
     piv=k
     do i=k+1,nmax
         if(abs(a(i,k)).gt.abs(a(piv,k)))then
            piv=i
         end if
     end do
!-- ޤǤ, ͤꤵ ---
!-- ʲ, ͤȤʬιԤؤ ---
     do j=k,nmax
        pivot(j)=a(k,j)
        a(k,j)=a(piv,j)
        a(piv,j)=pivot(j)
     end do
     pivotb=b(k)
     b(k)=b(piv)
     b(piv)=pivotb
!-- PIVOT ޤ ---
     do i=k+1,nmax
        a(k,i)=a(k,i)/a(k,k)
     end do
     b(k)=b(k)/a(k,k)
     a(k,k)=1.0

     do j=k+1,nmax
        do i=k+1,nmax
            a(j,i)=a(j,i)-a(k,i)*a(j,k)
        end do
        b(j)=b(j)-b(k)*a(j,k)
        a(j,k)=0.0
     end do
  end do

  b(nmax)=b(nmax)/a(nmax,nmax)
  a(nmax,nmax)=1.0

!-- X(I) θ
  x(nmax)=b(nmax)
  do i=nmax-1,1,-1
     s=b(i)
     do j=i+1,nmax
        s=s-a(i,j)*x(j)
     end do
     x(i)=s
  end do

end subroutine gausss

!------------------------------------------

subroutine LU_devs( a, b, x, itermax )
!-- LU ʬ׻륵֥롼 ---
  implicit none
  real, intent(inout) :: b(:)  ! դΥ٥ȥ
  real, intent(inout) :: a(size(b),size(b))  !  ( 1 ǤԤɽ)
  real, intent(inout) :: x(size(b))  ! 
  integer, intent(in) :: itermax  ! ȿβ
  real :: d(size(b),size(b)), r(size(b)), y(size(b))
  integer :: ip(size(b))
  real :: scale(size(b)), dx(size(b))
  real :: s, t, pivot, xnorm, dxnorm
  real :: s1, s2, s3, s4, s5, t0, t1, t3, t4, eps
  integer :: iter, nmax
  integer :: p, itemp, i, j, k

  nmax=size(b)

!-- ȿɤǤ٤ ---
  t4=6.0

!--  x(i) ν ---
  do i=1,nmax
     x(i)=0.0
  end do

  do i=1,nmax
     do j=1,nmax
        d(i,j)=a(i,j)
     end do

     ip(i)=i

!-- ͤ׻롼 ---
     s=d(i,1)
     do j=2,nmax
        if(d(i,j).gt.s)then
           s=d(i,j)
        end if
     end do
     scale(i)=1.0/s
  end do

  do k=1,nmax
     t=d(ip(k),k)*scale(ip(k))
     p=k
     do i=k,nmax
        t0=d(ip(i),k)*scale(ip(i))
        if(t0.gt.t)then
           t=t0
           p=i
        end if
     end do

!-- ip(p)  ip(k) ؤ ---
     if(p.ne.k)then
        itemp=ip(p)
        ip(p)=ip(k)
        ip(k)=itemp
     end if

     pivot=d(ip(k),k)
     do i=k+1,nmax
        d(ip(i),k)=d(ip(i),k)/pivot
        do j=k+1,nmax
           d(ip(i),j)=d(ip(i),j)-d(ip(i),k)*d(ip(k),j)
        end do
     end do
     if(k.ge.nmax-1)then
        exit
     end if
  end do

!-- ʾõ ---
  y(1)=b(ip(1))
  do i=2,nmax
     s1=0.0
     do j=1,i-1
        s1=s1+d(ip(i),j)*y(j)
     end do
     y(i)=b(ip(i))-s1
  end do

!--  ---
  x(nmax)=y(nmax)/d(ip(nmax),nmax)
  do i=nmax-1,1,-1
     s2=0.0
     do j=i+1,nmax
        s2=s2+d(ip(i),j)*y(j)
     end do
     x(i)=(y(i)-s2)/d(ip(i),i)
  end do

  t1=x(1)
  xnorm=x(1)

  do i=2,nmax
     if(x(i).gt.t1)then
        t1=x(i)
        xnorm=x(i)
     end if
  end do

!-- ȿ ---
  eps=10**(-t4)                      ! ɸ٤ 10 ʿ t4 Ȥ

  do iter=1,itermax
     if(xnorm==0.0)then
        exit
     end if
!-- ĺη׻ ---
     do i=1,nmax
        s3=0.0
        do j=1,nmax
           s3=s3+a(i,j)*x(j)
        end do
        r(i)=b(i)-s3
     end do

!-- ʾõ ---
     y(1)=r(ip(1))
     do i=2,nmax
        s4=0.0
        do j=1,i-1
           s4=s4+d(ip(i),j)*y(j)
        end do
        y(i)=r(ip(i))-s4
     end do

!--  ---
     dx(nmax)=y(nmax)/d(ip(nmax),nmax)
     do i=nmax-1,1,-1
        s5=0.0
        do j=i+1,nmax
           s5=s5+d(ip(i),j)*y(j)
        end do
        dx(i)=(y(i)-s5)/d(ip(i),i)
     end do

     do i=1,nmax
        x(i)=x(i)+dx(i)
     end do

     t3=dx(1)
     dxnorm=dx(1)
     do i=1,nmax
        if(dx(i).gt.t3)then
           t3=dx(i)
           dxnorm=dx(i)
        end if
     end do

     if(dxnorm/xnorm.le.eps)then
        exit
     end if
  end do

end subroutine LU_devs

!------------------------------------------

subroutine Gau_Sei(a, b, eps, x)
  ! ǥˡˤϢΩ 1 
  implicit none
  real, intent(inout) :: b(:)  ! ax=b Υ٥ȥ
  real, intent(inout) :: a(size(b),size(b))  !  ( 1 Ǥιʬɽ)
  real, intent(in) :: eps  ! «
  real, intent(inout) :: x(size(b))  ! 򤯲
  integer :: i, j  ! ƥ졼ź
  real :: xn  !  x(i) Υƥΰ
  real :: err, err_max  ! 
  integer :: nx
!-- ͤ 0.0 饹Ȥ ---
  x=0.0
  nx=size(b)

!-- ԥܥåƥ
  call Pivot_part( a, b )

!-- ʲ, while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ ---
  err_max=0.0
  do i=1,nx
     xn=0.0

     do j=1,nx
        if(j/=i)then
           xn=xn+a(i,j)*x(j)
        end if
     end do

     xn=(b(i)-xn)/a(i,i)

     err=errata(x(i),xn,1)

     if(err_max<=err)then
        err_max=err
     end if

     x(i)=xn

  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        xn=0.0

        do j=1,nx
           if(j/=i)then
              xn=xn+a(i,j)*x(j)
           end if
        end do

        xn=(b(i)-xn)/a(i,i)
        err=errata(x(i),xn,1)

        if(err_max<=err)then
           err_max=err
        end if

        x(i)=xn

     end do
  end do

end subroutine Gau_Sei

!------------------------------------------

subroutine Jacobi_algebra(a, b, eps, x)
  ! 䥳ˡˤϢΩ 1 
  implicit none
  real, intent(inout) :: b(:)  ! ax=b Υ٥ȥ
  real, intent(inout) :: a(size(b),size(b))  !  ( 1 ǤιԤɽ)
  real, intent(in) :: eps  ! «
  real, intent(inout) :: x(size(b))  ! 򤯲
  real :: y(size(b))  ! 䥳ˡǻѤǼ, ǰƹ.(xn )
  integer :: i, j  ! ƥ졼ź
  real :: err, err_max  ! 
  integer :: nx

  nx=size(b)

!-- ͤ 0,0 饹Ȥ ---
  x=0.0
  y=0.0

!-- ԥܥåƥ
  call Pivot_part( a, b )

!-- ʲ, ºݤΥ(while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ) ---
  err_max=0.0
  do i=1,nx
     y(i)=0.0

     do j=1,nx
        if(j/=i)then
           y(i)=y(i)+a(i,j)*x(j)
        end if
     end do

     y(i)=(b(i)-y(i))/a(i,i)

     err=errata(x(i),y(i),1)

     if(err_max<=err)then
        err_max=err
     end if
  end do

  do i=1,nx  ! ǡΰƹ
     x(i)=y(i)
  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0

        do j=1,nx
           if(j/=i)then
              y(i)=y(i)+a(i,j)*x(j)
           end if
        end do

        y(i)=(b(i)-y(i))/a(i,i)
        err=errata(x(i),y(i),1)

        if(err_max<=err)then
           err_max=err
        end if
     end do

     do i=1,nx  ! ǡΰƹ
        x(i)=y(i)
     end do
  end do

end subroutine Jacobi_algebra

!------------------------------------------

subroutine SOR_Gau_Sei(a, b, eps, accel, x)
  ! ǥˡ, SOR ǲ®ˤϢΩ 1 
  implicit none
  real, intent(inout) :: b(:)  ! ax=b Υ٥ȥ
  real, intent(inout) :: a(size(b),size(b))  !  ( 1 ǤιԤɽ)
  real, intent(in) :: eps  ! «
  real, intent(in) :: accel  ! ®. , Ū accel >= 2 ǤȯΤ,
                             ! Ͱʾ夬ꤵȥ顼ǻߤ.
  real, intent(inout) :: x(size(b))  ! 򤯲
  integer :: i, j  ! ƥ졼ź
  real :: xn  !  x(i) Υƥΰ
  real :: err, err_max  ! 
  integer :: nx

  nx=size(b)

!-- ®ѥ᡼γǧ
  if(accel>=2.0)then
     write(*,*) "***** ERROR *****"
     write(*,*) "accel parameter must be less than 2.0. STOP."
     stop
  end if

!-- ͤ 0.0 饹Ȥ ---
  x=0.0

!-- ԥܥåƥ
  call Pivot_part( a, b )

!-- ʲ, while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ ---
  err_max=0.0
  do i=1,nx
     xn=0.0

     do j=1,nx
        if(j/=i)then
           xn=xn+a(i,j)*x(j)
        end if
     end do

     xn=(b(i)-xn)/a(i,i)
     xn=x(i)+accel*(xn-x(i))

     err=errata(x(i),xn,1)

     if(err_max<=err)then
        err_max=err
     end if

     x(i)=xn

  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        xn=0.0

        do j=1,nx
           if(j/=i)then
              xn=xn+a(i,j)*x(j)
           end if
        end do

        xn=(b(i)-xn)/a(i,i)
        xn=x(i)+accel*(xn-x(i))
        err=errata(x(i),xn,1)

        if(err_max<=err)then
           err_max=err
        end if

        x(i)=xn

     end do
  end do

end subroutine SOR_Gau_Sei

!------------------------------------------

subroutine SOR_Jacobi_algebra(a, b, eps, accel, x)
  ! 䥳ˡ SOR ®ˤϢΩ 1 
  implicit none
  real, intent(inout) :: b(:)  ! ax=b Υ٥ȥ
  real, intent(inout) :: a(size(b),size(b))  !  ( 1 ǤιԤɽ)
  real, intent(in) :: eps  ! «
  real, intent(in) :: accel  ! ®. , Ū accel >= 2 ǤȯΤ,
                             ! Ͱʾ夬ꤵȥ顼ǻߤ.
  real, intent(inout) :: x(size(b))  ! 򤯲
  real :: y(size(b))  ! 䥳ˡǻѤǼ, ǰƹ.(xn )
  integer :: i, j  ! ƥ졼ź
  real :: err, err_max  ! 
  integer :: nx

  nx=size(b)

!-- ®ѥ᡼γǧ
  if(accel>=2.0)then
     write(*,*) "***** ERROR *****"
     write(*,*) "accel parameter must be less than 2.0. STOP."
     stop
  end if

!-- ͤ 0,0 饹Ȥ ---
  x=0.0
  y=0.0

!-- ԥܥåƥ
  call Pivot_part( a, b )

!-- ʲ, ºݤΥ(while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ) ---
  err_max=0.0
  do i=1,nx
     y(i)=0.0

     do j=1,nx
        if(j/=i)then
           y(i)=y(i)+a(i,j)*x(j)
        end if
     end do

     y(i)=(b(i)-y(i))/a(i,i)

     err=errata(x(i),y(i),1)

     if(err_max<=err)then
        err_max=err
     end if
  end do

  do i=1,nx  ! ǡΰƹ
     x(i)=x(i)+accel*(y(i)-x(i))
  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0

        do j=1,nx
           if(j/=i)then
              y(i)=y(i)+a(i,j)*x(j)
           end if
        end do

        y(i)=(b(i)-y(i))/a(i,i)
        y(i)=x(i)+accel*(y(i)-x(i))
        err=errata(x(i),y(i),1)

        if(err_max<=err)then
           err_max=err
        end if
     end do

     do i=1,nx  ! ǡΰƹ
        x(i)=y(i)
     end do
  end do

end subroutine SOR_Jacobi_algebra

!-----------------------------------------
! ʲ, ͭΤΥ롼
!-----------------------------------------

subroutine eigenvalue_power( a, eps, eigenval, eigenvec )
! ٤ˡѤƹκͭͤȤθͭͤбͭ٥ȥ.
  implicit none
  real, intent(inout) :: eigenvec(:)  ! ͭ٥ȥ
  real, intent(in) :: a(size(eigenvec),size(eigenvec))  ! ͭͤ ( 1 ǤԤɽ)
  real, intent(in) :: eps  ! «Ƚ
  real, intent(inout) :: eigenval  !  a κͭ
  integer :: i, j
  real, dimension(size(eigenvec)) :: x, y
  real :: tmp1, tmp2, err_max
  integer :: nx

  nx=size(eigenvec)

  do i=1,nx
     x(i)=1.0  ! ȿˡνͤȤ󥼥Υ٥ȥ
  end do

  tmp1=sqrt(vec_dot( x, x ))  ! ٥ȥΥΥ׻

  do i=1,nx
     x(i)=x(i)/tmp1  ! ٥ȥ򵬳ʲ
  end do

  err_max=eps  ! while ʸ뤿ν

!-- ȿˡ

  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0  ! ν
        do j=1,nx
           y(i)=y(i)+a(i,j)*x(j)
        end do
     end do

     tmp1=sqrt(vec_dot( y, y ))  ! ٥ȥΥΥ׻

     do i=1,nx
        x(i)=y(i)/tmp1  ! x(i) ι
     end do

!-- ͭͷ׻
     tmp2=vec_dot( x, y )  ! Ƿ׻ Ay  y^t (Ĥޤ, ͭ٥ȥž) 򤫤.
     err_max=errata( eigenval, tmp2, 1 )  !  x(i) ȹ y(i) θ
     eigenval=tmp2

  end do

!-- ȿˡλ

  do i=1,nx
     eigenvec(i)=x(i)  ! ͭ٥ȥѿ
  end do

end subroutine eigenvalue_power

!------------------------------------------
!------------------------------------------

subroutine Jacobi_eigen( a, lambda, eps )
! Jacobi ˡѤƸͭͤ׻롼.
! ܥ롼Ǥ, ׻оݤȤʤ n μоιǤʤФʤʤ.
  implicit none
  real, intent(in) :: a(:,:)  ! ͭͤ׻оι.
                              !  1 Ǥ,  2 Ǥʬ򤽤줾ɽ.
  real, intent(inout) :: lambda(size(a,1))  ! Ƹͭ
  real, intent(in), optional :: eps  ! ȿ׻μ« [и]
                                     ! ǥեȤǤ, 1.0e-6
  integer :: i, j, k, n, m, l
  real :: tmp_a(size(a,1),size(a,2)), new_a(size(a,1),size(a,2))
  real :: error, err_max, tan2, cos2, sin2

  n=size(a,1)

  if(present(eps))then
     error=eps
  else
     error=1.0e-6
  end if

!-- intent(in) °ʤΤ, tmp 

  do j=1,n
     do i=1,n
        tmp_a(i,j)=a(i,j)
        new_a(i,j)=a(i,j)
     end do
  end do

!-- ºݤ˷׻.

  err_max=eps

  do while (err_max>=eps)
     err_max=0.0
     do j=1,n-1  ! ƹԤˤĤƽ
        do i=j+1,n  ! 廰ѤΤ߹Ԥ, гʬϰդ˵.
           if(tmp_a(i,j)/=0.0)then
              ! ʲ, 幹Ѥη׻
              if(tmp_a(i,i)/=tmp_a(j,j))then  ! гʬνŲ
                 tan2=2.0*tmp_a(i,j)/(tmp_a(i,i)-tmp_a(j,j))
                 cos2=sqrt(0.5*(1.0+1.0/sqrt(1.0+tan2*tan2)))
                 if(tan2>=0.0)then
                    sin2=sqrt(0.5*(1.0-1.0/sqrt(1.0+tan2*tan2)))
                 else
                    sin2=-sqrt(0.5*(1.0-1.0/sqrt(1.0+tan2*tan2)))
                 end if
              else  ! ξ, tan2=\infty ʤΤ,
                 cos2=sqrt(0.5)
                 if(tmp_a(i,j)>=0.0)then  ! ʤ, \pi / 4
                    sin2=sqrt(0.5)
                 else
                    sin2=-sqrt(0.5)
                 end if
              end if
              ! ʹߤǼºݤ˰򹹿
              new_a(i,j)=0.0  !  2 Ĥ˷׻Ƥ. 
              new_a(j,i)=0.0  ! (ȤƱ׻ 2 ԤΤ򤹤뤿)
              do k=1,n
                 if(k/=i.and.k/=j)then
                    new_a(i,k)=tmp_a(i,k)*cos2+tmp_a(j,k)*sin2
                    new_a(j,k)=-tmp_a(i,k)*sin2+tmp_a(j,k)*cos2
                    new_a(k,i)=tmp_a(k,i)*cos2+tmp_a(k,j)*sin2
                    new_a(k,j)=-tmp_a(k,i)*sin2+tmp_a(k,j)*cos2
                 else
                    if(k==i)then
                       new_a(i,k)=tmp_a(i,i)*cos2*cos2+tmp_a(j,j)*sin2*sin2  &
  &                               +2.0*tmp_a(i,j)*sin2*cos2
                    else
                       new_a(j,j)=tmp_a(i,i)*sin2*sin2+tmp_a(j,j)*cos2*cos2  &
  &                               -2.0*tmp_a(i,j)*sin2*cos2
                    end if
                 end if
              end do
              ! ʲ, new_a -> tmp_a ᤷ, Ʊ˺.
              do m=1,n
                 do l=1,n
                    error=abs(new_a(l,m)-tmp_a(l,m))
                    tmp_a(l,m)=new_a(l,m)
                    if(error>err_max)then  ! κͤ.
                       err_max=error
                    end if
                 end do
              end do
           end if
        end do
     end do
  end do

  do i=1,n
     lambda(i)=tmp_a(i,i)
  end do

end subroutine Jacobi_eigen

!-----------------------------------------
!-----------------------------------------

subroutine QR_method( a, lambda, p, eps, sym_opt )
! QR ʬˡѤƹ a ͭͤ׻롼.
! ʸ (2007) 4.8.
! ʲ줿ͭ٥ȥ褦ˤƤ뤬, ͤΤɤ̤ǧ.
! ͭͤ˴ؤƤ꤫ǧѤ.
! ׻ȤƤ,
! 1. Householder Ѵ
! 2. ľη׻
! 3. QR ʬ
! 4. QR 
  implicit none
  real, intent(in) :: a(:,:)  ! ͭͤ [ 1 Ǥ]
  real, intent(inout) :: lambda(size(a,1))  ! a θͭ
  real, intent(inout), optional :: p(size(a,1),size(a,2))  ! ͭ٥ȥ.
                       ! ֤ˤ, Householder Ѵν֤٤ʤ.
  real, intent(in), optional :: eps  ! ȿˡμ« default = 1.0e-5
  logical, intent(in), optional :: sym_opt  ! a оι.
                              ! .true. = оι, default = .false.
  integer :: i, j, k, n, counter
  real :: dia, s, t, err, err_max, tmp1, tmp2, mu
  real, dimension(size(a,1),size(a,2)) :: a0, q, r, b, tmp_p, tmp_pp
  logical :: sym_link, pconv_flag

  n=size(a,1)

  if(present(sym_opt))then
     sym_link=sym_opt
  else
     sym_link=.false.
  end if

  if(present(p))then
     pconv_flag=.true.
     p=0.0
  else
     pconv_flag=.false.
  end if

  if(present(eps))then
     err_max=eps
  else
     err_max=1.0e-5
  end if

!-- 1. Householder Ѵ.
  if(pconv_flag.eqv..true.)then
     call Householder( a, a0, p=tmp_p, sym_opt=sym_link )
  else
     call Householder( a, a0, sym_opt=sym_link )
  end if

  counter=n

  do while(counter>1)
     err=err_max
     do while(err_max<=err)
        q=0.0   ! QR ʬ Q_k 

        do k=1,n
           q(k,k)=1.0    ! ǽñ̹Ȥƽ
        end do

        mu=a0(counter,counter)
        a0(counter,counter)=0.0
        do k=1,counter-1
           a0(k,k)=a0(k,k)-mu    ! moving original point
        end do

!-- QR ʬԤ.
        do k=1,counter-1
           dia=sqrt(abs(a0(k,k))**2+abs(a0(k+1,k))**2)
           s=a0(k+1,k)/dia
           t=a0(k+1,k)/(dia+a0(k,k))

           a0(k+1,k)=0.0
           a0(k,k)=dia

           do j=k+1,counter
              tmp1=a0(k,j)
              tmp2=a0(k+1,j)
              a0(k,j)=tmp1+s*(tmp2-t*tmp1)
              a0(k+1,j)=tmp2-s*(tmp1+t*tmp2)
           end do

           do i=1,counter
              tmp1=q(i,k)
              tmp2=q(i,k+1)
              q(i,k)=tmp1+s*(tmp2-t*tmp1)
              q(i,k+1)=tmp2-s*(tmp1+t*tmp2)
           end do
        end do

        do j=1,counter
           do i=1,counter
              r(i,j)=a0(i,j)     ! QR ʬ줿廰ѹ R
           end do
        end do

!-- QR εѤ׻. A=RQ , R Ͼ廰, Q ϥإå٥륰ʤΤ,
!-- a_{i,j} = R_{i,k} * Q_{k,j} + R_{i,k+1} * Q_{k+1,j}, (k=i)
!-- , Q ž֤Ƿ׻Τ, Q=qT Ȥ, Q_{k,j} = q_{j,k}.
!-- a_{i,j} = R_{i,k} * q_{j,k} + R_{i,k+1} * q_{j,k+1}, (k=i)

        call mat_dot( r, q, a0 )

!-- mooving grid
        do i=1,counter
           a0(i,i)=a0(i,i)+mu
        end do

!-- «Ƚ
        if(abs(err_max)>abs(a0(counter,counter-1)))then
           err=abs(a0(counter,counter-1))
        end if

        if(pconv_flag.eqv..true.)then
           call mat_dot( q, tmp_p, tmp_pp )
           tmp_p(1:n,1:n)=tmp_pp(1:n,1:n)
        end if

     end do

     lambda(counter)=a0(counter,counter)
     counter=counter-1

  end do

  if(pconv_flag.eqv..true.)then
     p(1:n,1:n)=tmp_p(1:n,1:n)
  end if

  lambda(1)=a0(1,1)

end subroutine QR_method

!-----------------------------------------
!-----------------------------------------

subroutine Householder( a, b, p, sym_opt )
! ϥۥѴѤ, Ǥռоιإå٥륰Ѵ.
! , Υ롼ǤϷ׻®٤θ, гѤξ廰ʬϷ׻ʤ.
! оιξ, 廰ʬϲʬƱˤʤΤ,
! 廰ʬͤ, b βʬФ褤.
! ͤ (2007)  4.5.2.
  implicit none
  real, intent(in) :: a(:,:)   ! Ǥդμоι
  real, intent(inout) :: b(size(a,1),size(a,2))  ! إå٥륰
  real, intent(inout), optional :: p(size(a,1),size(a,2))  ! ѴѤľ
                                   ! ֤, Ѥ˷׻ԤΤ,
                                   ! ׻֤٤ʤ뤳Ȥ.
  logical, intent(in), optional :: sym_opt   ! a оι󤫤ɤ.
                       ! default = .false. (оΤǤϤʤ)
                       ! .true. ξ, b оʬ򤽤Τޤ֤.
                       ! ׻®٤θ̾оʬ׻ʤ.
  integer :: i, j, k, n
  real :: coe, s, t, tmp
  real, allocatable, dimension(:) :: w, pconv, qconv
  real, dimension(size(a,1),size(a,2)) :: tmp_p, tmp_pp
  logical :: sym_link, pconv_flag

  n=size(a,1)

  if(present(sym_opt))then
     sym_link=sym_opt
  else
     sym_link=.false.
  end if

  if(present(p))then
     pconv_flag=.true.
     p=0.0
  else
     pconv_flag=.false.
  end if

  if(size(a,1)/=size(a,2))then
     write(*,*) "*** ERROR (Householder) ***"
     write(*,*) "Input array must be square matrix. STOP."
     stop
  end if

  b(:,:)=a(:,:)

  allocate(w(n))
  allocate(pconv(n))
  allocate(qconv(n))

  if(sym_link.eqv..true.)then
     do j=1,n-2
        pconv=0.0
        qconv=0.0
        w=0.0
        tmp_p=0.0
     !-- Ѵκ
        t=sum_sq( b(j+1:n,j) )
        if(b(j+1,j)>0.0)then
           s=sqrt(t)
        else
           s=-sqrt(t)
        end if

        w(1:j)=0.0
        w(j+1)=b(j+1,j)+s
        coe=1.0/(t+b(j+1,j)*s)   ! η (2007)  c ǤϤʤ, 2c Ǥ.
        w(j+2:n)=b(j+2:n,j)

        do k=j+1,n
           do i=j+1,n
              pconv(k)=pconv(k)+b(k,i)*w(i)
           end do
           pconv(k)=coe*pconv(k)
        end do

        do k=j+1,n
           do i=j+1,n
              qconv(k)=qconv(k)+pconv(i)*w(i)
           end do
           qconv(k)=pconv(k)-0.5*coe*qconv(k)*w(k)
        end do

     !-- ѴˤѴ

        b(j+1,j)=-s
        b(j+2:n,j)=0.0

        do k=j+1,n
           do i=j+1,n
              b(i,k)=b(i,k)-qconv(i)*w(k)-w(i)*qconv(k)
           end do
        end do

        if(pconv_flag.eqv..true.)then
           do k=j+1,n   ! w  j+1 ʾʬΤ󥼥.
              do i=j+1,n
                 tmp_p(i,k)=-coe*w(i)*w(k)
              end do
           end do
           do k=1,n
              tmp_p(k,k)=1.0+tmp_p(k,k)
           end do

           if(j==1)then
              p(1:n,1:n)=tmp_p(1:n,1:n)
           else
              call mat_dot( p, tmp_p, tmp_pp )
              p(1:n,1:n)=tmp_pp(1:n,1:n)
           end if

        end if

     end do

     do k=1,n
        do j=k,n
           b(k,j)=b(j,k)
        end do
     end do

  else   ! оιξ (ޤбƤʤ.)

     do j=1,n-2
        pconv=0.0
        qconv=0.0
        w=0.0
        tmp_p=0.0
     !-- Ѵκ
        t=sum_sq( b(j+1:n,j) )
        if(b(j+1,j)>0.0)then
           s=sqrt(t)
        else
           s=-sqrt(t)
        end if

        w(1:j)=0.0
        w(j+1)=b(j+1,j)+s
        coe=1.0/(t+b(j+1,j)*s)   ! η (2007)  c ǤϤʤ, 2c Ǥ.
        w(j+2:n)=b(j+2:n,j)

        do k=j+1,n
           do i=j+1,n
              pconv(k)=pconv(k)+b(k,i)*w(i)
           end do
           pconv(k)=coe*pconv(k)
        end do

        do k=j+1,n
           do i=j+1,n
              qconv(k)=qconv(k)+pconv(i)*w(i)
           end do
           qconv(k)=pconv(k)-0.5*coe*qconv(k)*w(k)
        end do

     !-- ѴˤѴ

        b(j+1,j)=-s
        b(j+2:n,j)=0.0

        do k=j+1,n
           do i=j+1,n
              b(i,k)=b(i,k)-qconv(i)*w(k)-w(i)*qconv(k)
           end do
        end do

        if(pconv_flag.eqv..true.)then
           do k=j+1,n   ! w  j+1 ʾʬΤ󥼥.
              do i=j+1,n
                 tmp_p(i,k)=-coe*w(i)*w(k)
              end do
           end do
           do k=1,n
              tmp_p(k,k)=1.0+tmp_p(k,k)
           end do

           if(j==1)then
              p(1:n,1:n)=tmp_p(1:n,1:n)
           else
              call mat_dot( p, tmp_p, tmp_pp )
              p(1:n,1:n)=tmp_pp(1:n,1:n)
           end if

        end if

     end do

  end if

end subroutine Householder

!-----------------------------------------
!-----------------------------------------

subroutine schumit_norm( u, v )
! ߥåȤľˡѤ, nx ٥ȥľ򲽤.
!  1 Ǥ٥ȥγʬ,  2 ʬ٥ȥ뷲 1 ٥ȥɽ.
! Ĥޤ, u(i,j)  j ܥ٥ȥ i ʬȤȤɽ.
! ɽʤ, ĥ٥ȥ򲣤¤٤.
! ܥ롼ϥߥåȤľ򲽤ܤ˷׻ƤΤ,
! ׻®٤Ū٤餷.
  implicit none
  real, intent(in) :: u(:,:)  ! ľ򲽤Υ٥ȥ
  real, intent(inout) :: v(size(u,1),size(u,2))  ! ľ򲽸Υ٥ȥ
  integer :: i, j, k, nx, ny
  real :: tmpn(size(u,2))  ! ԤȤ, ΥͤǼ.
  real :: tmps(size(u,1))  ! ±黻κݤΰǼ˻.

  nx=size(u,1)
  ny=size(u,2)

  tmpn(1)=sqrt(vec_dot( u(:,1), u(:,1) ))
  do i=1,nx  ! 1 ܤΥ٥ȥδȤ.
     v(i,1)=u(i,1)/tmpn(1)
  end do

  do j=2,ny
     do i=1,nx
        tmps(i)=0.0
     end do
     do k=1,j-1
        do i=1,nx
           tmps(i)=tmps(i)+vec_dot( u(:,j), v(:,k) )*u(i,j)
        end do
     end do

     do i=1,nx
        v(i,j)=u(i,j)-tmps(i)
     end do
! ʲԤ
     tmpn(j)=sqrt(vec_dot( v(:,j), v(:,j) ))
     do i=1,nx
        v(i,j)=v(i,j)/tmpn(j)
     end do
  end do

end subroutine schumit_norm

!-----------------------------------------
!-----------------------------------------

!-- ʲ, ȯ !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine eigen_power_all( a, lambda, eigen_vec, eps )
!  ٤ˡѤ, a ˤĤƤƤθͭͤȤȼͭ٥ȥ
!  ׻롼.
  implicit none
  real, intent(in) :: a(:,:)  ! ͭͤ [ 1 Ǥ]
  real, intent(inout) :: lambda(size(a,1))  ! a θͭ
  real, intent(inout) :: eigen_vec(size(a,1),size(a,2))  ! lambda(i) бͭ٥ȥ, Ǥͭ lambda(i) бƤ.
  real, intent(in), optional :: eps  ! ȿˡμ«
  integer :: n

  n=size(a,1)




end subroutine

!-----------------------------------------
! ʲ, private °դ롼
!-----------------------------------------

subroutine Pivot_part( a, b )
! гʬ¸ߤ를ԥܥåƥ󥰤ˤä󥼥֤ͤ.
  implicit none
  real, intent(inout) :: b(:)  ! ԥܥåƥ󥰤ȤȤ֤뱦ե٥ȥ
  real, intent(inout) :: a(size(b),size(b))  ! ԥܥåƥ󥰤Ԥ ( 1 ǤԤб)
  real :: tmp(size(b))  ! ؤΰ
  real :: tmpv  ! ؤȼ b(i) 򤵤ѿ
  integer :: i, j, k
  integer :: nx

  nx=size(b)

  do i=1,nx
     if(a(i,i)==0.0)then
        do j=1,nx  !  do  j=1 ֤Ԥõ
! ʲȽ̼ϼ̤
! a(i,i)==0 ʤΤ, j ܤ i 󤬥ǤʤԤõ a(j,i)/=0.
!  j ܤؤ뤬, ؤȤ,  i ܤˤä j ؤȤ
! j ܤгʬ a(j,j) ˤʤʤ褦 a(i,j)/=0  j ꤹ.
           if(a(i,j)/=0.0.and.a(j,i)/=0.0.and.i/=j)then
              do k=1,nx  ! ºݤؤ
                 tmp(k)=a(i,k)
                 a(i,k)=a(j,k)
                 a(j,k)=tmp(k)
              end do
              tmpv=b(i)
              b(i)=b(j)
              b(j)=tmpv
              exit
           end if
        end do
     end if
  end do

end subroutine Pivot_part

!-----------------------------------------

real function errata(x1, x2, n)
  implicit none
  real, intent(in) :: x1  ! 
  real, intent(in) :: x2  ! 
  integer, intent(in) :: n  ! μ (n=1 : и, n=2 : и)

  if(n==1)then
     if(abs(x1)==0.0)then
        errata=(abs(x1-x2))/(abs(x2))
     else
        errata=(abs(x1-x2))/(abs(x1))
     end if
  else
     errata=abs(x1-x2)
  end if

  return
end function errata

!-----------------------------------------

real function vec_dot( u, v )
! ǤդμΥ٥ȥѤ׻
  implicit none
  real, intent(in) :: u(:)
  real, intent(in) :: v(size(u))
  integer :: i, nx
  real :: tmp

  nx=size(u)
  tmp=0.0

  do i=1,nx
     tmp=tmp+u(i)*v(i)
  end do

  vec_dot=tmp

  return
end function

!-----------------------------------------

real function sum_sq( a )
! Ǥդ 1 Ǥγʬ 2 ¤׻.
  implicit none
  real, intent(in) :: a(:)
  integer :: i, n
  real :: tmp

  n=size(a)
  tmp=0.0

  do i=1,n
     tmp=tmp+a(i)**2
  end do

  sum_sq=tmp

  return
end function sum_sq

!-----------------------------------------

end module Matrix_Calc
