program diffusion
  use ffts  ! FFT 롼
  use file_operate  ! ̥ե
  use Math_Const
  use gtool_history
  implicit none
  integer :: nx  ! x ȿ
  real :: dt  ! ׻ֳִ
  integer :: nt  ! ׻ƥå׿
  real :: xmin  ! x ɸü
  real :: dx  ! x ɸʻҴֳ
  integer :: j, k
  real, allocatable, dimension(:) :: x  ! x ɸ
  real, allocatable, dimension(:) :: y  ! 顼ѿ
  real, allocatable, dimension(:) :: time  ! 
  real, allocatable, dimension(:,:) :: amp  ! 
  complex, allocatable, dimension(:) :: fm1  ! ڥȥ
  complex, allocatable, dimension(:) :: fm2  ! ڥȥ
  complex, allocatable, dimension(:) :: fm_tmp  ! ׽
  complex, parameter :: i=(0.0,1.0)

  namelist /input /nx,dt,nt,xmin,dx
  read(5,input)

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

  allocate(x(0:2*nx))
  allocate(y(0:2*nx))
  allocate(time(nt+1))
  allocate(amp(0:2*nx,nt+1))
  allocate(fm1(0:2*nx))
  allocate(fm2(0:2*nx))
  allocate(fm_tmp(0:2*nx))

  x=(/((xmin+dx*real(j)),j=0,2*nx)/)
  time=(/((dt*real(j-1)),j=1,nt+1)/)

  do j=0,2*nx
!     y(j)=sin(x(j))
     y(j)=exp(-(x(j)-0.5*real(2*nx+1)*dx)**2)
     amp(j,1)=y(j)
     fm_tmp(j)=y(j)
  end do

  call ffttp_1d( 2*nx+1, fm_tmp, fm1, 'r', 'o' )

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='diffusion.nc', title='spectral advecting model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/2*nx+1,nt+1/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=0.0, interval=real(nt*dt) )

  call HistoryPut( 'x', x )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='amp', dims=(/'x','t'/), &
    & longname='amplitude', units='1', xtype='float')

!-- ʬ
  do j=1,nt
!-- CR ˡǻʬ
     fm2(0)=fm1(0)
     do k=1,nx
        fm2(k)=((1.0-0.5*dt*real(k)**2)/  &
  &            (1.0+0.5*dt*real(k)**2))*fm1(k)
        fm1(k)=fm2(k)  ! ƥåפϤ
     end do

     do k=1,nx
        fm2(nx+k)=conjg(fm2(nx-k+1))  ! ׻פ˷̤Ϥ
     end do

     call ffttp_1d( 2*nx+1, fm2, fm_tmp, 'i', 'o' )

     do k=0,2*nx  ! ¿ؤѴ
        y(k)=real(fm_tmp(k))
        amp(k,j+1)=y(k)
     end do

  end do

  call HistoryPut( 'amp', amp )                         ! ѿ

  call HistoryClose

end program
