program thermo  ! thermo طδؿǧ
  use Thermo_Function
  implicit none
  integer, parameter :: dl=2
  real :: temp, pres, rh, rho, es, qv, tmpv, pt, sh, tv, ptv

  write(*,*) "pressure [hPa]"
  read(*,*) pres
  write(*,*) "temperature [K]"
  read(*,*) temp
  write(*,*) "Relative Humidity [%]"
  read(*,*) rh

  pres=pres*100.0
  es=RHT_2_e(rh,temp,dl)
  qv=eP_2_qv(es,pres,dl)
  rho=TP_2_rho(temp,pres,dl)
  pt=theta_dry(temp,pres,dl)
  sh=qv_2_sh(qv,dl)

  tmpv=tetens(temp,dl)
  tmpv=goff_gratch(temp,dl)
  tmpv=goff_gratch_i(temp,dl)
  tmpv=es_Bolton(temp,dl)
  tmpv=es_TD(es,dl)
  tmpv=LH(temp,dl)
  tmpv=eP_2_qv(es,pres,dl)
  tmpv=TP_2_qvs(temp,pres,dl)
  tmpv=qvP_2_e(qv,pres,dl)
  tmpv=theta_dry(temp,pres,dl)
  tmpv=theta_moist(temp,pres,qv,dl)
  tmpv=thetaP_2_T(temp,pres,dl)
  tmpv=thetaT_2_P(pt,temp,dl)
  tmpv=TqvP_2_TLCL(temp,qv,pres,dl)
  tmpv=thetae_Bolton(temp,qv,pres,dl)
  tmpv=thetaes_Bolton(temp,pres,dl)
  tmpv=TqvP_2_thetae(temp,qv,pres,dl)
  tmpv=TqvP_2_thetaes(temp,pres,dl)
  tmpv=RHT_2_e(rh,temp,dl)
  tmpv=eT_2_RH(es,temp,dl)
  tmpv=RHTP_2_qv(rh,temp,pres,dl)
  tmpv=qvTP_2_RH(qv,temp,pres,dl)
  tv=qvT_2_Tv(qv,temp,dl)
  tmpv=qvTv_2_T(qv,tv,dl)
  tmpv=TvT_2_qv(tv,temp,dl)
  ptv=TqvP_2_thetav(temp,qv,pres,dl)
  tmpv=thetavqvP_2_T(ptv,qv,pres,dl)
  tmpv=TthetavP_2_qv(temp,ptv,pres,dl)
  tmpv=exner_func_dry(pres,dl)
  tmpv=hypsometric_form(pres, 0.0, temp, 100.0,dl)
  tmpv=rhoT_2_P(rho,temp,dl)
  tmpv=rhoP_2_T(rho,pres,dl)
  tmpv=TP_2_rho(temp,pres,dl)
  tmpv=get_gamma_d(dl)
  tmpv=sh_2_qv(qv,dl)
  tmpv=Cefp(qv,dl)
  tmpv=Cl(temp,dl)
  tmpv=Tq_2_Trho(temp,qv,dl=dl)
  tmpv=esi_Emanuel(temp,dl)
  tmpv=thetae_Emanuel(temp,qv,pres,dl=dl)
  tmpv=thetaw_Emanuel(temp,qv,pres,dl=dl)
  tmpv=moist_laps_temp(pres,temp,pres-10000.0,dl)

end program
