module Dcl_Automatic  ! Dclf90 ưǹԤ⥸塼

contains

subroutine Dcl_2D_cont_shade( outname, x, y, contour, shade, cont_min, cont_max, shade_min, shade_max, x_title, y_title, form_typec, form_types, viewx_min, viewx_max, viewy_min, viewy_max )
  ! 2  2 ѿȥ顼ɤ褹.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if
!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call GRFIG
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  call DclDrawContour( contour )

  call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )

end subroutine

!---------------------------------------------------------

subroutine tone_bar( color_num, shade_min, shade_max, vx_min, vx_max, vy_min, vy_max, form_types )  ! ˥ȡСư
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ뿧ο
  real, intent(in) :: shade_min  ! Ǿ
  real, intent(in) :: shade_max  ! 
  real, intent(in) :: vx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in) :: vx_max  ! ӥ塼ݡȤ x κ
  real, intent(in) :: vy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in) :: vy_max  ! ӥ塼ݡȤ y κ
  character(6), intent(in) :: form_types  ! ٥եޥå
  integer :: k
  real :: pi(2,color_num+1)
  real :: dp

  call GRFIG
  call DclSetWindow(  0.0, 1.0, shade_min, shade_max )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  dp = (shade_max-shade_min)/color_num

  do k=1,color_num+1
     PI(1,K) = shade_min + (K-1)*DP
     PI(2,K) = shade_min + (K-1)*DP
  end do

  call DclShadeContourEx( PI )
  CALL SLPVPR( 3 )
  CALL UZLSET( 'LABELYR', .TRUE. )
  CALL UZLSET( 'LABELYL', .FALSE. )
  CALL UYSFMT( form_types )
  CALL UYAXDV( 'R', (shade_max-shade_min)/10.0, (shade_max-shade_min)/5.0 )
  CALL UYAXDV( 'L', (shade_max-shade_min)/10.0, (shade_max-shade_min)/5.0 )

end subroutine

!-----------------------------------------------------------

subroutine undef_CReSS2Dcl( nx, ny, nz, val )  ! CReSS ̤ͤ Dcl ̤ͤѴ롼
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  use dcl
  implicit none
  integer, intent(in) :: nx  !  1 Ǥǿ
  integer, intent(in) :: ny  !  2 Ǥǿ
  integer, intent(in) :: nz  !  3 Ǥǿ
  real, intent(inout) :: val(nx,ny,nz)  ! Ѵ
  integer :: i, j, k  ! 
  real :: RMISS, undef  ! ̤

!-- »ͽ ---
!-- Dcl ¦ undef ͥå
      CALL GLRGET( 'RMISS', RMISS )
      CALL GLLSET( 'LMISS', .TRUE. )

!-- CReSS ¦ undef ͥå
      call undef_get( undef )
write(*,*) "undef=", undef

  do k=1,nz
  do j=1,ny
     do i=1,nx
        if(val(i,j,k)==undef)then
           val(i,j,k)=RMISS
        end if
     end do
  end do
  end do
    

end subroutine

!--------------------------------------------------------

subroutine color_setting( color_num, val_min, val_max )  ! 顼ޥåפοȿͤб뼫ư롼
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ륫顼μ
  real, intent(in) :: val_min  ! 顼κǾ
  real, intent(in) :: val_max  ! 顼κ
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  integer :: ipat
  real :: dv  ! 顼ޥåפбͤ
  real :: tlev1, tlev2

  map_num=14

  call sgscmn(map_num)

  dv=(val_max-val_min)/color_num
  do k=1,color_num
     TLEV1=val_min+(k-1)*dv
     TLEV2=TLEV1+dv
     IPAT=(9+k)*1000+199
     CALL UESTLV( TLEV1, TLEV2, IPAT )
  end do


end subroutine

!---------------------------------------------------

subroutine undef_get( undef )  ! CReSS ΥǥեȤ̤ͤ롼
  implicit none
  real, intent(inout) :: undef  ! ̤

  undef = -1.0e+35

end subroutine


subroutine format_make( val_type, order_num, form_name, frac_num )  ! ͥ٥ѥեޥåȺ롼
  implicit none
  character(1), intent(in) :: val_type  ! ٥벽ѿη : f = ¿(ץꤹ), i = 
  character(1), intent(in) :: order_num  ! ɽ
  character(1), intent(in), optional :: frac_num  ! ¿ΤȤΤ, 
  character(*), intent(out) :: form_name

  select case(val_type)
  case('f')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('F')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('i')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  case('I')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  end select

end subroutine format_make

end module
