module analy  ! ׻̥ǡѲϥ⥸塼

contains

subroutine div( x, y, u, v, val, undeff, hx, hy )
! 2ȯ׻롼
! 
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{u_{i+1,j}-u_{i-1,j}}{2dx} + \frac{v_{i,j+1}-v_{i,j-1}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ, grad_1d 롼Ȥ߹碌뤳ȤǷ׻Ԥ.
! du/dx = grad_1d( x, u, dudx ), dv/dy = grad_1d( y, v, dvdy ) ȤǷ׻Ԥ,
! ⼫ưŪ˷׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))
  real :: dudx(size(x),size(y)), dvdy(size(x),size(y))
  real :: tmpu(size(x),size(y)), tmpv(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- ѿ.

  if(present(hx).and.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.or.v(i,j)/=undeff)then
              tmpu(i,j)=scaley(i,j)*u(i,j)
              tmpv(i,j)=scalex(i,j)*v(i,j)
           else
              tmpu(i,j)=undeff
              tmpv(i,j)=undeff
           end if
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpv(i,:), dvdy(i,:), undeff )
     end do
     do j=1,ny
        call grad_1d( x, tmpu(:,j), dudx(:,j), undeff )
     end do

     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.or.v(i,j)/=undeff)then
              val(i,j)=(dudx(i,j)+dvdy(i,j))/(scalex(i,j)*scaley(i,j))
           else
              val(i,j)=undeff
           end if
        end do
     end do

  else

     do j=1,ny
        do i=1,nx
           tmpu(i,j)=scaley(i,j)*u(i,j)
           tmpv(i,j)=scalex(i,j)*v(i,j)
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpv(i,:), dvdy(i,:) )
     end do
     do j=1,ny
        call grad_1d( x, tmpu(:,j), dudx(:,j) )
     end do

     do j=1,ny
        do i=1,nx
           val(i,j)=(dudx(i,j)+dvdy(i,j))/(scalex(i,j)*scaley(i,j))
        end do
     end do
  end if

end subroutine div

!-----------------------------------------
!-----------------------------------------

subroutine curl( x, y, u, v, val, undeff, hx, hy, ord )
! 2 ٷ׻롼
!
! x, y μμ㤤ɬ¤٤뤳.
!
! u, v ϶ִθ֤, Ǥդ2٤׻ǽ
! , du/dz-dw/dx ׻ȤΤ, (x,z,u,w) ν֤, ord ץ false.
!
! $\frac{\partial v}{\partial x} -\frac{\partial u}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{v_{i,j+1}-v_{i,j-1}}{2dx} -\frac{u_{i+1,j}-u_{i-1,j}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ grad_1d ʬ׻ôΤ, η׻⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  logical, intent(in),  optional :: ord  ! ʬν֤ؤ륪ץ.
                 ! true ʤ, ؤʤ, false ʤ, ؤ.
                 ! ǥեȤ true, du/dz-dw/dx ׻ȤΤѤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  logical :: order
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))
  real :: dvdx(size(x),size(y)), dudy(size(x),size(y))
  real :: tmpu(size(x),size(y)), tmpv(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- ѿ.

  if(present(hx).and.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.or.v(i,j)/=undeff)then
              tmpu(i,j)=scalex(i,j)*u(i,j)
              tmpv(i,j)=scaley(i,j)*v(i,j)
           else
              tmpu(i,j)=undeff
              tmpv(i,j)=undeff
           end if
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpu(i,:), dudy(i,:), undeff )
     end do
     do j=1,ny
        call grad_1d( x, tmpv(:,j), dvdx(:,j), undeff )
     end do

     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.or.v(i,j)/=undeff)then
              val(i,j)=(dvdx(i,j)-dudy(i,j))/(scalex(i,j)*scaley(i,j))
           else
              val(i,j)=undeff
           end if
        end do
     end do

  else

     do j=1,ny
        do i=1,nx
           tmpu(i,j)=scalex(i,j)*u(i,j)
           tmpv(i,j)=scaley(i,j)*v(i,j)
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpu(i,:), dudy(i,:) )
     end do
     do j=1,ny
        call grad_1d( x, tmpv(:,j), dvdx(:,j) )
     end do

     do j=1,ny
        do i=1,nx
           val(i,j)=(dvdx(i,j)-dudy(i,j))/(scalex(i,j)*scaley(i,j))
        end do
     end do
  end if

!-- žν֤դˤ륪ץ
!-- false ʤ, ֤ؤƽϤ.

  if(present(ord))then
     order=ord
  else
     order=.true.
  end if

  if(order.eqv..false.)then
     do j=1,ny
        do i=1,nx
           val(i,j)=-val(i,j)
        end do
     end do
  end if

end subroutine curl

!-----------------------------------------
!-----------------------------------------

subroutine div_3d( x, y, z, u, v, w, val, undeff, hx, hy, hz )
! 3ȯ׻롼
!
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} +\frac{\partial w}{\partial z} $ 
! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥȯ
! $\frac{u_{i+1,j,k}-u_{i-1,j,k}}{2dx} + \frac{v_{i,j+1,k}-v_{i,j-1,k}}{2dy} + \frac{w_{i,j,k+1}-w_{i,j,k-1}}{2dz} $
! ȤǤ. Ѥ 3 ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ, grad_1d 롼󤬷׻ԤΤ, ν⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 3 ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  real, dimension(size(x),size(y),size(z)) :: dudx, dvdy, dwdz
  real, dimension(size(x),size(y),size(z)) :: tmpu, tmpv, tmpw

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ѿ.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)/=undeff.or.v(i,j,k)/=undeff.or.w(i,j,k)/=undeff)then
                 tmpu(i,j,k)=scaley(i,j,k)*scalez(i,j,k)*u(i,j,k)
                 tmpv(i,j,k)=scalez(i,j,k)*scalex(i,j,k)*v(i,j,k)
                 tmpw(i,j,k)=scalex(i,j,k)*scaley(i,j,k)*w(i,j,k)
              else
                 tmpu(i,j,k)=undeff
                 tmpv(i,j,k)=undeff
                 tmpw(i,j,k)=undeff
              end if
           end do
        end do
     end do

     do k=1,nz
        do i=1,nx
           call grad_1d( y, tmpv(i,:,k), dvdy(i,:,k), undeff )
        end do
     end do
     do k=1,nz
        do j=1,ny
           call grad_1d( x, tmpu(:,j,k), dudx(:,j,k), undeff )
        end do
     end do
     do j=1,ny
        do i=1,nx
           call grad_1d( z, tmpw(i,j,:), dwdz(i,j,:), undeff )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)/=undeff.or.v(i,j,k)/=undeff.or.w(i,j,k)/=undeff)then
                 val(i,j,k)=(dudx(i,j,k)+dvdy(i,j,k)+dwdz(i,j,k))/  &
  &                         (scalex(i,j,k)*scaley(i,j,k)*scalez(i,j,k))
              else
                 val(i,j,k)=undeff
              end if
           end do
        end do
     end do

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmpu(i,j,k)=scaley(i,j,k)*scalez(i,j,k)*u(i,j,k)
              tmpv(i,j,k)=scalez(i,j,k)*scalex(i,j,k)*v(i,j,k)
              tmpw(i,j,k)=scalex(i,j,k)*scaley(i,j,k)*w(i,j,k)
           end do
        end do
     end do

     do k=1,nz
        do i=1,nx
           call grad_1d( y, tmpv(i,:,k), dvdy(i,:,k) )
        end do
     end do
     do k=1,nz
        do j=1,ny
           call grad_1d( x, tmpu(:,j,k), dudx(:,j,k) )
        end do
     end do
     do j=1,ny
        do i=1,nx
           call grad_1d( z, tmpw(i,j,:), dwdz(i,j,:) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=(dudx(i,j,k)+dvdy(i,j,k)+dwdz(i,j,k))/  &
  &                      (scalex(i,j,k)*scaley(i,j,k)*scalez(i,j,k))
           end do
        end do
     end do

  end if

end subroutine div_3d

!-----------------------------------------
!-----------------------------------------

subroutine rotate( x, y, z, u, v, w, zeta, eta, xi, undeff, hx, hy, hz )
! 3 ٤׻.
! ν֤ϱϤ x, y, z ΥǥȺɸ,
! б٥ȥʬ u, v, w ,
! б٥٥ȥʬ zeta, eta, xi ׻.
! ¼ grad_1d ׻ôΤ, ν⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: zeta(size(x),size(y),size(z))  ! ٥٥ȥ x ʬ
  real, intent(inout) :: eta(size(x),size(y),size(z))  ! ٥٥ȥ y ʬ
  real, intent(inout) :: xi(size(x),size(y),size(z))  ! ٥٥ȥ z ʬ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ѿ.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:), undeff,  &
  &                hx=scaley(i,:,:), hy=scalez(i,:,:) )
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:),  &
  &                hx=scaley(i,:,:), hy=scalez(i,:,:) )
     end do
!$omp end do
!$omp end parallel

  end if

! y ˿ľ̾Ǥ y α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), undeff, ord=.false., &
  &                hx=scalex(:,j,:), hy=scalez(:,j,:) )
     end do
!$omp end do
!$omp end parallel

  else
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), ord=.false.,  &
  &                hx=scalex(:,j,:), hy=scalez(:,j,:) )
     end do
!$omp end do
!$omp end parallel

  end if

! z ˿ľ̾Ǥ z α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k), undeff,  &
  &                hx=scalex(:,:,k), hy=scaley(:,:,k) )
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k),  &
  &                hx=scalex(:,:,k), hy=scaley(:,:,k) )
     end do

!$omp end do
!$omp end parallel
  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine grad_1d( x, u, val, undef, hx )
! 1 Υ顼ѿθۤ׻
! $\frac{\partial p}{\partial x} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}-p_{i-1}}{2dx} $
! ȤǤ. Ѥ 1 ۤ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
  implicit none
  real, intent(in) :: x(:)  ! ֺɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x))  ! x Υ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x))

  nx=size(x)

  if(present(hx))then
     do i=1,nx
        scalex(i)=hx(i)
     end do
  else
     do i=1,nx
        scalex(i)=1.0
     end do
  end if

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef)then
           val(i)=undef
        else
           val(i)=(u(i+1)-u(i-1))/(scalex(i)*(x(i+1)-x(i-1)))
        end if
     end do
!-- ǡΤʤξüν ---
     if(u(1)==undef.or.u(2)==undef)then
        val(1)=undef
     else
        val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
     end if
     if(u(nx)==undef.or.u(nx-1)==undef)then
        val(nx)=undef
     else
        val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
     end if
  else
     do i=2,nx-1
        val(i)=(u(i+1)-u(i-1))/(scalex(i)*(x(i+1)-x(i-1)))
     end do
!-- ǡΤʤξüν ---
     val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
     val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
  end if

end subroutine grad_1d



subroutine grad_vec_2d( x, y, u, valx, valy, undeff, hx, hy )
  ! 1 顼ۤΥ롼Ѥ 2 ۤΥ٥ȥ׻
  ! $\nabla _hp =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j}-p_{i-1,j}}{2dx} ,\; \frac{p_{i,j+1}-p_{i,j-1}}{2dy} \right) $
  ! ȤǤ. Ѥ2ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! Ѥ 1 ۷׻롼 2 ƤӽФȤˤƤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: u(size(x),size(y))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))

  nx=size(x)
  ny=size(y)

  if(present(hx).or.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

  if(present(undeff))then
     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i), undeff)
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:), undeff)
     end do

     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff)then
              valx(i,j)=valx(i,j)/scalex(i,j)
              valy(i,j)=valy(i,j)/scaley(i,j)
!-- , else ʤΤ, grad_1d 롼ǤǤ undeff äƤ뤫ƱȤ
!-- ʤΤ, 䰦.
           end if
        end do
     end do

  else

     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i) )
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:) )
     end do

     do j=1,ny
        do i=1,nx
           valx(i,j)=valx(i,j)/scalex(i,j)
           valy(i,j)=valy(i,j)/scaley(i,j)
        end do
     end do

  end if

end subroutine grad_vec_2d



subroutine grad_vec_3d( x, y, z, u, valx, valy, valz, undeff, hx, hy, hz )
  ! 1 顼ۤΥ롼Ѥ 3 ۤΥ٥ȥ׻.
  ! $\nabla p =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} ,\; \frac{\partial p}{\partial z} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j,k}-p_{i-1,j,k}}{2dx} ,\; \frac{p_{i,j+1,k}-p_{i,j-1,k}}{2dy} ,\; \frac{p_{i,j,k+1}-p_{i,j,k-1}}{2dz} \right) $
  ! ȤǤ. Ѥ 3 ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! Ѥ 1 ۷׻롼 3 ƤӽФȤˤƤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valz(size(x),size(y),size(z))  ! ׻줿 z  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then
     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i),undeff)
        end do
     end do

     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i),undeff)
        end do
     end do

     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:),undeff)
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)/=undeff)then
                 valx(i,j,k)=valx(i,j,k)/scalex(i,j,k)
                 valy(i,j,k)=valy(i,j,k)/scaley(i,j,k)
                 valz(i,j,k)=valz(i,j,k)/scalez(i,j,k)
              end if
           end do
        end do
     end do

  else

     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i))
        end do
     end do

     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i))
        end do
     end do

     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:))
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              valx(i,j,k)=valx(i,j,k)/scalex(i,j,k)
              valy(i,j,k)=valy(i,j,k)/scaley(i,j,k)
              valz(i,j,k)=valz(i,j,k)/scalez(i,j,k)
           end do
        end do
     end do

  end if

end subroutine grad_vec_3d

!-----------------------------------------
!-----------------------------------------

subroutine laplacian_1d( x, u, val, undef )
! 1 Υ顼ѿΥץ饷׻
! $\frac{\partial ^2p}{\partial x^2} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}+p_{i-1}-2p_i}{dx^2} $
! ȤǤ. Ѥ 1 ץ饷׻.
! ǡ­ʤΰǤ, undef .
! option  undef Ƥʤ, 0.0 .
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x))
  real :: tmpu(size(x))

  nx=size(x)

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef.or.u(i)==undef)then
           val(i)=undef
        else
           val(i)=4.0*(u(i+1)+u(i-1)-2.0*u(i))/((x(i+1)-x(i-1))**2)
        end if
     end do
!-- ǡΤʤξüν ---
!     if(u(1)==undef.or.u(2)==undef)then
!        val(1)=undef
!     else
!        val(1)=(u(2)-u(1))/dx
!     end if
!     if(u(nx)==undef.or.u(nx-1)==undef)then
!        val(nx)=undef
!     else
!        val(nx)=(u(nx)-u(nx-1))/dx
!     end if
     val(1)=undef
     val(nx)=undef
  else
     do i=2,nx-1
        val(i)=4.0*(u(i+1)+u(i-1)-2.0*u(i))/((x(i+1)-x(i-1))**2)
     end do
!-- ǡΤʤξüν ---
!     val(1)=(u(2)-u(1))/dx
!     val(nx)=(u(nx)-u(nx-1))/dx
     val(1)=0.0
     val(nx)=0.0
  end if

end subroutine laplacian_1d

!-----------------------------------------
!-----------------------------------------


subroutine abst(x,y,z,dis)  ! 3 ٥ȥͤ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dis(size(x,1),size(x,2),size(x,3))  ! Ǥͥ٥ȥ
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

!$omp parallel do shared(dis,x,y,z) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dis(i,j,k)=sqrt(x(i,j,k)**2+y(i,j,k)**2+z(i,j,k)**2)
        end do
     end do
  end do
!$omp end parallel do

end subroutine abst


subroutine radius(xp,yp,zp,x,y,z,rad)
  ! ֤εΥ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: xp  ! 濴ֺɸ x ʬ
  real, intent(in) :: yp  ! 濴ֺɸ y ʬ
  real, intent(in) :: zp  ! 濴ֺɸ z ʬ
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: z(:)  ! z ΰֺɸ
  real, intent(inout) :: rad(size(x),size(y),size(z))  ! Υ
  integer :: i, j, k, nx, ny, nz

  nx=size(x)
  ny=size(y)
  nz=size(z)

!$omp parallel do shared(rad,x,y,z,xp,yp,zp) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           rad(i,j,k)=sqrt((x(i)-xp)**2+(y(j)-yp)**2+(z(k)-zp)**2)
        end do
     end do
  end do
!$omp end parallel do


end subroutine radius


subroutine Rangular_moment(xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j, nx, ny
  real :: tmp(size(x),size(y),1)

  nx=size(x)
  ny=size(y)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j,1)=x(i)-xp
        yyp(i,j,1)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)

end subroutine Rangular_moment


subroutine Aangular_moment(xp,yp,x,y,u,v,f,mome)
! Ǥդޤгѱư̤׻롼
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
!
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: f(size(x),size(y))  !  i,j ǤΥꥪѥ᡼
  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j, nx, ny
  real :: tmp(size(x),size(y),1), rp(size(x),size(y)), tmp1(1)

  nx=size(x)
  ny=size(y)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j,1)=x(i)-xp
        yyp(i,j,1)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
  call radius(xp,yp,0.0,x,y,tmp1,rp)

!$omp parallel do shared(mome,f,rp) private(i,j)
  do j=1,ny
     do i=1,nx
        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
     end do
  end do
!$omp end parallel do

end subroutine Aangular_moment

subroutine dot_prod(x,y,z,u,v,w,dot,undeff)
  ! 2٥ȥѷ׻롼
  ! פ, 2 ǤѤ׻뤳Ȥǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dot(size(x,1),size(x,2),size(x,3))  ! 
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 dot(i,j,k)=undeff
              else
                 dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do
  else
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine dot_prod


subroutine vec_prod(x,y,z,u,v,w,vecx,vecy,vecz,undeff)
  ! 2٥ȥγѷ׻롼
  ! ǿפ뤳Ȥ 2 Ѥ׻ǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: vecx(size(x,1),size(x,2),size(x,3))  ! Ѥ x ʬ
  real, intent(inout) :: vecy(size(x,1),size(x,2),size(x,3))  ! Ѥ y ʬ
  real, intent(inout) :: vecz(size(x,1),size(x,2),size(x,3))  ! Ѥ z ʬ
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 vecx(i,j,k)=undeff
                 vecy(i,j,k)=undeff
                 vecz(i,j,k)=undeff
              else
                 vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
                 vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
                 vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do

  else

!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
              vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
              vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine vec_prod

!-----------------------------------------
!-----------------------------------------

subroutine turb_visc( signal, x, y, z, u, v, w, rho, nuh, nuv, val, undef, hx, hy, hz, sfctau )
! ǥȺɸϤˤήǴ׻.
  implicit none
  character(1) :: signal  ! ǥȺɸϤβܤήʬȽꤹ.
                  ! [1] = ǥȺɸϤˤ x ɸʬ ( u ʬ)
                  ! [2] = ǥȺɸϤˤ y ɸʬ ( v ʬ)
                  ! [3] = ǥȺɸϤˤ z ɸʬ ( w ʬ)
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfctau(size(x),size(y))  ! ɽ̤Υեå
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  character(1) :: signaltau(3)
  integer :: id
  real, dimension(size(x),size(y),size(z)) :: tmp
  real, dimension(size(x),size(y)) :: stau
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  signaltau=(/ '1', '2', '3' /)
  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  do id=1,3
     if(present(sfctau))then
        stau(:,:)=sfctau(:,:)
        call Reynolds_stress( signal//signaltau(id),  &
  &          x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &          hx=scalex, hy=scaley, hz=scalez, sfctau=stau )
     else
        call Reynolds_stress( signal//signaltau(id),  &
  &          x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &          hx=scalex, hy=scaley, hz=scalez )
     end if
  end do

!-- ήη׻, 3 ȯԤȤǤ뤿,
!-- ʲǤ, div_3d ѤƷ׻Ԥ.

  call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &            hx=scalex, hy=scaley, hz=scalez )

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine Reynolds_stress( signal, x, y, z, u, v, w, rho, nuh, nuv, val, undef, hx, hy, hz, sfctau )
! ǥȺɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfctau(size(x),size(y))  ! ǥǲؤǤαϤͿƤ, ͤ.
        ! ͤϲ⤻, ñ val κǲؤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: tau1, tau2, tau3  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  integer :: signaltau
  real :: stau(size(x),size(y))
  real :: sxx(size(x),size(y),size(z)), nu(size(x),size(y),size(z))
  real, dimension(size(x),size(y),size(z)) :: ddx, ddy, ddz
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0
  stau=0.0

!-- ɽ̥եåͤ.

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:,:)=sfctau(:,:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

!-- ϥƥ󥽥η׻
  call deform_tensor( signal, x, y, z, u, v, w, sxx,  &
  &                   hx=scalex, hy=scaley, hz=scalez )

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
     if(signal(2:2)=='3')then
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuv(i,j,k)
              end do
           end do
        end do
     else
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuh(i,j,k)
              end do
           end do
        end do
     end if
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     if(signal(2:2)=='3')then
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuv(i,j,k)
              end do
           end do
        end do
     else
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuh(i,j,k)
              end do
           end do
        end do
     end if
  end if

  if(signal(1:2)=='11')then
     call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do
  end if

  if(signal(1:2)=='22')then
     call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do
  end if

  if(signal(1:2)=='33')then
     call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuv(i,j,k)
           end do
        end do
     end do
  end if

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do j=1,ny
        do i=1,nx
           val(i,j,1)=stau(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           val(i,j,1)=rho(1)*nu(i,j,1)*(sxx(i,j,1)-(2.0/3.0)*val(i,j,1))
        end do
     end do
  end if

  do k=2,nz
     do j=1,ny
        do i=1,nx
           val(i,j,k)=rho(k)*nu(i,j,k)*(sxx(i,j,k)-(2.0/3.0)*val(i,j,k))
        end do
     end do
  end do

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine deform_tensor( signal, x, y, z, u, v, w, val, undef, hx, hy, hz )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: tau1, tau2, tau3  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  real, dimension(size(x),size(y),size(z)) :: tmpu, tmpv, tmpw
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  real, dimension(size(x),size(y),size(z)) :: ddx, ddy, ddz

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then

     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmpu(i,j,k)=u(i,j,k)/scalex(i,j,k)
              tmpv(i,j,k)=v(i,j,k)/scaley(i,j,k)
           end do
        end do
     end do

     do k=1,nz
        do j=1,ny
           call grad_1d( x, tmpv(:,j,k), ddx(:,j,k) )
        end do
        do i=1,nx
           call grad_1d( y, tmpu(i,:,k), ddy(i,:,k) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=ddx(i,j,k)*scaley(i,j,k)/scalex(i,j,k)+  &
  &                      ddy(i,j,k)*scalex(i,j,k)/scaley(i,j,k)
           end do
        end do
     end do

  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then

     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmpv(i,j,k)=v(i,j,k)/scaley(i,j,k)
              tmpw(i,j,k)=w(i,j,k)/scalez(i,j,k)
           end do
        end do
     end do

     do i=1,nx
        do k=1,nz
           call grad_1d( y, tmpw(i,:,k), ddy(i,:,k) )
        end do
        do j=1,ny
           call grad_1d( z, tmpv(i,j,:), ddz(i,j,:) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=ddy(i,j,k)*scalez(i,j,k)/scaley(i,j,k)+  &
  &                      ddz(i,j,k)*scaley(i,j,k)/scalez(i,j,k)
           end do
        end do
     end do

  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then

     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmpu(i,j,k)=u(i,j,k)/scalex(i,j,k)
              tmpw(i,j,k)=w(i,j,k)/scalez(i,j,k)
           end do
        end do
     end do

     do j=1,ny
        do i=1,nx
           call grad_1d( z, tmpu(i,j,:), ddz(i,j,:) )
        end do
        do k=1,nz
           call grad_1d( x, tmpw(:,j,k), ddx(:,j,k) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=ddz(i,j,k)*scalex(i,j,k)/scalez(i,j,k)+  &
  &                      ddx(i,j,k)*scalez(i,j,k)/scalex(i,j,k)
           end do
        end do
     end do

  end if

  if(signal(1:2)=='11')then

     do k=1,nz
        do i=1,nx
           call grad_1d( y, scalex(i,:,k), ddy(i,:,k) )
        end do
     end do

     do j=1,ny
        do i=1,nx
           call grad_1d( z, scalex(i,j,:), ddz(i,j,:) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           call grad_1d( x, u(:,j,k), ddx(:,j,k) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=2.0*(ddx(i,j,k)+ddy(i,j,k)*v(i,j,k)/scaley(i,j,k)+  &
  &                           ddz(i,j,k)*w(i,j,k)/scalez(i,j,k))/scalex(i,j,k)
           end do
        end do
     end do

  end if

  if(signal(1:2)=='22')then

     do k=1,nz
        do i=1,nx
           call grad_1d( y, v(i,:,k), ddy(i,:,k) )
        end do
     end do

     do j=1,ny
        do i=1,nx
           call grad_1d( z, scaley(i,j,:), ddz(i,j,:) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           call grad_1d( x, scaley(:,j,k), ddx(:,j,k) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=2.0*(ddy(i,j,k)+ddz(i,j,k)*w(i,j,k)/scalez(i,j,k)+  &
  &                           ddx(i,j,k)*u(i,j,k)/scalex(i,j,k))/scaley(i,j,k)
           end do
        end do
     end do

  end if

  if(signal(1:2)=='33')then

     do k=1,nz
        do i=1,nx
           call grad_1d( y, scalez(i,:,k), ddy(i,:,k) )
        end do
     end do

     do j=1,ny
        do i=1,nx
           call grad_1d( z, w(i,j,:), ddz(i,j,:) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           call grad_1d( x, scalez(:,j,k), ddx(:,j,k) )
        end do
     end do

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=2.0*(ddz(i,j,k)+ddx(i,j,k)*u(i,j,k)/scalex(i,j,k)+  &
  &                           ddy(i,j,k)*v(i,j,k)/scaley(i,j,k))/scalez(i,j,k)
           end do
        end do
     end do

  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine turb_diff( x, y, z, phi, rho, nuh, nuv, val, undef, hx, hy, hz )
! ήȻ׻.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: phi(size(x),size(y),size(z))  ! ήȻ׻륹顼
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 3 ȯ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  character(1) :: signaltau(3)
  integer :: id
  real, dimension(size(x),size(y),size(z)) :: tmp
  real, dimension(size(x),size(y),size(z)) :: ddx, ddy, ddz
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  signaltau=(/ '1', '2', '3' /)

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  do id=1,3
     call Reynolds_scal( signaltau(id),  &
  &       x, y, z, phi, rho, nuh, nuv, tau(:,:,:,id),  &
  &       hx=scalex, hy=scaley, hz=scalez )
  end do

!-- ή 3 ȯƱȤʤΤ, div_3d ǤޤȤ.
  call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &            hx=scalex, hy=scaley, hz=scalez )

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine Reynolds_scal( signal, x, y, z, phi, rho, nuh, nuv, val, undef, hx, hy, hz )
! 顼̤ήեå׻.
  implicit none
  character(1) :: signal  ! ǥȺɸϤβܤήեåʬȽꤹ.
                  ! [1] = ǥȺɸϤˤ x ɸʬ
                  ! [2] = ǥȺɸϤˤ y ɸʬ
                  ! [3] = ǥȺɸϤˤ z ɸʬ
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: phi(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿȻ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľȻ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: ddx, ddy, ddz
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  select case (signal(1:1))
  case ('1')
     do k=1,nz
        do j=1,ny
           call grad_1d( x, phi(:,j,k), val(:,j,k) )

           do i=1,nx
              val(i,j,k)=rho(k)*nuh(i,j,k)*val(i,j,k)/scalex(i,j,k)
           end do
        end do
     end do

  case ('2')
     do k=1,nz
        do i=1,nx
           call grad_1d( y, phi(i,:,k), val(i,:,k) )

           do j=1,ny
              val(i,j,k)=rho(k)*nuh(i,j,k)*val(i,j,k)/scaley(i,j,k)
           end do
        end do
     end do

  case ('3')
     do j=1,ny
        do i=1,nx
           call grad_1d( z, phi(i,j,:), val(i,j,:) )

           do k=1,nz
              val(i,j,k)=rho(k)*nuv(i,j,k)*val(i,j,k)/scalez(i,j,k)
           end do
        end do
     end do

  end select

end subroutine

!-----------------------------------------
!-----------------------------------------

end module analy
