program wind
  use analy
  use Math_Const
  use trajectory
  use dcl
  use Dcl_Automatic
  implicit none
  integer :: i, j, k
  integer, parameter :: nx=300, ny=300, tstep=20000
  real, dimension(nx,ny) :: u, v, rot_2d, pres, dummy
  real, dimension(tstep,1) :: tx, ty
  real :: x(nx), y(ny)
  real, parameter :: xmin=-pi, xmax=pi, ymin=-pi, ymax=pi, dt=0.1
  real :: dx, dy
  real :: xscale, yscale

  xscale=0.05
  call calc_vscale( (xmax-xmin), (ymax-ymin), 0.6, 0.6, xscale, yscale )

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)

  dummy=-10.0

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)

  do j=1,ny
     do i=1,nx
        pres(i,j)=cos(x(i))+cos(y(j))
     end do
  end do

  do j=1,ny
     call grad_1d( x, pres(:,j), v(:,j) )
  end do
  do i=1,nx
     call grad_1d( y, pres(i,:), u(i,:) )
  end do

  v=-v

  call curl( x, y, u, v, rot_2d )

  call Forward_Traject_2d( dt, tstep, 0.1, 0.1, x, y, u, v, tx(:,1), ty(:,1), 'RK4' )

  call color_setting( 10, -3.0, 3.0, col_tab=14 )

  call DclOpenGraphics()

  call Dcl_2D_cont_shade( 'pressure', x, y, pres, dummy,  &
  &    -2.0, 2.0, -3.0, 3.0, 'x-axis', 'y-axis', '(f6.1)', 'f(6.1)', color_num=10 )

  call Dcl_2D_cont_shade_vec( 'vector', x, y, pres, dummy, u, v, 21, 21,  &
  &    -2.0, 2.0, -3.0, 3.0, 'x-axis', 'y-axis', '(f6.1)', 'f(6.1)', color_num=10,  &
  &    unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &    unit_fact=(/1.0, 1.0/), unit_title=(/'U','V'/) )

  call Dcl_2D_cont_shade_vec( 'rotation', x, y, pres, rot_2d, u, v, 21, 21,  &
  &    -2.0, 2.0, -3.0, 3.0, 'x-axis', 'y-axis', '(f6.1)', 'f(6.1)', color_num=10,  &
  &    unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &    unit_fact=(/1.0, 1.0/), unit_title=(/'U','V'/) )

  call Dcl_PL_vec( 'l', 'stream line', x, y, tx(:,1:1), ty(:,1:1),  &
  &                tx(:,1:1), ty(:,1:1), u, v, 21, 21, 'x-axis', 'y-axis' )

  call DclCloseGraphics

end program
