program draw
  use dcl
  implicit none
  integer :: nx, nt
  character(4) :: ctime
  real, allocatable, dimension(:) :: x, y
  real :: xmin, dx, dt
  integer :: i, j, k, IWS

  namelist /input /nx,dt,nt,xmin,dx
  read(5,input)

  allocate(x(2*nx+1))
  allocate(y(2*nx+1))

  IWS=4

  x=(/((xmin+dx*(i-1)),i=1,2*nx+1)/)

  open(unit=10,file='result.dat',access='direct',status='old',recl=4*(2*nx+1))

  call DclOpenGraphics( IWS )
     do i=1,nt
        read(10,rec=i) (y(j),j=1,2*nx+1)
        call DclNewFrame
        call DclSetWindow( xmin, x(2*nx+1), -1.0, 1.0 )
        call DclSetViewport( 0.2, 0.8, 0.2, 0.8 )
        call DclSetTransFunction
        call DclDrawScaledAxis
        call DclDrawLine( x, y )
     end do
  call DclCloseGraphics
  close(unit=10,status='keep')

end program
