*-----------------------------------------------------------------------
      program testxx

      include '/usr/local/include/netcdf.inc'

      parameter (maxcfs=13,maxlat=41,maxprs=20)

      integer   istim(2),ietim(2),start(4),count(4)
      real      prss(maxprs),xlat(maxlat),zmean(maxlat,maxprs)
      character cdsn*80,cdatex*19

      data      cdsn/'/v/shiotani/data/sbuv/1979v6.cdf'/

      data      start/      1,      1,      1,      1/
      data      count/      1, maxlat, maxprs,      1/


*     / input parameters /

      write(6,*) ' workstation id (i) ? ;'
      call supwsn(6)
      read(5,*) iws
      write(6,*) ' start date (ex.19781031) (i) ? ;'
      read(5,*) idatex
      write(6,*) ' no. of frames (i) ? ;'
      read(5,*) nfrm
      write(6,*) ' date interval (i) ? ;'
      read(5,*) idsk
      write(6,*) ' contour interval (r) ? ;'
      read(5,*) dz
      write(6,*) ' compact printing (non-zero=yes/0=no) (i) ? ;'
      read(5,*) icp

*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'r')

*     / get & check dimension size /

      call nxdqsz(ncdfid,'ntime',nt)
      call nxdqsz(ncdfid,'nlat',nlats)
      if (nlats.ne.maxlat)  call msgdmp('e','testxx','maxlat?!.')
      call nxdqsz(ncdfid,'npress',npress)
      if (npress.ne.maxprs) call msgdmp('e','testxx','maxprs?!.')
      call nxdqsz(ncdfid,'ncoefs',ncoefs)
      if (ncoefs.ne.maxcfs) call msgdmp('e','testxx','maxcfs?!.')

*     / get pressure and latitude grids /

      call nxagtx(ncdfid,'press:grid',prss)
      call nxagtx(ncdfid,'lat:grid',xlat)

*     / get some additional attributes /

*     call nxagtc(ncdfid,'press:units',unitspr)
      call nxagtx(ncdfid,':strtim',istim)
      call nxagtx(ncdfid,':stoptim',ietim)
      call nxagtx(ncdfid,'datap:missing_value',rmiss)

      call datej1(istim(1),isdat1)
      call datej1(ietim(1),iedat1)
*     write(6,*) ' start = ',isdat1,' ; end = ',iedat1
      if (.not.(isdat1.le.idatex .and. idatex.le.iedat1)) then
        call msgdmp('e','testxx','date out of range.')
      end if
      idtx=ndate1(isdat1,idatex)+1

      call glpset('lmiss',.true.)
      call glpset('rmiss',rmiss)

*     / get the data & plotting /

      call gropn(iws)

      call sgpset('lfull',.true.)

      if (icp.ne.0) then
        call slrat(3.0,2.0)
        call sldiv('y',3,2)
      end if
      call slrat(1.0,1.0)

      do id=0,(nfrm-1)*idsk,idsk

        start(4)=idtx+id

        call nxvgnx(ncdfid,'datap',start,count,zmean)

        cdatex='CCC DD, YYYY'
        call datef1(id,idatex,idatey)
        call datec1(cdatex,idatey)

        call grfrm
        
        call sgsntr(-90.0,+90.0,200.0,0.1,0.2,0.8,0.2,0.8,2)
        
        call uxaxdv('b',10.0,30.0)
        call uxaxdv('t',10.0,30.0)
        call uxsttl('b','Latitude',0.0)
        call ulpset('iytype',3)
        call ulylog('l',1,9)
        call ulylog('r',1,9)
        call uysttl('l','Pressure (mb)',0.0)
        
        call uwsgxa(xlat,maxlat)
        call uwsgya(prss,maxprs)
        
        call udgclb(zmean,maxlat,maxlat,maxprs,dz)
        call udcntr(zmean,maxlat,maxlat,maxprs)
        
        call uxsttl('t',cdatex,0.0)
        call uxsttl('t','SBUV Ozone (ppmv)',0.0)

      end do

      call grcls

      end
