*-----------------------------------------------------------------------
      program test11

      parameter (nlat=3,nlon=2,nmon=12,nchr=3)

      integer   ist(4),icn(4),idx(4),iyear(2)
      real      rlat(nlat),rlon(nlon),xlat(nlat),xlon(nlon)
      double precision wind(nlat,nlon)
      character cdsn*80,cmn(nmon)*(nchr),cmon*(nchr),cx*80

      data      rlat /  10,  20,  30 /
      data      rlon /  20,  40 /
      data      wind/ 0.1d0, 0.2d0, 0.3d0, 0.4d0, 0.5d0, 0.6d0 /
      data      iyear / 1991, 1992 /

      data      cdsn/'test11.cdf'/


*     / initialize /

      do n=1,nmon
        cmn(n)=cmon(n)
      end do

*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'c')

*     / define dimensions /

      call nxddef(ncdfid,'nlat',nlat)
      call nxddef(ncdfid,'nlon',nlon)
      call nxddef(ncdfid,'nmon',nmon)
      call nxddef(ncdfid,'nyear',0)
      call nxddef(ncdfid,'nchr',nchr)

*     / define variables /

      call nxvdef(ncdfid,'flag','i')
      call nxvdef(ncdfid,'iyear(nyear)','i')
      call nxvdef(ncdfid,'lat(nlat)','r')
      call nxvdef(ncdfid,'lon(nlon)','r')
      call nxvdef(ncdfid,'mon(nchr,nmon)','c')
      call nxvdef(ncdfid,'wind(nlat,nlon,nmon,nyear)','d')

*     / put attributes /

      call nxaptx(ncdfid,':date','i',1,19930202)
      call nxaptc(ncdfid,':comment','c',14,'test wind data')
      call nxaptx(ncdfid,'iyear:grid','i',2,iyear)
      call nxaptx(ncdfid,'lat:grid','r',nlat,rlat)
      call nxaptc(ncdfid,'lat:unit','c',6,'degree')
      call nxaptx(ncdfid,'lon:grid','r',nlon,rlon)
      call nxaptc(ncdfid,'lon:unit','c',6,'degree')
      call nxaptx(ncdfid,'wind:_FillValue','d',1,-999.0d0)

*     / leave define mode /

      call nxdefm(ncdfid,.false.)

*     / write data /

      call nxvp1x(ncdfid,'flag',0,1)
      call nxvpnx(ncdfid,'iyear',1,2,iyear)
      call nxvpax(ncdfid,'lat',rlat)
      call nxvpax(ncdfid,'lon',rlon)
      call nxvgax(ncdfid,'lat',xlat)
      write(6,*) xlat
      call nxvgax(ncdfid,'lon',xlon)
      write(6,*) xlon
      ist(1)=1
      ist(2)=1
      ist(3)=2
      ist(4)=2
      icn(1)=nlat
      icn(2)=nlon
      icn(3)=1
      icn(4)=1
      call nxvpnx(ncdfid,'wind',ist,icn,wind)
      call nxvpac(ncdfid,'mon',cmn)
      call nxvgac(ncdfid,'mon',cx)
      write(6,*) cx

*     / close netcdf file /

      call nxclos(ncdfid)

      end
*-----------------------------------------------------------------------
      subroutine nxvpac(ncdfid,cvname,cvalue)

      include   '/usr/local/include/netcdf.inc'

      character cvname*(*),cvalue*(*)

      integer   istart(MAXVDIMS),icount(MAXVDIMS),ivdims(MAXVDIMS)
      character cvtemp*(MAXNCNAM)


      nvarid=ncvid(ncdfid,cvname,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpac','error in ncvid.')

      call ncvinq(ncdfid,nvarid,cvtemp,ivtype,nvdims,ivdims,nvarat,
     +     ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpac','error in ncvinq.')

      lencvl=1
      do 10 n=1,nvdims
        istart(n)=1
        call ncdinq(ncdfid,ivdims(n),cvtemp,icount(n),ircode)
        if (ircode.ne.0) call msgdmp('e','nxvpac','error in ncdinq.')
        lencvl=lencvl*icount(n)
   10 continue

      call ncvptc(ncdfid,nvarid,istart,icount,cvalue,lencvl,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpac','error in ncvptc.')

      end
*-----------------------------------------------------------------------
      subroutine nxvpax(ncdfid,cvname,values)

      include   '/usr/local/include/netcdf.inc'

      real      values(*)
      character cvname*(*)

      integer   istart(MAXVDIMS),icount(MAXVDIMS),ivdims(MAXVDIMS)
      character cvtemp*(MAXNCNAM)


      nvarid=ncvid(ncdfid,cvname,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpax','error in ncvid.')

      call ncvinq(ncdfid,nvarid,cvtemp,ivtype,nvdims,ivdims,nvarat,
     +     ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpax','error in ncvinq.')

      lencvl=1
      do 10 n=1,nvdims
        istart(n)=1
        call ncdinq(ncdfid,ivdims(n),cvtemp,icount(n),ircode)
        if (ircode.ne.0) call msgdmp('e','nxvpax','error in ncdinq.')
        lencvl=lencvl*icount(n)
   10 continue

      call ncvpt(ncdfid,nvarid,istart,icount,values,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvpax','error in ncvpt.')

      end
*-----------------------------------------------------------------------
      subroutine nxvgac(ncdfid,cvname,cvalue)

      include   '/usr/local/include/netcdf.inc'

      character cvname*(*),cvalue*(*)

      integer   istart(MAXVDIMS),icount(MAXVDIMS),ivdims(MAXVDIMS)
      character cvtemp*(MAXNCNAM)


      nvarid=ncvid(ncdfid,cvname,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgac','error in ncvid.')

      call ncvinq(ncdfid,nvarid,cvtemp,ivtype,nvdims,ivdims,nvarat,
     +     ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgac','error in ncvinq.')

      lencvl=1
      do 10 n=1,nvdims
        istart(n)=1
        call ncdinq(ncdfid,ivdims(n),cvtemp,icount(n),ircode)
        if (ircode.ne.0) call msgdmp('e','nxvgac','error in ncdinq.')
        lencvl=lencvl*icount(n)
   10 continue

      call ncvgtc(ncdfid,nvarid,istart,icount,cvalue,lencvl,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgac','error in ncvgtc.')

      end
*-----------------------------------------------------------------------
      subroutine nxvgax(ncdfid,cvname,values)

      include   '/usr/local/include/netcdf.inc'

      real      values(*)
      character cvname*(*)

      integer   istart(MAXVDIMS),icount(MAXVDIMS),ivdims(MAXVDIMS)
      character cvtemp*(MAXNCNAM)


      nvarid=ncvid(ncdfid,cvname,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgax','error in ncvid.')

      call ncvinq(ncdfid,nvarid,cvtemp,ivtype,nvdims,ivdims,nvarat,
     +     ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgax','error in ncvinq.')

      lencvl=1
      do 10 n=1,nvdims
        istart(n)=1
        call ncdinq(ncdfid,ivdims(n),cvtemp,icount(n),ircode)
        if (ircode.ne.0) call msgdmp('e','nxvgax','error in ncdinq.')
        lencvl=lencvl*icount(n)
   10 continue

      call ncvgt(ncdfid,nvarid,istart,icount,values,ircode)
      if (ircode.ne.0) call msgdmp('e','nxvgax','error in ncvgt.')

      end
