*-----------------------------------------------------------------------
      program test07

      parameter (nlat=6,nlon=3,nmon=12,nchr=3)

      integer   ist(3),icn(3),idx(3)
      real      rlat(nlat),rlon(nlon)
      double precision wind(nlat,nlon)
      character cdsn*80,cmn(nmon)*(nchr)

      data      cdsn/'test07.cdf'/


*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'r')

*     / read data /

      call nxvg1x(ncdfid,'flag',0,iflag)
      write(6,*) ' flag = ',iflag
      do n=1,nlat
        call nxvg1x(ncdfid,'lat',n,rlat(n))
      end do
      write(6,*) ' lat = ',rlat
      call nxvgnx(ncdfid,'lon',1,nlon,rlon)
      write(6,*) ' lon = ',rlon
      do n=1,nmon,2
        ist(1)=1
        ist(2)=n
        icn(1)=nchr
        icn(2)=1
        call nxvgnc(ncdfid,'mon',ist,icn,cmn(n))
      end do
      write(6,*) ' mon = ',cmn
      do n=2,nmon,2
        do m=1,nchr
          idx(1)=m
          idx(2)=n
          call nxvg1c(ncdfid,'mon',idx,cmn(n)(m:m))
        end do
      end do
      write(6,*) ' mon = ',cmn

*     / close netcdf file /

      call nxclos(ncdfid)

      end
