*-----------------------------------------------------------------------
      program test01

      parameter (nlat=6,nlon=3)

      integer   lat(nlat),lon(nlon),ist(2),icn(2)
      real      wind(nlat,nlon)
      character cdsn*80

      data      lat /  10,  20,  30,  40,  50,  60 /
      data      lon /  20,  40,  60 /
      data      wind/ 0.1, 0.2, 0.3, 0.4, 0.5, 0.4,
     +                0.2, 0.3, 0.3, 0.4, 0.6, 0.5,
     +                0.1, 0.3, 0.3, 0.3, 0.5, 0.4 /

      data      ist / 1, 1 /, icn / nlat, nlon /

      data      cdsn/'test01.cdf'/


*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'c')

*     / define dimensions /

      call nxddef(ncdfid,'nlat',nlat)
      call nxddef(ncdfid,'nlon',nlon)

*     / define variables /

      call nxvdef(ncdfid,'flag','i')
      call nxvdef(ncdfid,'lat(nlat)','i')
      call nxvdef(ncdfid,'lon(nlon)','i')
      call nxvdef(ncdfid,'wind(nlat,nlon)','r')

*     / put attributes /

      call nxaptx(ncdfid,':date','i',1,19930129)
      call nxaptc(ncdfid,':comment','c',14,'test wind data')
      call nxaptx(ncdfid,'lat:grid','i',nlat,lat)
      call nxaptc(ncdfid,'lat:unit','c',6,'degree')
      call nxaptx(ncdfid,'lon:grid','i',nlon,lon)
      call nxaptc(ncdfid,'lon:unit','c',6,'degree')

*     / leave define mode /

      call nxdefm(ncdfid,.false.)

*     / write data /

      call nxvpax(ncdfid,'flag',1)
      call nxvpax(ncdfid,'lat',lat)
      call nxvpax(ncdfid,'lon',lon)
      call nxvpax(ncdfid,'wind',wind)

*     / close netcdf file /

      call nxclos(ncdfid)

      end
