! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTFigLoad(fig, var)
    use gtgraph_types, only: GT_FIGURE, GT_OBJECT
    use gtgraph_generic, only: Load, Bind
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, url
    use dc_string
    use dc_error
    use dc_url, only: UrlResolve
    implicit none
    type(GT_FIGURE), intent(out):: fig
    type(GT_VARIABLE), intent(in):: var
    type(GT_OBJECT):: it
    type(VSTRING):: members, member, aname
    type(STRING_LIST):: member_list
    call get_attr(var, "gt_structure_member", members)
    call split(member_list, members, " ")
    do, while (len(member_list) > 0)
        member = shift(member_list)
        aname = "gt_structure_link_" // member
        call get_attr(var, vchar(aname, len(aname)), member)
        if (member == "") exit
        member = UrlResolve(member, base=url(var))
        call Load(it, member)
        call Bind(fig, it)
    enddo
end subroutine
