! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANVarCreate(var, url, xtype, dims, overwrite, err)
    use dc_string
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileOpen, ANFileDefineMode
    use dc_url, only: UrlSplit
    use netcdf_f77, only: NF_NOERR, nf_def_var, NF_REAL, NF_INT, NF_DOUBLE, &
        NF_EBADDIM, nf_inq_unlimdim
    use dc_error, only: StoreError, GT_ENOMEM, GT_EOTHERFILE, &
        GT_EDIMNODIM, GT_EDIMMULTIDIM
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    character(len = *), intent(in):: url
    character(len = *), intent(in):: xtype
    type(AN_VARIABLE), intent(in):: dims(:)
    logical, intent(in), optional:: overwrite
    logical, intent(out), optional:: err
    type(VSTRING):: filename, varname
    integer:: stat, nvdims, i
    integer:: dimid_growable
    integer:: nc_xtype
continue
    ! KvȂt@C쐬
    call UrlSplit(var_str(url), filename, varname)
    call ANFileOpen(var%fileid, filename, stat=stat, writable=.TRUE., &
        overwrite=overwrite)
    if (stat /= NF_NOERR) goto 999
    ! ɂ܂鏀
    nvdims = size(dims)
    allocate(var%dimids(nvdims), var%allcount(nvdims), stat=stat)
    if (stat /= 0) goto 990
    ! s蒷Ȃ dimid_growable = -1 ƂȂ
    stat = nf_inq_unlimdim(var%fileid, dimid_growable)
    if (stat /= NF_NOERR) goto 999
    var%growable = .FALSE.
    do, i = 1, nvdims
        ! lg?
        if (dims(i)%fileid /= var%fileid) then
            stat = GT_EOTHERFILE;  goto 999
        endif
        if (dims(i)%dimid < 0) then
            stat = NF_EBADDIM;  goto 999
        endif
        var%dimids(i) = dims(i)%dimid
        ! s蒷`FbN
        if (dims(i)%dimid == dimid_growable) var%growable = .TRUE.
        ! 𒲂ׂłɒP`FbN
        if (.not. associated(dims(i)%allcount)) then
            stat = GT_EDIMNODIM;  goto 999
        endif
        if (size(dims(i)%allcount) /= 1) then
            stat = GT_EDIMMULTIDIM;  goto 999
        endif
        var%allcount(i) = dims(i)%allcount(1)
    enddo
    ! ϐ̌^̔
    nc_xtype = NF_REAL
    if (EquivNoCase(xtype, "double") .or. EquivNoCase(xtype, "DOUBLEPRECISION")) then
        nc_xtype = NF_DOUBLE
    endif
    if (EquivNoCase(xtype, "int") .or. EquivNoCase(xtype, "INTEGER")) then
        nc_xtype = NF_INT
    endif
    ! {̕ϐ쐬
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_def_var(var%fileid, vchar(varname, len(varname)), xtype=nc_xtype, &
        & ndims=nvdims, dimids=var%dimids, varid=var%varid)
    if (stat /= NF_NOERR) goto 999
    ! Ce[^
    allocate(var%start(nvdims), var%count(nvdims), var%stride(nvdims), &
        & stat=stat)
    if (stat /= 0) goto 990
    var%count(:) = var%allcount(:)
    var%start(:) = 1
    var%stride(:) = 1
    ! ̑̐
    var%attrid = 0

    goto 999

990 continue
    stat = GT_ENOMEM
999 continue
    call StoreError(stat, 'ANVarCreate', err)
end subroutine
