! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTVarPutLine(var, err)
    use gtdata_types, only: GT_VARIABLE
    use dc_error
    use dc_string, only: toString
    use gtdata_generic, only: Get, Size
    use iso_varying_string
    type(GT_VARIABLE), intent(inout):: var
    logical, intent(out), optional:: err
    real, allocatable:: rvalue(:)
    integer, allocatable:: ivalue(:)
    integer:: siz, stat, i
    logical:: myerr
    siz = size(var)
    stat = 0
    allocate(rvalue(siz), stat=stat)
    if (stat /= 0) then
        stat = GT_ENOMEM;  goto 999
    endif
    call Get(var, rvalue, size(rvalue), err=myerr)
    if (myerr) then
        if (present(err)) err = myerr
        return
    endif
    do, i = 1, size(rvalue)
        call put_line(toString(rvalue(i)))
    end do
    deallocate(rvalue, stat=stat)
    if (stat /= 0) then
        stat = GT_ENOMEM;  goto 999
    endif
    goto 999
    ! error handler
990 continue
    stat = GT_ENOMEM
999 continue
    call StoreError(stat, "GTVarPutLine", err)
end subroutine
