! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtlist - 񋓈󎚃c[

program gtlist
    use gtool
    implicit none
    type(VARYING_STRING):: argument
    type(VARYING_STRING):: filename, varname, attrname
    type(VARYING_STRING):: fpart, vpart
    integer:: i
    integer:: showcount = 0
    logical:: url_mode = .FALSE.
    character:: format = "1"
continue
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (argument == "-url") then
            url_mode = .TRUE.
        else if (extract(argument, 1, 1) == "-" .and. len(argument) == 2) then
            format = extract(argument, start=2)
        else
            showcount = showcount + 1
            call UrlSplit(argument, file=filename, var=varname)
            if (varname == '') then
                call list_variables
            else
                call list_attributes
            endif
        endif
    enddo
    if (showcount == 0) then
        write(*, *) 'usage: gtlist [-url] [filename|varname] ...'
    endif
contains

    subroutine list_variables
        type(GT_VARIABLE):: var
        character(len = 20):: xtype
        logical:: end
        call GTVarSearch(argument)
        do
            call GTVarSearch(varname, end)
            if (end) exit
            call UrlSplit(varname, file=fpart, var=vpart)
            if (url_mode) then
                vpart = UrlMerge(fpart, vpart)
            endif
            select case(format)
            case('l', 'L')
                call Open(var, varname)
                call Inquire(var=var, xtype=xtype)
                call put_line(xtype // vpart)
                call Close(var)
            case('m')
                call Open(var, varname)
                call Inquire(var=var, xtype=xtype)
                call put_line(trim(xtype) // ', ' // vpart)
                call Close(var)
            case default
                call put_line(vpart)
            end select
        enddo
    end subroutine

    subroutine list_attributes
        type(VARYING_STRING):: apart
        type(GT_VARIABLE):: var
        character(len = 20):: xtype
        logical:: end
        varname = UrlMerge(filename, varname)
        call Open(var, varname)
        call attr_rewind(var)
        do
            call attr_next(var, apart, end)
            if (end) exit
            if (url_mode) then
                attrname = Url(var) // ':' // apart
            else
                attrname = apart
            endif
            select case(format)
            case('l', 'L')
                call inquire(var, char(attrname), xtype=xtype)
                call put_line(xtype // attrname)
            case('m')
                call inquire(var, char(attrname), xtype=xtype)
                call put_line(trim(xtype) // ", " // attrname)
            case default
                call put_line(attrname)
            end select
        enddo
        call Close(var)
    end subroutine

end program