! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANAttrInquire(var, attrname, xtype)
    use an_types, only: AN_VARIABLE
    use an_generic, only: ANXTypeName
    use iso_varying_string, only: VARYING_STRING, assignment(=)
    use netcdf_f77, only: NF_MAX_NAME, nf_inq_atttype
    use dc_url, only: GT_PLUS
    type(AN_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    type(VARYING_STRING), intent(out), optional:: xtype
    integer:: varid
    character(len=NF_MAX_NAME):: anam
    if (present(xtype)) then
        call inquire(var, attrname, varid, anam)
        stat = nf_inq_atttype(var%fileid, varid, anam, xtype=i_xtype)
        if (stat /= NF_NOERR) i_xtype = 0
        call ANXTypeName(i_xtype, xtype)
    endif
end subroutine

! ۂɃANZXƂɎg varid, attrname 𓾂
! attrname ̐擪 '+' ---> 摮w
! attrname ̐擪 '-' ---> ϐA摮̏Ō
! pƂ use an_file, only: inquire Ă
!
subroutine ANAttrInquirePlus(var, attrname, varid, nf_attrname)
    use an_types, only: AN_VARIABLE
    use dc_url, only: GT_PLUS
    use netcdf_f77, only: NF_GLOBAL
    type(AN_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    integer, intent(out):: varid
    character(len=*), intent(out):: nf_attrname
    if (attrname(1:1) == GT_PLUS) then
        varid = NF_GLOBAL
        nf_attrname = attrname(2: )
    else
        varid = var%varid
        nf_attrname = attrname
    endif
end subroutine