! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANVarInquire(var, xtype)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING
    use netcdf_f77
    use dc_url, only: GT_PLUS
    type(AN_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    type(VARYING_STRING), intent(out), optional:: xtype
    integer:: stat, i_xtype
!---
    if (present(xtype)) then
        stat = nf_inq_vartype(var%fileid, var%varid, xtype=i_xtype)
        if (stat /= NF_NOERR) i_xtype = 0
        call an_xtype_name(i_xtype, xtype)
    endif
    return
!---
    entry ANVarInquireA(var, attrname, xtype)
    if (present(xtype)) then
        if (attrname(1:1) == GT_PLUS) then
            stat = nf_inq_atttype(var%fileid, NF_GLOBAL, attrname(2:), xtype=i_xtype)
        else
            stat = nf_inq_atttype(var%fileid, var%varid, attrname, xtype=i_xtype)
        endif
        if (stat /= NF_NOERR) i_xtype = 0
        call an_xtype_name(i_xtype, xtype)
    endif
    return
contains

    subroutine an_xtype_name(xtype, xtypename)
        integer, intent(in):: xtype
        type(VARYING_STRING), intent(out):: xtypename
        select case(xtype)
        case(0)
            xtypename = "(error)"
        case(NF_BYTE)
            xtypename = "byte"
        case(NF_CHAR)
            xtypename = "char"
        case(NF_SHORT)
            xtypename = "short"
        case(NF_INT)
            xtypename = "int"
        case(NF_FLOAT)
            xtypename = "float"
        case(NF_DOUBLE)
            xtypename = "double"
        case default
            xtypename = ""
        end select
    end subroutine

end subroutine