! gtlinelib.f90 - IuWFNg̎舵

subroutine GTLineOpen(result, var)
    use gtgraph_types, only: GT_LINE
    use gtgraph_generic, only: Open
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open
    type(GT_LINE), intent(out):: result
    type(GT_VARIABLE), intent(in):: var
    call Open(result%var, var, 0)
    allocate(result%h_axis, result%v_axis)
    call Open(result%v_axis, var, 0)
    call Open(result%h_axis, var, 1)
    result%index = 1
    result%type = 1
    result%mark = 0
end subroutine

subroutine GtLineClose(Line)
    use gtgraph_types, only: GT_Line
    use gtgraph_generic, only: Close
    use gtdata_generic, only: Close
    type(GT_Line), intent(inout):: Line
    call Close(Line%h_axis)
    call Close(Line%v_axis)
    deallocate(Line%h_axis, Line%v_axis)
    call Close(Line%var)
end subroutine

subroutine GtLineOption(line, optname, value, err)
    use gtgraph_types, only: GT_LINE
    use dc_string, only: StoI, toUpper
    use gt_args, only: GtOptionLineIndex
    type(GT_LINE), intent(inout):: line
    character(len = *), intent(in):: optname
    character(len = *), intent(in):: value
    character(len = len(optname)):: uc_optname
    character(len = len(value)):: uc_value
    logical, intent(out):: err
continue
    uc_optname = optname
    uc_value = value
    call toUpper(uc_optname)
    call toUpper(uc_value)
    call GtOptionLineIndex(line%index, uc_optname, uc_value, err)
    if (.not. err) then
        return
    else if (uc_optname == "TYPE") then
        select case(uc_value)
        case("SOLID")
            line%type = 1
        case("DASH", "DASHED")
            line%type = 2
        case("DOT", "DOTTED")
            line%type = 3
        case("DOTDASHED")
            line%type = 4
        case default
            line%type = stoi(value)
        end select
        err = .FALSE.
        return
    else if (uc_optname == "MARK") then
        if (index("0123456789", uc_value(1:1)) >= 1) then
            line%mark = stoi(value)
        else
            line%mark = iachar(value(1:1))
        endif
        err = .FALSE.
        return
    endif
end subroutine

subroutine GTFigPutLine(fig, line)
    use gtgraph_types, only: GT_FIGURE, GT_LINE
    use gtdata_generic, only: get_attr, name
    use iso_varying_string
    use dc_error
    type(GT_FIGURE), intent(inout):: fig
    type(GT_LINE), intent(in):: line
    type(GT_LINE), pointer:: newlines(:)
    type(VARYING_STRING):: title
    integer:: nlines, stat
    stat = GT_EFAKE
    if (associated(fig%h_axis) .or. associated(fig%v_axis)) goto 999
    fig%h_axis => line%h_axis
    fig%v_axis => line%v_axis
    !
    call get_attr(line%var, 'long_name', title)
    if (title == '') title = Name(line%var)
    if (fig%title == "untitled") then
        fig%title = title
    else
        fig%title = fig%title // ", " // title
    endif
    !
    stat = 0
    if (associated(fig%line)) then
        nlines = size(fig%line)
        allocate(newlines(nlines + 1))
        newlines(1: nlines) = fig%line(1: nlines)
        deallocate(fig%line)
    else
        nlines = 0
        allocate(newlines(1))
    endif
    newlines(nlines + 1) = line
    fig%line => newlines
    999 continue
    call StoreError(stat, 'GTFigPutLine')
end subroutine

subroutine GTLineDraw(line, parent)
    use gtgraph_types, only: GT_LINE, GT_FIGURE
    use gtgraph_generic, only: Draw
    use gtdata_generic, only: Get
    use dcl
    type(GT_LINE), intent(inout):: line
    type(GT_FIGURE), intent(in):: parent
    real, pointer:: value(:)
    real, pointer:: abscissa(:)
    call Draw(line%h_axis, line%v_axis, parent)
    call Get(line%var, value)
    call Get(line%h_axis%var, abscissa)
    ! Ot̕`
    if (line%index /= 0) then
        call DclDrawLine(abscissa, value, index=line%index, type=line%type)
    endif
    if (line%mark /= 0) then
        call DclDrawMarker(abscissa, value, index=line%index, type=line%mark)
    endif
    deallocate(abscissa, value)
end subroutine
