! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

module dc_date

    ! tƎԊԊuʂB
    ! ^錾ɂĎɒ܂Tu[` dc_date_types ɒuB
    use dc_date_types

    interface operator(+)
        module procedure dcdate_add_ft
        module procedure dcdate_add_tf
        module procedure dcdate_add_ff
    end interface

    interface operator(-)
        module procedure dcdate_sub_tt
        module procedure dcdate_sub_tf
    end interface

    interface operator(*)
        module procedure dcdate_mul_if
        module procedure dcdate_mul_rf
        module procedure dcdate_mul_df
        module procedure dcdate_mul_fi
        module procedure dcdate_mul_fr
        module procedure dcdate_mul_fd
    end interface

    interface operator(/)
        module procedure dcdate_div_fi
        module procedure dcdate_div_fr
        module procedure dcdate_div_fd
        module procedure dcdate_div_ff
    end interface

    interface mod
        module procedure dcdate_mod_ff
    end interface

    interface assignment(=)

        subroutine dcdate_let_fc(diff, string)
            use dc_date_types, only: DC_DIFFTIME
            type(DC_DIFFTIME), intent(out):: diff
            character(len = *), intent(in):: string
        end subroutine

        subroutine dcdate_let_fs(diff, string)
            use dc_date_types, only: DC_DIFFTIME
            use iso_varying_string, only: VARYING_STRING
            type(DC_DIFFTIME), intent(out):: diff
            type(VARYING_STRING), intent(in):: string
        end subroutine

        subroutine dcdate_let_tc(time, string)
            use dc_date_types, only: DC_DATETIME
            type(DC_DATETIME), intent(out):: time
            character(len = *), intent(in):: string
        end subroutine

        subroutine dcdate_let_ts(time, string)
            use dc_date_types, only: DC_DATETIME
            use iso_varying_string, only: VARYING_STRING
            type(DC_DATETIME), intent(out):: time
            type(VARYING_STRING), intent(in):: string
        end subroutine

    end interface

    interface toString

        type(VARYING_STRING) function dcdate_diff_tostring(diff)
            use dc_date_types, only: DC_DIFFTIME
            use iso_varying_string, only: VARYING_STRING
            type(DC_DIFFTIME), intent(in):: diff
        end function

        type(VARYING_STRING) function dcdate_time_tostring(time)
            use dc_date_types, only: DC_DATETIME
            use iso_varying_string, only: VARYING_STRING
            type(DC_DATETIME), intent(in):: time
        end function

    end interface

    interface Eval

        subroutine dcdate_eval_diff(diff, &
            & year, mon, day, hour, min, sec)
            use dc_date_types, only: DC_DIFFTIME
            type(DC_DIFFTIME), intent(in):: diff
            integer, intent(out), optional:: year, mon, day, hour, min, sec
        end subroutine

        subroutine dcdate_eval_time(time, &
            & year, mon, day, hour, min, sec)
            use dc_date_types, only: DC_DATETIME
            type(DC_DATETIME), intent(in):: time
            integer, intent(out), optional:: year, mon, day, hour, min, sec
        end subroutine

    end interface

    interface DiffTime
        type(DC_DIFFTIME) function dcdate_diff(diff, &
            & year, mon, day, hour, min, sec)
            use dc_date_types, only: DC_DIFFTIME
            integer, intent(in), optional:: year, mon, day, hour, min, sec
        end function
    end interface

    interface DateTime
        type(DC_DATETIME) function dcdate_time(time, &
            & year, mon, day, hour, min, sec)
            use dc_date_types, only: DC_DATETIME
            integer, intent(in), optional:: year, mon, day, hour, min, sec
        end function
    end interface

end module