! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

module dc_date_types

    ! 1N̓ 3652425 ӂ̂łĂ͂ȂȂB
    integer, parameter:: LONGINT = selected_int_kind(7)

    ! ʓƒʕb̑΂œt\B

    type DC_DATETIME
        sequence
        integer(LONGINT):: day
        double precision:: sec
    end type

    ! u1vƂTOɑΉ邽߁Amonth B
    ! : tƈČ normalize 邱Ƃ͂łȂB
    type DC_DIFFTIME
        sequence
        integer(LONGINT):: month
        integer(LONGINT):: day
        double precision:: sec
    end type

contains

    subroutine dcdate_normalize(day, sec)
        integer(LONGINT), intent(inout):: day
        double precision, intent(inout):: sec
        if (abs(sec) > 86400.0) then
            day = day + int(sec / 86400.0d0, kind=LONGINT)
            sec = modulo(sec, 86400.0d0)
        end if
    end subroutine
    
    type(DC_DATETIME) function dcdate_add_ft(diff, time) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        type(DC_DATETIME), intent(in):: time
        result%day = diff%day + time%day
        result%sec = diff%sec + time%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DATETIME) function dcdate_add_tf(time, diff) result(result)
        type(DC_DATETIME), intent(in):: time
        type(DC_DIFFTIME), intent(in):: diff
        result%day = diff%day + time%day
        result%sec = diff%sec + time%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_add_ff(diff1, diff2) result(result)
        type(DC_DIFFTIME), intent(in):: diff1, diff2
        result%day = diff1%day + diff2%day
        result%sec = diff1%sec + diff2%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_sub_tt(time1, time2) result(result)
        type(DC_DATETIME), intent(in):: time1, time2
        result%day = time1%day - time2%day
        result%sec = time1%sec - time2%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_sub_tf(time, diff) result(result)
        type(DC_DATETIME), intent(in):: time
        type(DC_DIFFTIME), intent(in):: diff
        result%day = time%day - diff%day
        result%sec = time%sec - diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_if(factor, diff) result(result)
        integer, intent(in):: factor
        type(DC_DIFFTIME), intent(in):: diff
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_rf(factor, diff) result(result)
        real, intent(in):: factor
        type(DC_DIFFTIME), intent(in):: diff
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_df(factor, diff) result(result)
        double precision, intent(in):: factor
        type(DC_DIFFTIME), intent(in):: diff
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_fi(diff, factor) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        integer, intent(in):: factor
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_fr(diff, factor) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        real, intent(in):: factor
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_mul_fd(diff, factor) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        double precision, intent(in):: factor
        result%day = factor * diff%day
        result%sec = factor * diff%sec
        call dcdate_normalize(result%day, result%sec)
    end function

    type(DC_DIFFTIME) function dcdate_div_fi(diff, denominator) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        integer, intent(in):: denominator
    end function

    type(DC_DIFFTIME) function dcdate_div_fr(diff, denominator) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        real, intent(in):: denominator
    end function

    type(DC_DIFFTIME) function dcdate_div_fd(diff, denominator) result(result)
        type(DC_DIFFTIME), intent(in):: diff
        double precision, intent(in):: denominator
    end function

    double precision function dcdate_div_ff(diff1, diff2) result(result)
        type(DC_DIFFTIME), intent(in):: diff1, diff2
    end function

    type(DC_DIFFTIME) function dcdate_mod_ff(diff1, diff2) result(result)
        type(DC_DIFFTIME), intent(in):: diff1, diff2
    end function

end module