! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtlist - 񋓈󎚃c[

program gtlist
    use gtool
    implicit none
    type(VARYING_STRING):: argument
    type(VARYING_STRING):: filename, varname, attrname
    type(VARYING_STRING):: fpart, vpart, apart
    type(GT_VARIABLE):: var
    integer:: i
    logical:: end
    integer:: showcount = 0
    logical:: url_mode = .FALSE.
continue
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (argument == "-url") then
            url_mode = .TRUE.
        else
            showcount = showcount + 1
            call UrlSplit(argument, file=filename, var=varname)
            if (varname == '') then
                call GTVarSearch(argument)
                do
                    call GTVarSearch(varname, end)
                    if (end) exit
                    call UrlSplit(varname, file=fpart, var=vpart)
                    if (url_mode) then
                        vpart = UrlMerge(fpart, vpart)
                    endif
                    call put_line(vpart)
                enddo
            else
                varname = UrlMerge(filename, varname)
                call Open(var, varname)
                call attr_rewind(var)
                do
                    call attr_next(var, apart, end)
                    if (end) exit
                    if (url_mode) then
                        attrname = Url(var) // ':' // apart
                    else
                        attrname = apart
                    endif
                    call put_line(attrname)
                enddo
                call Close(var)
            endif
        endif
    enddo
    if (showcount == 0) then
        write(*, *) 'usage: gtlist [-url] [filename|varname] ...'
    endif
end program