! gtvargetattr.f90 - l^̓
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! ̌^ɉĂ낢날邪Aǂ\ł͓mgĂB

! XJŎ󂯎̂ԊȒPB߉\ȒlƂAĉ͎ĂB

subroutine GTVarGetAttrR(var, attrname, value, default)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use dc_error
    use netcdf_f77, only: NF_FILL_REAL
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: attrname
    real, intent(out):: value
    real, intent(in), optional:: default
    integer:: stat
    real:: buffer(1)
    if (associated(var%an)) then
        call ANVarGetAttrRA(var%an, attrname, buffer, stat, default)
        value = buffer(1)
        if (stat >= 1) return
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrR")
    endif
    value = NF_FILL_REAL
    if (present(default)) value = default
end subroutine

subroutine GTVarGetAttrI(var, attrname, value, default)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use netcdf_f77, only: NF_FILL_INT
    use dc_error
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: attrname
    integer, intent(out):: value
    integer, intent(in), optional:: default
    integer:: stat
    integer:: buffer(1)
    if (associated(var%an)) then
        call get_attr(var%an, attrname, buffer, stat, default)
        value = buffer(1)
        if (stat >= 1) return
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrI")
    endif
    value = NF_FILL_INT
    if (present(default)) value = default
end subroutine

! |C^zgĎ󂯎ꍇ͉߉\Ȑ̂tB

subroutine GTVarGetAttrRP(var, name, value)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use dc_error
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, pointer:: value(:)
    integer:: stat
    if (associated(var%an)) then
        allocate(value(1))
        call get_attr(var%an, name, value(1:0), stat)
        deallocate(value)
        if (stat < 1) return
        allocate(value(stat))
        call get_attr(var%an, name, value, stat)
        if (stat < 1) deallocate(value)
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRP")
    endif
end subroutine

subroutine GTVarGetAttrIP(var, name, value)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use dc_error
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, pointer:: value(:)
    integer:: stat
    if (associated(var%an)) then
        allocate(value(1))
        call get_attr(var%an, name, value(1:0), stat)
        deallocate(value)
        if (stat < 1) return
        allocate(value(stat))
        call get_attr(var%an, name, value, stat)
        if (stat < 1) deallocate(value)
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrIP")
    endif
end subroutine

! integer z, real zƂĎ󂯎
! ꍇ͑܂Ăꍇɂ͐؂̂ĂA
! Ȃꍇ default l (|C^ƈႢK{) 𖄂߂B

subroutine GTVarGetAttrRA(var, name, value, stat, default)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use dc_error
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, intent(out):: value(:)
    integer, intent(out):: stat
    real, intent(in), optional:: default
    if (associated(var%an)) then
        call get_attr(var%an, name, value, stat, default)
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrRA")
    endif
end subroutine

subroutine GTVarGetAttrIA(var, name, value, stat, default)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: get_attr
    use dc_error
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, intent(out):: value(:)
    integer, intent(out):: stat
    integer, intent(in), optional:: default
    if (associated(var%an)) then
        call get_attr(var%an, name, value, stat, default)
    else
        call StoreError(GT_ENOTVAR, "GTVarGetAttrIA")
    endif
end subroutine
