! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine ANVarPutAttrChar(var, name, value, xtype, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode
    use netcdf_f77, only: NF_PUT_ATT_TEXT, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE
    use dc_error
    use dc_string, only: get_array
    use an_generic, only: put_attr
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    character(len = *), intent(in):: value
    character(len = *), intent(in), optional:: xtype
    logical, intent(out), optional:: err
    integer, pointer:: ip(:)
    real, pointer:: rp(:)
    integer:: stat
continue
    if (len(value) == 0) then
        stat = nf_del_att(var%fileid, var%varid, name=name)
        goto 999
    endif
    if (present(xtype)) then
        select case(xtype)
        case("INTEGER", "integer", "int")
            goto 200
        case("REAL", "real", "float")
            goto 300
        case("DOUBLEPRECISION", "DOUBLE", "double")
            goto 400
        end select
    end if

    stat = nf_put_att_text(var%fileid, var%varid, name=name, &
        len=len(value), text=value)
    if (stat == NF_NOERR) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_put_att_text(var%fileid, var%varid, name=name, &
        len=len(value), text=value)

999 continue
    call StoreError(stat, 'ANVarPutAttrChar', err)
    return

200 continue
    call get_array(ip, value)
    if (associated(ip)) then
        call put_attr(var, name, ip, err)
        deallocate(ip)
    endif
    return

300 continue
400 continue
    call get_array(rp, value)
    if (associated(rp)) then
        call put_attr(var, name, rp, err)
        deallocate(rp)
    endif
    return
end subroutine
