! GrADS t@C̋@\

module gr_file

    use iso_varying_string, only: VARYING_STRING
    implicit none

    ! ͒PAXgŕ\B
    type GR_ATTR_ENTRY
        character(len = 8):: var
        type(VARYING_STRING):: attr
        type(VARYING_STRING):: value
        type(GR_ATTR_ENTRY), pointer:: next
    end type

    type GR_FILE_ENTRY
        integer:: id
        integer:: count
        logical:: writable
        type(VARYING_STRING):: ctlfile
        type(VARYING_STRING):: dsetfile
        type(GR_FILE_ENTRY), pointer:: next
        ! Rg[t@C
        type(VARYING_STRING):: title
        real:: undef
        ! ϐ4
        real, pointer:: lon(:)
        real, pointer:: lat(:)
        real, pointer:: lev(:)
        character(len = 16):: time_origin
        character(len = 2):: time_unit
        integer:: time_step
        integer:: time_count
        ! ϐ\
        integer:: nvars
        character(len = 8), pointer:: varname(:)
        type(VARYING_STRING), pointer:: vardesc(:)
        integer, pointer:: levels(:)
        ! \
        type(GR_ATTR_ENTRY), pointer:: attr_table
    end type

    type(GR_FILE_ENTRY), save, pointer:: file_table_head
    logical, save:: file_table_used = .FALSE.

contains

    type(VARYING_STRING) function GRFileName(fileid) result(result)
        use iso_varying_string
        use dc_error
        integer, intent(in):: fileid
        type(GR_FILE_ENTRY), pointer:: cursor
        if (.not. file_table_used) goto 999
        cursor => file_table_head
        do
            if (.not. associated(cursor)) exit
            if (cursor%id == fileid) then
                result = cursor%ctlfile
                return
            endif
            cursor => cursor%next
        enddo
        999 continue
        call StoreError(GR_ENOTGR, "GRFileName")
    end function

    subroutine GRFileOpen(fileid, filename, writable, overwrite, stat, err)
        use iso_varying_string
        use netcdf_f77
        use dc_error
        use dcl, only: DclGetUnitNum
        implicit none
        integer, intent(out):: fileid
        character(len = *), intent(in):: filename
        logical, intent(in), optional:: writable
        logical, intent(in), optional:: overwrite
        logical, intent(out), optional:: err
        integer, intent(out), optional:: stat
        logical:: writable_required
        logical:: overwrite_required
        type(GR_FILE_ENTRY), pointer:: cursor, prev
        integer:: mystat
        integer:: recl
        character(len = 7):: new
        character(len = 256):: dsetname
    continue
        writable_required = .FALSE.
        if (present(writable)) writable_required = writable
        if (present(overwrite)) then
            writable_required = .TRUE.
            overwrite_required = overwrite
        else
            overwrite_required = .FALSE.
        endif
        !
        ! Oŏ݉\KĂ open Ȃōς܂
        !
        if (file_table_used) then
            cursor => file_table_head
            nullify(prev)
            do
                if ((cursor%ctlfile == filename) &
                .and. (cursor%writable .or. .not. writable_required)) then
                    fileid = cursor%id
                    cursor%count = cursor%count + 1
                    if (present(err)) err = .FALSE.
                    return
                endif
                prev => cursor
                cursor => cursor%next
                if (.not. associated(cursor)) exit
            enddo
            allocate(cursor)
            prev%next => cursor
        else
            nullify(prev)
            allocate(file_table_head)
            cursor => file_table_head
            file_table_used = .TRUE.
        endif
        nullify(cursor%next)
        cursor%ctlfile = filename
        cursor%writable = writable_required
        cursor%count = 1
        call grads_dset_name(dsetname, filename, mystat)
        cursor%dsetfile = trim(dsetname)

        inquire(iolength=recl) 0.0
        cursor%id = DclGetUnitNum()
        if (.not. writable_required) then
            open(unit=cursor%id, file=dsetname, access="DIRECT", recl=recl, &
                form="UNFORMATTED", status="OLD", action="READ", iostat=mystat)
        else
            open(unit=cursor%id, file=dsetname, access="DIRECT", recl=recl, &
                form="UNFORMATTED", status="OLD", action="READWRITE", iostat=mystat)
            if (mystat /= 0) then
                new = "NEW"
                if (overwrite_required) new = "REPLACE"
                open(unit=cursor%id, file=dsetname, access="DIRECT", recl=recl, &
                    form="UNFORMATTED", status=new, action="READWRITE", iostat=mystat)
            endif
        endif
        fileid = cursor%id

        ! sĂ
        if (mystat /= 0) then
            if (associated(prev)) then
                prev%next => cursor%next
            else
                file_table_head => cursor%next
                if (.not. associated(file_table_head)) file_table_used = .FALSE.
            endif
            deallocate(cursor)
            fileid = -1
        endif

        if (present(stat)) then
            stat = mystat
            if (present(err)) err = (stat /= 0)
        else if (present(err)) then
            err = (stat /= 0)
        else
            call StoreError(mystat, 'GrFileOpen', err, cause_s=var_str(filename))
        endif
    end subroutine

end module