! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
! NCbNr[A

program gtview
    use gtool
    implicit none
    type(VARYING_STRING):: argument, optname, optvalue, figure_title
    type(GT_OBJECT):: it
    type(GT_FIGURE):: fig
    type(GT_DEVICE):: dev
    integer:: i
    logical:: arg_given = .FALSE.
    logical:: save_mode = .FALSE.
    logical:: disp_mode = .TRUE.
    logical:: err
continue
    figure_title = ""
    call Open(fig)
    call Clear(it)
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (GtOptionForm(argument, optname, optvalue)) then
            if (optname == 'wsn') then
                gtdev_wsn_default = stoi(optvalue)
            else if (optname == '-save') then
                save_mode = .TRUE.
            else if (optname == '-batch') then
                disp_mode = .FALSE.
                save_mode = .TRUE.
            else if (optname == "title") then
                figure_title = optvalue
            else
                call Option(it, char(optname), char(optvalue), err=err)
                if (err) print *, "option ", char(argument), " ignored"
            endif
        else
            if (arg_given) call Put(fig, it)
            arg_given = .TRUE.
            call Open(it, argument)
        endif
    enddo
    if (.not. arg_given) then
        argument = ""
        call Open(it, argument)
    endif
    call Put(fig, it)
    if (figure_title /= "") fig%title = figure_title
    ! 悢 figure ̗p
    if (disp_mode) then
        call Open(dev)
        call Display(dev, fig)
    endif
    if (save_mode) call Save(fig)
    call Close(fig)
    if (disp_mode) call Close(dev)
end program

