! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtattr - ݒc[

program gtattr
    use gtool
    implicit none
    type(VARYING_STRING):: argument
    type(VARYING_STRING):: optname, optvalue
    type(GT_VARIABLE):: var
    logical:: var_opened = .FALSE.
    integer:: i, j, argc
continue
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (GtOptionForm(argument, optname, optvalue)) then
            if (optname == "-type") then
                print *, "option -type will be implemented"
            else if (optname == "-delete") then
                print *, "option -delete will be implemented"
            else if (var_opened .and. index(optname, "-") /= 1) then
                call put_attr(var, char(optname), optvalue)
            else
                print *, "option ", char(optvalue), " ignored"
            endif
        else if (.not. var_opened) then
            call Open(var, argument, writable=.TRUE.)
            var_opened = .TRUE.
        else
            print *, "will be implemented: setting variable value"
        endif
    enddo
    if (var_opened) then
        call Close(var)
    else
        write(*, *) 'usage: gtattr {varname} [attr=value] ...'
    endif
end program