! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTObjectOpen(obj, varname)
    use iso_varying_string
    use gtgraph_types, only: GT_OBJECT
    use gtdata_types, only: GT_VARIABLE
    use dc_error
    use gtdata_generic
    use gtgraph_generic, only: Open, Line, Contours, Clear
    type(GT_OBJECT), intent(out):: obj
    type(VARYING_STRING), intent(in):: varname
    type(GT_VARIABLE):: var
continue
    call Clear(obj)
    call Open(var, varname)
    select case(ndims(var))
    case(1)
        allocate(obj%line)
        obj%line = Line(var)
    case(2:)
        allocate(obj%cont)
        obj%cont = Contours(var)
    case default
        call StoreError(GT_EFAKE, 'GtObjectOpen(ndims = 0)')
    end select
end subroutine

subroutine GtObjectClear(obj)
    use gtgraph_types, only: GT_OBJECT
    type(GT_OBJECT), intent(out):: obj
    nullify(obj%var, obj%axis, obj%cont, obj%line)
    nullify(obj%fig, obj%frame, obj%dev)
end subroutine

subroutine GtObjectOption(obj, optname, value, err)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Option
    type(GT_OBJECT), intent(inoutw):: obj
    character(len = *), intent(in):: optname
    character(len = *), intent(in):: value
    logical, intent(out):: err
continue
    if (associated(obj%cont)) then
        call Option(obj%cont, optname, value, err)
    else if (associated(obj%line)) then
        call Option(obj%line, optname, value, err)
    else
        err = .TRUE.
    endif
end subroutine