! R}hCIvV
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gt_args

    private

    interface

        subroutine GtArgGet(ord, value, default)
            use iso_varying_string, only: VARYING_STRING
            integer, intent(in):: ord
            type(VARYING_STRING), intent(out):: value
            character(len = *), intent(in), optional:: default
        end subroutine

        integer function GtArgCount()
        end function

    end interface

    public:: GTOptionForm, GtoolArgument, GtArgCount, GtArgGet, GtOptionLineIndex

contains

    subroutine GtOptionLineIndex(idx, optname, optvalue, err)
        use dc_string, only: toUpper, stoi
        integer, intent(inout):: idx
        character(len = *), intent(in):: optname
        character(len = *), intent(in):: optvalue
        logical, intent(out):: err
        character(len = len(optname)):: uc_name
        character(len = len(optvalue)):: uc_value
    continue
        uc_name = optname
        uc_value = optvalue
        call toUpper(uc_name)
        call toUpper(uc_value)
        if (uc_name == "COLOR" .or. uc_name == "COLOUR") then
            select case(uc_value)
            case("FG", "WHITE", "BLACK")
                idx = mod(idx, 10) + 10
            case("RED")
                idx = mod(idx, 10) + 20
            case("GREEN")
                idx = mod(idx, 10) + 30
            case("BLUE")
                idx = mod(idx, 10) + 40
            case("YELLOW")
                idx = mod(idx, 10) + 50
            case default
                idx = mod(idx, 10) + 10 * stoi(uc_value)
            end select
        else if (uc_name == "THICKNESS" .or. uc_name == "LINEWIDTH") then
            select case(uc_value)
            case("THIN")
                idx = idx - mod(idx, 10) + 1
            case("MEDIUM")
                idx = idx - mod(idx, 10) + 3
            case("THICK")
                idx = idx - mod(idx, 10) + 5
            case default
                idx = idx - mod(idx, 10) + stoi(uc_value)
            end select
        else if (uc_name == "INDEX" .or. uc_name == "LINEINDEX") then
            select case(uc_value)
            case("FG", "WHITE", "BLACK")
                idx = 10
            case("RED")
                idx = 20
            case("GREEN")
                idx = 30
            case("BLUE")
                idx = 40
            case("YELLOW")
                idx = 50
            case("THIN")
                idx = 1
            case("MEDIUM")
                idx = 3
            case("THICK")
                idx = 5
            case default
                idx = stoi(uc_value)
            end select
        else
            err = .TRUE.
            return
        endif
        err = .FALSE.
    end subroutine

        logical function &
    GTOptionForm(argument, name, value) result(result)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: argument
        type(VARYING_STRING), intent(out):: name, value
    continue
        if (extract(argument, 1, 1) == '-') then
            name = argument
            value = ""
            result = .TRUE.
        else
            result = NameValueForm(argument, name, value)
        endif            
    end function

    ! Ȃ K&R X^C :) 
        logical function &
    NameValueForm(argument, name, value) result(result)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: argument
        type(VARYING_STRING), intent(out):: name, value
        character(len = *), parameter:: WORDCHARS &
            = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_:"
        integer:: i
    continue
        i = index(argument, "=")
        if (i == 0) goto 999
        name = extract(argument, 1, i - 1)
        if (verify(name, WORDCHARS) /= 0) goto 999
        result = .TRUE.
        value = extract(argument, i + 1)
        return

    999 continue
        result = .FALSE.
        name = ""
        value = ""
    end function

    type(VARYING_STRING) function GtoolArgument(ord, default) result(result)
        use iso_varying_string, only: VARYING_STRING
        integer, intent(in):: ord
        character(len = *), intent(in), optional:: default
        call GtArgGet(ord, result, default)
    end function

end module
