! gtadd.f90 - ZvO
! vi: set sw=4 ts=8:

program gtadd
    use gtool
    type(VARYING_STRING):: lhs_name, rhs_name, output_name
    type(GT_VARIABLE):: lhs, rhs, output
continue
    lhs_name = GtoolArgument(1, default="gtool.nc#1")
    rhs_name = GtoolArgument(2, default="gtool.nc#2")
    output_name = GtoolArgument(3, default="gtool.nc#out")
    call Open(lhs, lhs_name)
    call Open(rhs, rhs_name)
    call Open(output, output_name)
    call BinaryOperate(lhs, rhs, output)
    call Close(lhs)
    call Close(rhs)
    call Close(output)
contains

    subroutine BinaryOperate(lhs, rhs, output)
	type(GT_VARIABLE), intent(in):: lhs, rhs
	type(GT_VARIABLE), intent(inout):: output
	real, pointer:: lhs_buf(:), rhs_buf(:), out_buf(:)
	integer:: siz
    continue
	siz = Size(lhs)
	if (Size(rhs) /= siz) then
	    print *, 'BinaryOperation not work (1)'
	    stop
	endif
	if (Size(output) /= siz) then
	    print *, 'BinaryOperation not work (2)'
	    stop
	endif
	allocate(lhs_buf(siz), rhs_buf(siz), out_buf(siz))
	if (.not. GtoolGetReal(lhs, lhs_buf, size(lhs_buf))) goto 999
	if (.not. GtoolGetReal(rhs, rhs_buf, size(rhs_buf))) goto 999

	out_buf(:) = lhs_buf(:) + rhs_buf(:)

	if (.not. GtoolPutReal(output, out_buf, size(out_buf))) goto 999
	return
    999 continue
    	call AbortProgram
    end subroutine

end program
