! gtlinelib.f90 - IuWFNg̎舵

type(GT_LINE) function GTLineDefault(var) result(result)
    use gtgraph_types, only: GT_LINE
    use gtgraph_generic, only: Axis
    use gtdata_types, only: GT_VARIABLE
    type(GT_VARIABLE), intent(in):: var
    result%var = var
    allocate(result%h_axis, result%v_axis)
    result%v_axis = Axis(var, 0)
    result%h_axis = Axis(var, 1)
end function

subroutine GTFigPutLine(fig, line)
    use gtgraph_types, only: GT_FIGURE, GT_LINE
    use gtdata_generic, only: get_attr, name
    use iso_varying_string
    use dc_error
    type(GT_FIGURE), intent(inout):: fig
    type(GT_LINE), intent(in):: line
    type(GT_LINE), pointer:: newlines(:)
    type(VARYING_STRING):: title
    integer:: nlines, stat
    stat = GT_EFAKE
    if (associated(fig%h_axis) .or. associated(fig%v_axis)) goto 999
    fig%h_axis => line%h_axis
    fig%v_axis => line%v_axis
    !
    call get_attr(line%var, 'long_name', title)
    if (title == '') title = Name(line%var)
    if (fig%title == "untitled") then
        fig%title = title
    else
        fig%title = fig%title // ", " // title
    endif
    !
    stat = 0
    if (associated(fig%line)) then
        nlines = size(fig%line)
        allocate(newlines(nlines + 1))
        newlines(1: nlines) = fig%line(1: nlines)
        deallocate(fig%line)
    else
        nlines = 0
        allocate(newlines(1))
    endif
    newlines(nlines + 1) = line
    fig%line => newlines
    999 continue
    call StoreError(stat, 'GTFigPutLine')
end subroutine

subroutine GTLineDraw(line, parent)
    use gtgraph_types, only: GT_LINE, GT_FIGURE
    use gtgraph_generic, only: Draw
    use gtdata_generic, only: Get
    use dcl
    type(GT_LINE), intent(inout):: line
    type(GT_FIGURE), intent(in):: parent
    real, pointer:: value(:)
    real, pointer:: abscissa(:)
    call Draw(line%h_axis, line%v_axis, parent)
    call Get(line%var, value)
    call Get(line%h_axis%var, abscissa)
    ! Ot̕`
    call DclDrawLine(abscissa, value)
    deallocate(abscissa, value)
end subroutine
