! dc_string.f90 - character type support routines
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module dc_string

    use iso_varying_string
    implicit none

    interface stoi
        module procedure stoi_scalar
    end interface

    interface stod
        module procedure stod_scalar
    end interface

    interface toString
        module procedure itos_scalar
        module procedure itos_array
        module procedure dtos_scalar
        module procedure dtos_array
    end interface

    interface
        type(VARYING_STRING) function GTStringQuoteForDcl(string)
            use iso_varying_string, only: VARYING_STRING
            type(VARYING_STRING), intent(in):: string
        end function
    end interface

    interface EquivNoCase
        module procedure strcmpi_sc
        module procedure strcmpi_cc
    end interface

contains

    logical function strcmpi_cc(string_a, string_b) result(result)
        use dcl, only: DclToUpper
        character(len = *), intent(in):: string_a
        character(len = *), intent(in):: string_b
        character(len = len(string_a)):: abuf
        character(len = len(string_b)):: bbuf
        abuf = string_a
        bbuf = string_b
        call DclToUpper(abuf)
        call DclToUpper(bbuf)
        result = (abuf == bbuf)
    end function

    logical function strcmpi_sc(string_a, string_b) result(result)
        type(VARYING_STRING), intent(in):: string_a
        character(len = *), intent(in):: string_b
        result = strcmpi_cc(char(string_a), string_b)
    end function

    integer function stoi_scalar(string) result(result)
        type(VARYING_STRING), intent(in):: string
        integer:: ios
        character(len = 80):: buffer
    continue
        buffer = string
        read(unit=buffer, fmt="(i80)", iostat=ios) result
        if (ios /= 0) result = 0
    end function

    double precision function stod_scalar(string) result(result)
        type(VARYING_STRING), intent(in):: string
        integer:: ios
        character(len = 80):: buffer
        integer:: ipoint, iexp
        intrinsic scan
    continue
        buffer = string
        ! 萔Ă܂ꍇ͏_𕍉
        if (index(buffer, '.') == 0) then
            iexp = scan(buffer, "eEdD")
            if (iexp /= 0) then
                buffer(iexp+1: len(buffer)) = buffer(iexp: len(buffer)-1)
                ipoint = iexp
            else
                ipoint = len_trim(buffer) + 1
            endif
            buffer(ipoint: ipoint) = '.'
        endif
        read(unit=buffer, fmt="(g80.10)", iostat=ios) result
        if (ios /= 0) result = 0.0
    end function

    !
    ! --- numerics to string ---
    !

    type(VARYING_STRING) function itos_scalar(i) result(result)
        integer, intent(in):: i
        character(len = 30):: buffer
    continue
        write(unit=buffer, fmt="(i30)") i
        result = trim(adjustl(buffer))
    end function

    type(VARYING_STRING) function itos_array(ibuf) result(result)
        integer, intent(in):: ibuf(:)
        integer:: i
    continue
        if (size(ibuf) <= 0) then
            result = ""
            return
        endif
        result = toString(ibuf(1))
        do, i = 2, size(ibuf)
            result = result // ", " // toString(ibuf(i))
        enddo
    end function

    type(VARYING_STRING) function dtos_scalar(d) result(result)
        double precision, intent(in):: d
        character(len = 40):: buffer
    continue
        write(unit=buffer, fmt="(g40.30)") d
        result = trim(adjustl(buffer))
    end function

    type(VARYING_STRING) function dtos_array(dbuf) result(result)
        double precision, intent(in):: dbuf(:)
        integer:: i
    continue
        if (size(dbuf) <= 0) then
            result = ""
            return
        endif
        result = toString(dbuf(1))
        do, i = 2, size(dbuf)
            result = result // ", " // toString(dbuf(i))
        enddo
    end function


end module
