! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
! NCbNr[A

program gtview
    use gtool
    use dc_string, only: stoi
    implicit none
    type(VARYING_STRING):: argument, optname, optvalue
    type(GT_OBJECT):: it
    type(GT_FIGURE):: fig
    type(GT_DEVICE):: dev
    integer:: i
    logical:: arg_given = .FALSE.
    logical:: save_mode = .FALSE.
    logical:: disp_mode = .TRUE.
continue
    call Open(fig)
    call OpenObject(it)
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (extract(argument, 1, 1) == '-') then
            if (argument == '-save') then
                save_mode = .TRUE.
            else if (argument == '-batch') then
                disp_mode = .FALSE.
                save_mode = .TRUE.
            else if (argument == '-shade') then
		if (associated(it%cont)) it%cont%shade = .TRUE.
            else if (argument == '-noshade') then
		if (associated(it%cont)) it%cont%shade = .FALSE.
            else if (argument == '-nocont') then
		if (associated(it%cont)) it%cont%contours = .FALSE.
            else
                print *, "boolean option ", char(argument), " ignored"
            endif
        else if (NameValueForm(argument, optname, optvalue)) then
            if (optname == 'wsn') then
                gtdev_wsn_default = stoi(optvalue)
            else
                print *, "assignment option ", char(argument), " ignored"
            endif
        else
	    if (arg_given) call PutObject(fig, it)
            arg_given = .TRUE.
	    call OpenObject(it, argument)
        endif
    enddo
    if (.not. arg_given) then
        argument = ""
	call OpenObject(it, argument)
    endif
    call PutObject(fig, it)
    ! 悢 figure ̗p
    if (disp_mode) then
        call Open(dev)
        call Display(dev, fig)
    endif
    if (save_mode) call Save(fig)
    call Close(fig)
    if (disp_mode) call Close(dev)
contains

    ! Ȃ K&R X^C :) 
        logical function &
    NameValueForm(argument, name, value) result(result)
        type(VARYING_STRING), intent(in):: argument
        type(VARYING_STRING), intent(out):: name, value
        character(len = *), parameter:: WORDCHARS &
            = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_:"
        integer:: i
    continue
        i = index(argument, "=")
        if (i == 0) goto 999
        name = extract(argument, 1, i - 1)
        if (verify(name, WORDCHARS) /= 0) goto 999
        result = .TRUE.
        value = extract(argument, i + 1)
        return

    999 continue
        result = .FALSE.
        name = ""
        value = ""
    end function

    subroutine OpenObject(obj, varname)
        use dc_error
	type(GT_OBJECT), intent(out):: obj
        type(VARYING_STRING), intent(in), optional:: varname
        type(GT_VARIABLE):: var
	nullify(obj%var, obj%axis, obj%cont, obj%line)
	nullify(obj%fig, obj%frame, obj%dev)
	if (.not. present(varname)) return
        call Open(var, varname)
        select case(ndims(var))
        case(1)
	    allocate(obj%line)
            obj%line = Line(var)
        case(2:)
	    allocate(obj%cont)
	    obj%cont = Contours(var)
        case default
            call StoreError(GT_EFAKE, 'BuildPutFigure(ndims = 0)')
        end select
    end subroutine

    subroutine PutObject(fig, obj)
        type(GT_FIGURE), intent(inout):: fig
	type(GT_OBJECT), intent(inout):: obj
	if (associated(obj%line)) then
	    call Put(fig, obj%line)
	else if (associated(obj%cont)) then
	    call Put(fig, obj%cont)
	endif
    end subroutine

end program

