! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
! NCbNr[A

program gtview
    use gtool
    use dc_string, only: stoi
    implicit none
    type(VARYING_STRING):: argument, optname, optvalue
    type(GT_FIGURE):: fig
    type(GT_DEVICE):: dev
    integer:: i
    logical:: arg_given = .FALSE.
    logical:: save_mode = .FALSE.
continue
    call Open(fig)
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (extract(argument, 1, 1) == '-') then
            if (argument == '-save') then
                save_mode = .TRUE.
            else
                print *, "boolean option ", char(argument), " ignored"
            endif
        else if (NameValueForm(argument, optname, optvalue)) then
            if (optname == 'wsn') then
                gtdev_wsn_default = stoi(optvalue)
            else
                print *, "assignment option ", char(argument), " ignored"
            endif
        else
            arg_given = .TRUE.
            call BuildPutFigure(fig, argument)
        endif
    enddo
    if (.not. arg_given) then
        call BuildPutFigure(fig, var_str("gtool.nc"))
    endif
    call Open(dev)
    call Display(dev, fig)
    if (save_mode) call Save(fig)
    call Close(fig)
    call Close(dev)
contains

    ! Ȃ K&R X^C :) 
        logical function &
    NameValueForm(argument, name, value) result(result)
        type(VARYING_STRING), intent(in):: argument
        type(VARYING_STRING), intent(out):: name, value
        character(len = *), parameter:: WORDCHARS &
            = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_:"
        integer:: i
    continue
        i = index(argument, "=")
        if (i == 0) goto 999
        name = extract(argument, 1, i - 1)
        if (verify(name, WORDCHARS) /= 0) goto 999
        result = .TRUE.
        value = extract(argument, i + 1)
        return

    999 continue
        result = .FALSE.
        name = ""
        value = ""
    end function

    subroutine BuildPutFigure(fig, varname)
        use dc_error
        type(VARYING_STRING), intent(in):: varname
        type(GT_FIGURE), intent(inout):: fig
        type(GT_VARIABLE):: var
        call Open(var, varname)
        select case(ndims(var))
        case(1)
            call Put(fig, Line(var))
        case(2:)
            call Put(fig, Contours(var))
        case default
            call StoreError(GT_EFAKE, 'BuildPutFigure(ndims = 0)')
        end select
    end subroutine
end program

