! gtgraph_types.f90 - gtgraph w̌^錾
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_types

    use iso_varying_string, only: VARYING_STRING
    use gtdata_types, only: GT_VARIABLE

    type GT_AXIS
        type(GT_VARIABLE):: var
        real:: lower
        real:: upper
        logical:: vertical
        type(VARYING_STRING):: title
        type(VARYING_STRING):: units
    end type

    type GT_CONTOURS
        type(GT_VARIABLE):: var
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
        real:: interval
    end type

    type GT_LINE
        type(GT_VARIABLE):: var
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
    end type

    type GT_FIGURE
        type(GT_AXIS), pointer:: h_axis
        type(GT_AXIS), pointer:: v_axis
        type(GT_CONTOURS), pointer:: contours(:)
        type(GT_LINE), pointer:: line(:)
        type(VARYING_STRING):: title
    end type

    type GT_FRAME
        type(GT_FIGURE), pointer:: figs(:)
        type(VARYING_STRING):: title
        logical:: first_figure
    end type

    type GT_DEVICE
        integer:: ws_id
    end type

end module
