! anvarslices4.f90 - slice(AN_VARIABLE, VARYING_STRING * 4)
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine ANVarSliceS4(var, dimname, lower, upper, interval)
    use an_types, only: AN_VARIABLE
    use iso_varying_string
    use netcdf_f77
    use dc_error
    use dc_string, only: stod, stoi
    use an_generic, only: Slice, get_slice
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: dimname
    type(VARYING_STRING), intent(in):: lower
    type(VARYING_STRING), intent(in):: upper
    type(VARYING_STRING), intent(in):: interval
    integer:: id, idim, istart, icount, istride, stat, idx
    character(len = NF_MAX_NAME):: dimname_try
    real, pointer:: dimvalue(:)
continue
    stat = 0
    idim = 0
    nullify(dimvalue)
    do, id = 1, size(var%dimids)
        stat = nf_inq_dimname(var%fileid, var%dimids(id), dimname_try)
        if (stat /= NF_NOERR) goto 999
        if (dimname == dimname_try) then 
            idim = id
            exit
        endif
    enddo
    if (idim == 0) then
        idim = id
        stat = GT_ENOMOREDIMS;  goto 999
    endif
    ! ݂
    ! ̏
    if (lower == "" .or. lower == "^") then
        continue  ! 󕶎Ȃ牽Ȃ
    else if (index(lower, '^') == 1) then
        istart = stoi(extract(lower, 2))
        call Slice(var, idim, start=istart)
    else
        call build_value_table
        istart = lookup_floor_index(stod(lower))
        call Slice(var, idim, start=istart)
    endif
    ! Ԋȕ
    if (interval == "" .or. interval == "^") then
        continue
    else if (index(interval, "^") == 1) then
        istride = stoi(extract(interval, 2))
        call Slice(var, idim, stride=istride)
    else
        istride = ceiling(stod(interval) / average_stride())
        call Slice(var, idim, stride=istride)
    endif
    ! [̏
    if (upper == "" .or. upper == "^") then
        continue
    else if (index(upper, "^") == 1) then
        call get_slice(var, idim, start=istart, stride=istride)
        icount = (stoi(extract(upper, 2)) - istart) / istride
        call Slice(var, idim, count=icount)
    else
        call get_slice(var, idim, start=istart, stride=istride)
        idx = lookup_ceiling_index(stod(upper))
        if (idx > istart) then
            icount = (idx - istart) / istride + 1
        else
            ! ϐlPȏꍇ
            icount = (istart - idx) / istride + 1
            istart = idx
        endif
        call Slice(var, idim, start=istart, count=icount)
    endif
    ! n
999 continue
    if (associated(dimvalue)) deallocate(dimvalue)
    call StoreError(stat, "ANVarSliceS4", cause_i=idim)
    return
contains

    subroutine build_value_table
        use an_generic, only: Open, Get, Close
        type(AN_VARIABLE):: dimvar
        if (associated(dimvalue)) return
        call Open(dimvar, var, idim)
        call Get(dimvar, dimvalue)
        call Close(dimvar)
    end subroutine

    real function average_stride() result(result)
        call build_value_table
        result = (dimvalue(1) - dimvalue(size(dimvalue))) / max(1, size(dimvalue) - 1)
        if (abs(result) < epsilon(result)) result = epsilon(result)
    end function

    ! ȉ̌֐͒PEPɑΉ

    integer function lookup_floor_index(value) result(result)
        double precision:: value
        integer:: i
        logical:: search_big
    continue
        search_big = dimvalue(1) < value
        do, i = 1, size(dimvalue)
            if (dimvalue(i) == value) then
                result = i;  exit  
            endif
            if (search_big) then
                if (dimvalue(i) > value) then
                    result = i - 1;  exit
                endif
            else
                if (dimvalue(i) < value) then
                    result = i - 1;  exit
                endif
            endif
        enddo
        if (result == size(dimvalue)) result = 0
    end function

    integer function lookup_ceiling_index(value) result(result)
        double precision:: value
        integer:: i
        logical:: search_big
    continue
        search_big = (dimvalue(size(dimvalue)) < value)
        do, i = size(dimvalue), 1, -1
            if (dimvalue(i) == value) then
                result = i;  return    
            endif
            if (search_big) then
                if (dimvalue(i) > value) then
                    result = i + 1;  return    
                endif
            else
                if (dimvalue(i) < value) then
                    result = i + 1;  return    
                endif
            endif
        enddo
        if (result == size(dimvalue)) result = 0
    end function

end subroutine
