subroutine ANVarAttrRewind(var)
    use an_types, only: AN_VARIABLE
    use dc_error, only: GT_EFAKE, StoreError
    type(AN_VARIABLE), intent(in):: var
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

subroutine ANVarAttrNext(var, name, end)
    use an_types, only: AN_VARIABLE
    use iso_varying_string
    use dc_error, only: StoreError, GT_EFAKE
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(out):: name
    logical, intent(out), optional:: end
    name = ''
    call StoreError(GT_EFAKE, 'ANVarAttrNext', err=end)
end subroutine

logical function ANVarAttrTrue(var, name, default) result(result)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    logical, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarAttrTrue')
    result = .FALSE.
end function


subroutine ANVarGetAttrReal(var, name, value, default)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    real, intent(out):: value(:)
    real, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarGetAttrReal')
    value(:) = -999.0
end subroutine

subroutine ANVarGetAttrInt(var, name, value, default)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    integer, intent(out):: value(:)
    integer, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarGetAttrInt')
    value(:) = -999
end subroutine



subroutine ANVarPutAttrReal(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error, only: GT_EFAKE, StoreError
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    real, intent(in):: value(:)
    logical, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarPutAttrReal', err)
end subroutine

subroutine ANVarPutAttrInt(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    integer, intent(in):: value(:)
    logical, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarPutAttrInt', err)
end subroutine

subroutine ANVarPutAttrLogical(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error, only: GT_EFAKE, StoreError
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    logical, intent(in):: value
    logical, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarPutAttrLogical', err)
end subroutine
