! gtaxisdefault.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

type(GT_AXIS) function GTAxisDefault(base_var, dimno, vertical) result(result)
    use gtgraph_types, only: GT_AXIS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open, ndims, get, name, get_attr
    use iso_varying_string
    type(GT_VARIABLE), intent(in):: base_var
    integer, intent(in):: dimno
    logical, intent(in), optional:: vertical
    real, pointer:: values(:)
continue
    call Open(result%var, base_var, dimno)
    ! c
    result%vertical = .FALSE.
    if (present(vertical)) result%vertical = vertical
    ! ̏㉺ݒ
    call get(result%var, values)
    result%upper = maxval(values)
    result%lower = minval(values)
    deallocate(values)
    ! 擾
    call get_attr(result%var, 'long_name', result%title)
    if (result%title == '') result%title = Name(result%var)
    ! PʂɊւĂ͂ GT_VARIABLE 
    ! C^[tFCXׂł
    call get_attr(result%var, 'units', result%units)
    if (result%units == '') then
        call get_attr(result%var, 'unit', result%units, &
            default="units not given")
    endif
end function

! ݂̂ƂKW 2 ΂ŕ`悳Ȃ΂ȂȂB

subroutine GTAxesDraw(h_axis, v_axis, parent)
    use gtgraph_types, only: GT_AXIS, GT_FIGURE
    use iso_varying_string
    use dc_string, only: QuoteDclControls
    use dcl
    implicit none
    type(GT_AXIS), intent(in):: h_axis, v_axis
    type(GT_FIGURE), intent(in):: parent
    type(VARYING_STRING):: xtitle, ytitle, xunits, yunits
continue
    call DclSetWindow(h_axis%lower, h_axis%upper, &
        v_axis%lower, v_axis%upper)
    call DclSetTransFunction()
    xtitle = QuoteDclControls(h_axis%title)
    ytitle = QuoteDclControls(v_axis%title)
    xunits = QuoteDclControls(h_axis%units)
    yunits = QuoteDclControls(v_axis%units)
    call DclSetTitle(char(xtitle), char(ytitle), &
        char(xunits), char(yunits))
    call DclDrawScaledAxis
end subroutine


subroutine GTAxisClose(axis)
    use gtgraph_types, only: GT_AXIS
    use gtdata_generic, only: Close
    type(GT_AXIS), intent(inout):: axis
continue
    call Close(axis%var)
end subroutine