subroutine ANVarCreate(var, url, type, dims, overwrite, err)
    use iso_varying_string, only: VARYING_STRING    
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileOpen
    use an_url, only: ANUrlSplit
    use dc_error, only: StoreError
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: url
    character(len = *), intent(in):: type
    type(AN_VARIABLE), intent(in):: dims
    logical, intent(in), optional:: overwrite
    logical, intent(out), optional:: err
    type(VARYING_STRING):: filename, varname
    integer:: stat
continue
    call ANUrlSplit(url, filename, varname)
    call ANFileOpen(var%fileid, filename, err=err, writable=.TRUE.)
    if (present(err)) then
        if (err) return
    endif
    call StoreError(stat, 'ANVarOpen', err)
end subroutine
